/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceTagsDeltaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceTagsDeltaUtil.class);
    private static final Logger PERF_TAGS_DELTA_LOG = RangerPerfTracer.getPerfLogger("tags.delta");

    private RangerServiceTagsDeltaUtil() {
    }

    public static ServiceTags applyDelta(ServiceTags serviceTags, ServiceTags delta, boolean supportsTagsDedup) {
        LOG.debug("==> RangerServiceTagsDeltaUtil.applyDelta(): serviceTags:[{}], delta:[{}], supportsTagsDedup:[{}]", new Object[]{serviceTags, delta, supportsTagsDedup});
        ServiceTags ret = serviceTags;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TAGS_DELTA_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TAGS_DELTA_LOG, "RangerServiceTagsDeltaUtil.applyDelta()");
        }
        if (serviceTags != null && !serviceTags.getIsDelta().booleanValue() && delta != null && delta.getIsDelta().booleanValue()) {
            ret = new ServiceTags(serviceTags);
            ret.setServiceName(delta.getServiceName());
            ret.setTagVersion(delta.getTagVersion());
            ret.setIsTagsDeduped(delta.getIsTagsDeduped());
            int tagDefsAdded = 0;
            int tagDefsUpdated = 0;
            int tagDefsRemoved = 0;
            int tagsAdded = 0;
            int tagsUpdated = 0;
            int tagsRemoved = 0;
            Map<Long, RangerTagDef> tagDefs = ret.getTagDefinitions();
            for (Map.Entry<Long, RangerTagDef> entry : delta.getTagDefinitions().entrySet()) {
                RangerTagDef existing;
                RangerTagDef removedTagDef;
                Long deltaTagDefId = entry.getKey();
                RangerTagDef rangerTagDef = entry.getValue();
                if (StringUtils.isEmpty((String)rangerTagDef.getName()) && (removedTagDef = tagDefs.remove(deltaTagDefId)) != null) {
                    ++tagDefsRemoved;
                }
                if ((existing = tagDefs.put(deltaTagDefId, rangerTagDef)) == null) {
                    ++tagDefsAdded;
                    continue;
                }
                if (existing.equals(rangerTagDef)) continue;
                ++tagDefsUpdated;
            }
            Map<Long, RangerTag> tags = ret.getTags();
            HashMap<Long, Object> replacedTagIds = new HashMap<Long, Object>();
            for (Map.Entry entry : delta.getTags().entrySet()) {
                Object object;
                Iterator<Object> iterator;
                Long deltaTagId = (Long)entry.getKey();
                RangerTag deltaTag = (RangerTag)entry.getValue();
                if (StringUtils.isEmpty((String)deltaTag.getType())) {
                    if (supportsTagsDedup) {
                        boolean found = false;
                        iterator = ret.cachedTags.entrySet().iterator();
                        while (iterator.hasNext()) {
                            MutablePair mutablePair = (MutablePair)((Map.Entry)iterator.next()).getValue();
                            if (!((Long)mutablePair.left).equals(deltaTagId)) continue;
                            object = mutablePair;
                            object.right = (Long)object.right - 1L;
                            if ((Long)object.right == 0L) {
                                if (tags.remove(deltaTagId) != null) {
                                    ++tagsRemoved;
                                }
                                iterator.remove();
                            }
                            found = true;
                            break;
                        }
                        if (found || tags.remove(deltaTagId) == null) continue;
                        ++tagsRemoved;
                        continue;
                    }
                    if (tags.remove(deltaTagId) == null) continue;
                    ++tagsRemoved;
                    continue;
                }
                if (supportsTagsDedup) {
                    MutablePair<Long, Long> cachedTag = ret.cachedTags.get(deltaTag);
                    if (cachedTag == null) {
                        ret.cachedTags.put(deltaTag, (MutablePair<Long, Long>)new MutablePair((Object)deltaTagId, (Object)1L));
                        tags.put(deltaTagId, deltaTag);
                        ++tagsAdded;
                        continue;
                    }
                    iterator = cachedTag;
                    Long l = (Long)((MutablePair)iterator).right;
                    ((MutablePair)iterator).right = (Long)((MutablePair)iterator).right + 1L;
                    object = ((MutablePair)iterator).right;
                    replacedTagIds.put(deltaTagId, cachedTag.left);
                    continue;
                }
                RangerTag existing = tags.put(deltaTagId, deltaTag);
                if (existing == null) {
                    ++tagsAdded;
                    continue;
                }
                if (existing.equals(deltaTag)) continue;
                ++tagsUpdated;
            }
            List<RangerServiceResource> serviceResources = ret.getServiceResources();
            Map<Long, List<Long>> map = ret.getResourceToTagIds();
            Map idResourceMap = serviceResources.stream().collect(Collectors.toMap(RangerBaseModelObject::getId, Function.identity()));
            HashMap<Long, RangerServiceResource> resourcesToRemove = new HashMap<Long, RangerServiceResource>();
            HashMap<Long, RangerServiceResource> resourcesToAdd = new HashMap<Long, RangerServiceResource>();
            for (RangerServiceResource rangerServiceResource : delta.getServiceResources()) {
                RangerServiceResource existingResource = (RangerServiceResource)idResourceMap.get(rangerServiceResource.getId());
                if (existingResource != null) {
                    if (StringUtils.isNotEmpty((String)rangerServiceResource.getResourceSignature())) {
                        if (StringUtils.equals((String)rangerServiceResource.getResourceSignature(), (String)existingResource.getResourceSignature())) continue;
                        resourcesToRemove.put(rangerServiceResource.getId(), existingResource);
                        resourcesToAdd.put(rangerServiceResource.getId(), rangerServiceResource);
                        continue;
                    }
                    resourcesToRemove.put(rangerServiceResource.getId(), existingResource);
                    map.remove(existingResource.getId());
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)rangerServiceResource.getResourceSignature())) continue;
                resourcesToAdd.put(rangerServiceResource.getId(), rangerServiceResource);
            }
            if (!resourcesToRemove.isEmpty()) {
                Iterator<Object> iter = serviceResources.listIterator();
                while (iter.hasNext()) {
                    RangerServiceResource rangerServiceResource = iter.next();
                    RangerServiceResource deletedResource = (RangerServiceResource)resourcesToRemove.get(rangerServiceResource.getId());
                    RangerServiceResource addedResource = (RangerServiceResource)resourcesToAdd.get(rangerServiceResource.getId());
                    if (addedResource != null || deletedResource != rangerServiceResource) continue;
                    iter.remove();
                }
            }
            serviceResources.addAll(resourcesToAdd.values());
            if (!replacedTagIds.isEmpty()) {
                for (Map.Entry entry : delta.getResourceToTagIds().entrySet()) {
                    ListIterator<Long> listIter = ((List)entry.getValue()).listIterator();
                    while (listIter.hasNext()) {
                        Long tagId = (Long)listIter.next();
                        Long replacerTagId = (Long)replacedTagIds.get(tagId);
                        if (replacerTagId == null) continue;
                        listIter.set(replacerTagId);
                    }
                }
            }
            map.putAll(delta.getResourceToTagIds());
            if (MapUtils.isEmpty(map)) {
                LOG.debug("There are no resource->tag mappings!!");
                if (MapUtils.isNotEmpty(ret.getTags())) {
                    LOG.warn("There are no resource->tag mappings, but there are tags in the ServiceTags!! Cleaning up");
                    ret.getTags().clear();
                }
                if (supportsTagsDedup) {
                    ret.cachedTags.clear();
                }
            }
            ArrayList<RangerServiceResource> deltaServiceResources = new ArrayList<RangerServiceResource>();
            for (RangerServiceResource resourceToRemove : resourcesToRemove.values()) {
                resourceToRemove.setResourceSignature(null);
                deltaServiceResources.add(resourceToRemove);
            }
            if (!resourcesToAdd.isEmpty()) {
                deltaServiceResources.addAll(resourcesToAdd.values());
            }
            delta.setServiceResources(deltaServiceResources);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerServiceTagsDeltaUtil.applyDelta(): delta(tagDefs={}, tags={}, resources={}), resources(total={}, added={}, removed={}), tags(total={}, added={}, updated={}, removed={}), tagDefs(total={}, added={}, updated={}, removed={})", new Object[]{delta.getTagDefinitions().size(), delta.getTags().size(), delta.getServiceResources().size(), serviceResources.size(), resourcesToAdd.size(), resourcesToRemove.size(), tags.size(), tagsAdded, tagsUpdated, tagsRemoved, tagDefs.size(), tagDefsAdded, tagDefsUpdated, tagDefsRemoved});
            }
        } else {
            LOG.debug("Cannot apply deltas to service-tags as one of preconditions is violated. Returning received serviceTags without applying delta!!");
        }
        LOG.debug("<== RangerServiceTagsDeltaUtil.applyDelta(): serviceTags:[{}], delta:[{}], supportsTagsDedup:[{}]", new Object[]{ret, delta, supportsTagsDedup});
        RangerPerfTracer.log(perf);
        return ret;
    }

    public static void pruneUnusedAttributes(ServiceTags serviceTags) {
        if (serviceTags != null) {
            serviceTags.setTagUpdateTime(null);
            for (Map.Entry<Long, RangerTagDef> entry : serviceTags.getTagDefinitions().entrySet()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes(entry.getValue());
            }
            for (Map.Entry<Long, RangerBaseModelObject> entry : serviceTags.getTags().entrySet()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes((RangerTag)entry.getValue());
            }
            for (RangerServiceResource rangerServiceResource : serviceTags.getServiceResources()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes(rangerServiceResource);
            }
        }
    }

    public static void pruneUnusedAttributes(RangerTagDef tagDef) {
        tagDef.setCreatedBy(null);
        tagDef.setCreateTime(null);
        tagDef.setUpdatedBy(null);
        tagDef.setUpdateTime(null);
        tagDef.setGuid(null);
        tagDef.setVersion(null);
        if (tagDef.getAttributeDefs() != null && tagDef.getAttributeDefs().isEmpty()) {
            tagDef.setAttributeDefs(null);
        }
    }

    public static void pruneUnusedAttributes(RangerTag tag) {
        tag.setCreatedBy(null);
        tag.setCreateTime(null);
        tag.setUpdatedBy(null);
        tag.setUpdateTime(null);
        tag.setGuid(null);
        tag.setVersion(null);
        if (tag.getOwner() != null && tag.getOwner() == 0) {
            tag.setOwner(null);
        }
        if (tag.getAttributes() != null && tag.getAttributes().isEmpty()) {
            tag.setAttributes(null);
        }
        if (tag.getOptions() != null && tag.getOptions().isEmpty()) {
            tag.setOptions(null);
        }
        if (tag.getValidityPeriods() != null && tag.getValidityPeriods().isEmpty()) {
            tag.setValidityPeriods(null);
        }
    }

    public static void pruneUnusedAttributes(RangerServiceResource serviceResource) {
        serviceResource.setCreatedBy(null);
        serviceResource.setCreateTime(null);
        serviceResource.setUpdatedBy(null);
        serviceResource.setUpdateTime(null);
        serviceResource.setGuid(null);
        serviceResource.setVersion(null);
        if (serviceResource.getAdditionalInfo() != null && serviceResource.getAdditionalInfo().isEmpty()) {
            serviceResource.setAdditionalInfo(null);
        }
    }
}

