/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerResourceEvaluatorsRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerResourceEvaluatorsRetriever.class);

    private RangerResourceEvaluatorsRetriever() {
    }

    public static <T extends RangerResourceEvaluator> Collection<T> getEvaluators(Map<String, RangerResourceTrie<T>> resourceTrie, Map<String, ?> resource) {
        return RangerResourceEvaluatorsRetriever.getEvaluators(resourceTrie, resource, null);
    }

    public static <T extends RangerResourceEvaluator> Collection<T> getEvaluators(Map<String, RangerResourceTrie<T>> resourceTrie, Map<String, ?> resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes) {
        return RangerResourceEvaluatorsRetriever.getEvaluators(resourceTrie, resource, scopes, null);
    }

    public static <T extends RangerResourceEvaluator> Collection<T> getEvaluators(Map<String, RangerResourceTrie<T>> resourceTrie, Map<String, ?> resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, Predicate predicate) {
        LOG.debug("==> RangerPolicyResourceEvaluatorsRetriever.getEvaluators({})", resource);
        Set ret = null;
        if (scopes == null) {
            scopes = Collections.emptyMap();
        }
        if (MapUtils.isNotEmpty(resourceTrie) && MapUtils.isNotEmpty(resource)) {
            String resourceKey;
            RangerResourceTrie<T> trie;
            Set<String> resourceKeys = resource.keySet();
            String resourceWithMinEvals = null;
            if (resourceKeys.size() > 1) {
                int minEvalCount = 0;
                for (String resourceDefName : resourceKeys) {
                    RangerResourceTrie<T> trie2 = resourceTrie.get(resourceDefName);
                    if (trie2 == null) continue;
                    Object resourceValues = resource.get(resourceDefName);
                    int evalCount = trie2.getEvaluatorsCountForResource(resourceValues, scopes.get(resourceDefName), predicate);
                    if (resourceWithMinEvals != null && evalCount >= minEvalCount) continue;
                    resourceWithMinEvals = resourceDefName;
                    minEvalCount = evalCount;
                }
                if (minEvalCount == 0) {
                    resourceWithMinEvals = null;
                    ret = Collections.emptySet();
                }
            } else if (resourceKeys.size() == 1 && (trie = resourceTrie.get(resourceKey = resourceKeys.iterator().next())) != null) {
                resourceWithMinEvals = resourceKey;
            }
            if (resourceWithMinEvals != null) {
                RangerResourceTrie trie3 = resourceTrie.get(resourceWithMinEvals);
                ret = trie3.getEvaluatorsForResource(resource.get(resourceWithMinEvals), scopes.get(resourceWithMinEvals), predicate);
                for (String resourceDefName : resourceKeys) {
                    if (resourceWithMinEvals.equals(resourceDefName) || (trie3 = resourceTrie.get(resourceDefName)) == null) continue;
                    Set<T> evaluators = trie3.getEvaluatorsForResource(resource.get(resourceDefName), scopes.get(resourceDefName), ret, predicate);
                    if (CollectionUtils.isEmpty(evaluators)) {
                        ret = Collections.emptySet();
                        break;
                    }
                    if (evaluators.size() >= ret.size()) continue;
                    ret = evaluators;
                }
            }
        }
        LOG.debug("<== RangerResourceEvaluatorsRetriever.getEvaluators({}) : evaluator:[{}]", resource, ret);
        return ret;
    }
}

