/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtils.class);
    public static final String PBE_SHA512_AES_128 = "PBEWITHHMACSHA512ANDAES_128";
    public static final String DEFAULT_CRYPT_ALGO = "PBEWithMD5AndDES";
    public static final String DEFAULT_ENCRYPT_KEY = "tzL1AKl5uc4NKYaoQ4P3WLGIBFPXWPWdu1fRm9004jtQiV";
    public static final String DEFAULT_SALT = "f77aLYLo";
    public static final int DEFAULT_ITERATION_COUNT = 17;
    public static final byte[] DEFAULT_INITIAL_VECTOR = new byte[16];
    private static final String LEN_SEPARATOR_STR = ":";
    private final String cryptAlgo;
    private final int iterationCount;
    private final char[] encryptKey;
    private final byte[] salt;
    private final byte[] iv;
    private String password;

    PasswordUtils(String aPassword) {
        Map<String, String> env;
        String encryptKeyStr;
        byte[] lSalt;
        char[] lEncryptKey;
        String[] cryptAlgoArray = null;
        if (aPassword != null && aPassword.contains(",")) {
            cryptAlgoArray = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)aPassword)).toArray(new String[0]);
        }
        if (cryptAlgoArray != null && cryptAlgoArray.length > 4) {
            int index = 0;
            this.cryptAlgo = cryptAlgoArray[index++];
            lEncryptKey = cryptAlgoArray[index++].toCharArray();
            lSalt = cryptAlgoArray[index++].getBytes();
            this.iterationCount = Integer.parseInt(cryptAlgoArray[index++]);
            this.iv = PasswordUtils.needsIv(this.cryptAlgo) ? Base64.decode((String)cryptAlgoArray[index++]) : DEFAULT_INITIAL_VECTOR;
            this.password = cryptAlgoArray[index++];
            if (cryptAlgoArray.length > index) {
                for (int i = index; i < cryptAlgoArray.length; ++i) {
                    this.password = this.password + "," + cryptAlgoArray[i];
                }
            }
        } else {
            this.cryptAlgo = DEFAULT_CRYPT_ALGO;
            lEncryptKey = DEFAULT_ENCRYPT_KEY.toCharArray();
            lSalt = DEFAULT_SALT.getBytes();
            this.iterationCount = 17;
            this.iv = DEFAULT_INITIAL_VECTOR;
            this.password = aPassword;
        }
        this.encryptKey = (encryptKeyStr = (env = System.getenv()).get("lEncryptKey")) == null ? lEncryptKey : encryptKeyStr.toCharArray();
        String saltStr = env.get("ENCRYPT_SALT");
        this.salt = saltStr == null ? lSalt : saltStr.getBytes();
    }

    public static String encryptPassword(String aPassword) throws IOException {
        return PasswordUtils.build(aPassword).encrypt();
    }

    public static PasswordUtils build(String aPassword) {
        return new PasswordUtils(aPassword);
    }

    public static String decryptPassword(String aPassword) throws IOException {
        return PasswordUtils.build(aPassword).decrypt();
    }

    public static boolean needsIv(String cryptoAlgo) {
        if (StringUtils.isEmpty((CharSequence)cryptoAlgo)) {
            return false;
        }
        return PBE_SHA512_AES_128.equalsIgnoreCase(cryptoAlgo) || cryptoAlgo.toLowerCase().contains("aes_128") || cryptoAlgo.toLowerCase().contains("aes_256");
    }

    public static String generateIvIfNeeded(String cryptAlgo) throws NoSuchAlgorithmException {
        if (!PasswordUtils.needsIv(cryptAlgo)) {
            return null;
        }
        return PasswordUtils.generateBase64EncodedIV();
    }

    public static String getDecryptPassword(String password) {
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword(password);
        }
        catch (Exception ex) {
            LOG.warn("Password decryption failed, trying original password string.");
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = password;
            }
        }
        return decryptedPwd;
    }

    public String getCryptAlgo() {
        return this.cryptAlgo;
    }

    public String getPassword() {
        return this.password;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public char[] getEncryptKey() {
        return this.encryptKey;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public String getIvAsString() {
        return new String(Base64.encode((byte[])this.getIv()));
    }

    private String encrypt() throws IOException {
        String ret;
        String strToEncrypt = this.password == null ? "" : this.password.length() + LEN_SEPARATOR_STR + this.password;
        try {
            Cipher engine = Cipher.getInstance(this.cryptAlgo);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.cryptAlgo);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(1, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount, new IvParameterSpec(this.iv)));
            byte[] encryptedStr = engine.doFinal(strToEncrypt.getBytes());
            ret = new String(Base64.encode((byte[])encryptedStr));
        }
        catch (Throwable t) {
            LOG.error("Unable to encrypt password due to error", t);
            throw new IOException("Unable to encrypt password due to error", t);
        }
        return ret;
    }

    private String decrypt() throws IOException {
        String ret;
        try {
            byte[] decodedPassword = Base64.decode((String)this.password);
            Cipher engine = Cipher.getInstance(this.cryptAlgo);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.cryptAlgo);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(2, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount, new IvParameterSpec(this.iv)));
            String decrypted = new String(engine.doFinal(decodedPassword));
            int foundAt = decrypted.indexOf(LEN_SEPARATOR_STR);
            ret = foundAt > -1 ? (decrypted.length() > foundAt ? decrypted.substring(foundAt + 1) : "") : null;
        }
        catch (Throwable t) {
            LOG.error("Unable to decrypt password due to error", t);
            throw new IOException("Unable to decrypt password due to error", t);
        }
        return ret;
    }

    private static String generateBase64EncodedIV() throws NoSuchAlgorithmException {
        byte[] iv = new byte[16];
        SecureRandom.getInstance("NativePRNGNonBlocking").nextBytes(iv);
        return new String(Base64.encode((byte[])iv));
    }

    public static final class PasswordGenerator {
        private static final String LOWER = "abcdefghijklmnopqrstuvwxyz";
        private static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private static final String DIGITS = "0123456789";
        private static final String SYMBOLS = "!@#$%&*()_+-=[]|,./?><";
        private final boolean useLower;
        private final boolean useUpper;
        private final boolean useDigits;
        private final boolean useSymbols;

        private PasswordGenerator(PasswordGeneratorBuilder builder) {
            this.useLower = builder.useLower;
            this.useUpper = builder.useUpper;
            this.useDigits = builder.useDigits;
            this.useSymbols = builder.useSymbols;
        }

        public String generate(int length) {
            StringBuilder password = new StringBuilder(length);
            SecureRandom secureRandom = new SecureRandom();
            ArrayList<String> charCategories = new ArrayList<String>(4);
            if (this.useLower) {
                charCategories.add(LOWER);
            }
            if (this.useUpper) {
                charCategories.add(UPPER);
            }
            if (this.useDigits) {
                charCategories.add(DIGITS);
            }
            if (this.useSymbols) {
                charCategories.add(SYMBOLS);
            }
            for (int i = 0; i < length; ++i) {
                int idxCatagory = i < charCategories.size() ? i : secureRandom.nextInt(charCategories.size());
                String charCategory = (String)charCategories.get(idxCatagory);
                int position = secureRandom.nextInt(charCategory.length());
                password.append(charCategory.charAt(position));
            }
            return new String(password);
        }

        public static class PasswordGeneratorBuilder {
            private boolean useLower = false;
            private boolean useUpper = false;
            private boolean useDigits = false;
            private boolean useSymbols = false;

            public PasswordGeneratorBuilder useLower(boolean useLower) {
                this.useLower = useLower;
                return this;
            }

            public PasswordGeneratorBuilder useUpper(boolean useUpper) {
                this.useUpper = useUpper;
                return this;
            }

            public PasswordGeneratorBuilder useDigits(boolean useDigits) {
                this.useDigits = useDigits;
                return this;
            }

            public PasswordGeneratorBuilder useSymbols(boolean useSymbols) {
                this.useSymbols = useSymbols;
                return this;
            }

            public PasswordGenerator build() {
                return new PasswordGenerator(this);
            }
        }
    }
}

