/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MacroProcessor.class);
    private final Map<String, String> macrosMap;
    private final Pattern macrosPattern;

    public MacroProcessor(Map<String, String> macrosMap) {
        this.macrosMap = macrosMap;
        this.macrosPattern = this.getMacrosPattern(this.macrosMap);
    }

    public String expandMacros(String expr) {
        StringBuffer ret = null;
        if (expr != null) {
            Matcher matcher = this.macrosPattern.matcher(expr);
            while (matcher.find()) {
                if (ret == null) {
                    ret = new StringBuffer();
                }
                String keyword = matcher.group();
                String replacer = this.macrosMap.get(keyword);
                matcher.appendReplacement(ret, replacer);
            }
            if (ret == null) {
                LOG.debug("expandMacros({}): no match found!", (Object)expr);
            } else {
                matcher.appendTail(ret);
                LOG.debug("expandMacros({}): match found. ret={}", (Object)expr, (Object)ret);
            }
        }
        return ret != null ? ret.toString() : expr;
    }

    private Pattern getMacrosPattern(Map<String, String> macros) {
        StringBuilder sb = new StringBuilder();
        String sep = "\\b(";
        for (String macro : macros.keySet()) {
            sb.append(sep).append(macro);
            sep = "|";
        }
        sb.append(")\\b");
        return Pattern.compile(sb.toString());
    }
}

