/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.geo.GeolocationMetadata;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.RangerGeolocationDatabase;
import org.apache.ranger.plugin.store.GeolocationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeolocationFileStore
implements GeolocationStore {
    private static final Logger LOG = LoggerFactory.getLogger(GeolocationFileStore.class);
    public static final String GeoLineCommentIdentifier = "#";
    public static final Character GeoFieldsSeparator = Character.valueOf(',');
    public static final String PROP_GEOLOCATION_FILE_LOCATION = "FilePath";
    public static final String PROP_GEOLOCATION_FILE_REINIT = "ForceRead";
    public static final String PROP_GEOLOCATION_IP_IN_DOT_FORMAT = "IPInDotFormat";
    private static final Map<String, RangerGeolocationDatabase> GEOLOCATION_DB_MAP = new HashMap<String, RangerGeolocationDatabase>();
    private RangerGeolocationDatabase geolocationDatabase;
    private boolean isMetalineProcessed;
    private boolean useDotFormat;

    @Override
    public void init(Map<String, String> context) {
        RangerGeolocationDatabase database;
        String reinit;
        String filePathToGeolocationFile = context.get(PROP_GEOLOCATION_FILE_LOCATION);
        if (StringUtils.isBlank((String)filePathToGeolocationFile)) {
            filePathToGeolocationFile = "/etc/ranger/data/geo.txt";
        }
        boolean reinitialize = (reinit = context.get(PROP_GEOLOCATION_FILE_REINIT)) == null || Boolean.parseBoolean(reinit);
        String ipInDotFormat = context.get(PROP_GEOLOCATION_IP_IN_DOT_FORMAT);
        boolean bl = this.useDotFormat = ipInDotFormat == null || Boolean.parseBoolean(ipInDotFormat);
        if (LOG.isDebugEnabled()) {
            LOG.debug("GeolocationFileStore.init() - Geolocation file location={}", (Object)filePathToGeolocationFile);
            LOG.debug("GeolocationFileStore.init() - Reinitialize flag ={}", (Object)reinitialize);
            LOG.debug("GeolocationFileStore.init() - UseDotFormat flag ={}", (Object)this.useDotFormat);
        }
        if ((database = GEOLOCATION_DB_MAP.get(filePathToGeolocationFile)) == null || reinitialize) {
            RangerGeolocationDatabase newDatabase = this.build(filePathToGeolocationFile);
            if (newDatabase != null) {
                GEOLOCATION_DB_MAP.put(filePathToGeolocationFile, newDatabase);
                database = newDatabase;
            } else {
                LOG.error("GeolocationFileStore.init() - Could not build database. Using old database if present.");
            }
        }
        this.geolocationDatabase = database;
        if (this.geolocationDatabase == null) {
            LOG.error("GeolocationFileStore.init() - Cannot build Geolocation database from file {}", (Object)filePathToGeolocationFile);
        }
    }

    @Override
    public final RangerGeolocationData getGeoLocation(String ipAddress) {
        RangerGeolocationData ret = null;
        RangerGeolocationDatabase database = this.geolocationDatabase;
        if (database != null) {
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            ret = database.find(ipAddress);
            if (LOG.isDebugEnabled()) {
                if (ret == null) {
                    LOG.debug("GeolocationFileStore.getGeolocation() - {} not found. Search time = {} milliseconds", (Object)ipAddress, (Object)(end - start));
                } else {
                    LOG.debug("GeolocationFileStore.getGeolocation() - {} found. Search time = {} milliseconds", (Object)ipAddress, (Object)(end - start));
                    for (String attrName : database.getMetadata().getLocationDataItemNames()) {
                        LOG.debug("GeolocationFileStore.getGeolocation() - IPAddress[{}]={}", (Object)attrName, (Object)database.getValue(ret, attrName));
                    }
                }
            }
        } else {
            LOG.error("GeolocationFileStore.getGeolocation() - GeoLocationDatabase is not initialized correctly.");
        }
        return ret;
    }

    @Override
    public RangerGeolocationDatabase getGeoDatabase() {
        return this.geolocationDatabase;
    }

    RangerGeolocationDatabase build(String dataFileName) {
        RangerGeolocationDatabase database = null;
        long start = System.currentTimeMillis();
        try (BufferedReader bufferedReader = new BufferedReader(this.getReader(dataFileName));){
            database = new RangerGeolocationDatabase();
            int lineNumber = 0;
            this.isMetalineProcessed = false;
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!this.processLine(++lineNumber, line, database)) {
                    LOG.error("RangerGeolocationDatabaseBuilder.build() - Invalid geo-specification - {}:{}", (Object)lineNumber, (Object)line);
                    database = null;
                    break;
                }
                line = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error("RangerGeolocationDatabaseBuilder.build() - Unable to open file '{}'", (Object)dataFileName);
        }
        catch (IOException ex) {
            LOG.error("RangerGeolocationDatabaseBuilder.build() - Error reading file '{}', {}", (Object)dataFileName, (Object)ex);
        }
        long end = System.currentTimeMillis();
        LOG.debug("RangerGeolocationDatabaseBuilder.build() - Time taken for reading file = {} milliseconds", (Object)(end - start));
        if (database != null) {
            database.optimize();
        }
        return database;
    }

    private Reader getReader(String dataFileName) throws IOException {
        InputStreamReader ret = null;
        File f = new File(dataFileName);
        if (f.exists() && f.canRead()) {
            LOG.info("GeolocationFileStore: reading location data from file '{}'", (Object)dataFileName);
            ret = new FileReader(dataFileName);
        } else {
            InputStream inStr = this.getClass().getResourceAsStream(dataFileName);
            if (inStr != null) {
                LOG.info("GeolocationFileStore: reading location data from resource '{}'", (Object)dataFileName);
                ret = new InputStreamReader(inStr);
            }
        }
        if (ret == null) {
            throw new FileNotFoundException(dataFileName);
        }
        return ret;
    }

    private boolean processLine(int lineNumber, String line, RangerGeolocationDatabase database) {
        boolean ret = true;
        if (!(line = line.trim()).startsWith(GeoLineCommentIdentifier)) {
            String[] fields = StringUtils.split((String)line, (char)GeoFieldsSeparator.charValue());
            if (fields != null) {
                if (!this.isMetalineProcessed) {
                    GeolocationMetadata metadata = GeolocationMetadata.create(fields, lineNumber);
                    if (metadata != null) {
                        database.setMetadata(metadata);
                        this.isMetalineProcessed = true;
                    } else {
                        LOG.error("GeolocationFileStore.processLine() - Invalid metadata specification {}:{}", (Object)lineNumber, (Object)line);
                        ret = false;
                    }
                } else {
                    RangerGeolocationData data = RangerGeolocationData.create(fields, lineNumber, this.useDotFormat);
                    if (data != null) {
                        database.getData().insert(data);
                    } else {
                        LOG.error("GeolocationFileStore.processLine() - Invalid data specification {}:{}", (Object)lineNumber, (Object)line);
                    }
                }
            } else {
                LOG.error("GeolocationFileStore.processLine() - Invalid line, skipping..{}:{}", (Object)lineNumber, (Object)line);
            }
        }
        return ret;
    }
}

