/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.SearchFilter;

public class ServicePredicateUtil
extends AbstractPredicateUtil {
    private final ServiceStore serviceStore;

    public ServicePredicateUtil(ServiceStore serviceStore) {
        this.serviceStore = serviceStore;
    }

    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        super.addPredicates(filter, predicates);
        this.addPredicateForServiceType(filter.getParam("serviceType"), predicates);
        this.addPredicateForServiceId(filter.getParam("serviceId"), predicates);
        this.addPredicateForTagSeviceName(filter.getParam("tagServiceName"), predicates);
        this.addPredicateForTagSeviceId(filter.getParam("tagServiceId"), predicates);
    }

    private String getServiceType(String serviceName) {
        RangerService service = null;
        try {
            if (this.serviceStore != null) {
                service = this.serviceStore.getServiceByName(serviceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return service != null ? service.getType() : null;
    }

    private Long getServiceId(String serviceName) {
        RangerBaseModelObject service = null;
        try {
            if (this.serviceStore != null) {
                service = this.serviceStore.getServiceByName(serviceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return service != null ? service.getId() : null;
    }

    private Predicate addPredicateForServiceType(String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceType)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = StringUtils.equals((String)serviceType, (String)this.getServiceType(policy.getService()));
            } else if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                ret1 = StringUtils.equals((String)serviceType, (String)service.getType());
            } else if (object instanceof RangerServiceDef) {
                RangerServiceDef serviceDef = (RangerServiceDef)object;
                ret1 = StringUtils.equals((String)serviceType, (String)serviceDef.getName());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceId(String serviceId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceId)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                Long svcId = this.getServiceId(policy.getService());
                if (svcId != null) {
                    ret1 = StringUtils.equals((String)serviceId, (String)svcId.toString());
                }
            } else if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                if (service.getId() != null) {
                    ret1 = StringUtils.equals((String)serviceId, (String)service.getId().toString());
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagSeviceName(String tagServiceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)tagServiceName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                ret1 = StringUtils.equals((String)tagServiceName, (String)service.getTagService());
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagSeviceId(String tagServiceId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)tagServiceId)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                if (!StringUtils.isEmpty((String)service.getTagService())) {
                    RangerService tagService = null;
                    try {
                        tagService = this.serviceStore.getServiceByName(service.getTagService());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ret1 = tagService != null && tagService.getId() != null && StringUtils.equals((String)tagServiceId, (String)tagService.getId().toString());
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

