/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class SecurityZonePredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForServiceName(filter.getParam("serviceName"), predicates);
        this.addPredicateForMatchingZoneId(filter.getParam("zoneId"), predicates);
        this.addPredicateForMatchingZoneName(filter.getParam("zoneName"), predicates);
        this.addPredicateForNonMatchingZoneName(filter.getParam("notZoneName"), predicates);
        this.addPredicateForMatchingZoneNamePartial(filter.getParam("zoneNamePartial"), predicates);
        this.addPredicateForCreatedBy(filter.getParam("createdBy"), predicates);
    }

    private Predicate addPredicateForServiceName(String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone) {
                RangerSecurityZone securityZone = (RangerSecurityZone)object;
                ret1 = securityZone.getServices().get(serviceName) != null;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneId(String zoneId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)zoneId)) {
            return null;
        }
        Predicate ret = object -> {
            RangerSecurityZone securityZone;
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone && StringUtils.equals((String)zoneId, (String)(securityZone = (RangerSecurityZone)object).getId().toString())) {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneName(String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)zoneName)) {
            return null;
        }
        Predicate ret = object -> {
            RangerSecurityZone securityZone;
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone && StringUtils.equals((String)zoneName, (String)(securityZone = (RangerSecurityZone)object).getName())) {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForNonMatchingZoneName(String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)zoneName)) {
            return null;
        }
        Predicate ret = object -> {
            RangerSecurityZone securityZone;
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone && !StringUtils.equals((String)zoneName, (String)(securityZone = (RangerSecurityZone)object).getName())) {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForMatchingZoneNamePartial(String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)zoneName)) {
            return null;
        }
        Predicate ret = object -> {
            RangerSecurityZone securityZone;
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone && StringUtils.containsIgnoreCase((String)(securityZone = (RangerSecurityZone)object).getName(), (String)zoneName)) {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForCreatedBy(String createdBy, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)createdBy)) {
            return null;
        }
        Predicate ret = object -> {
            RangerSecurityZone securityZone;
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerSecurityZone && StringUtils.equals((String)(securityZone = (RangerSecurityZone)object).getCreatedBy(), (String)createdBy)) {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

