/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestProcessor;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerUserStoreUtil;
import org.apache.ranger.ugsyncutil.transform.Mapper;
import org.apache.ranger.ugsyncutil.util.UgsyncCommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultRequestProcessor
implements RangerAccessRequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultRequestProcessor.class);
    private static final Logger PERF_CONTEXTENRICHER_REQUEST_LOG = RangerPerfTracer.getPerfLogger("contextenricher.request");
    protected final PolicyEngine policyEngine;
    private final boolean useRangerGroups;
    private final boolean useOnlyRangerGroups;
    private final boolean convertEmailToUser;

    public RangerDefaultRequestProcessor(PolicyEngine policyEngine) {
        RangerPluginConfig pluginConfig;
        this.policyEngine = policyEngine;
        RangerPluginContext pluginContext = policyEngine.getPluginContext();
        RangerPluginConfig rangerPluginConfig = pluginConfig = pluginContext != null ? pluginContext.getConfig() : null;
        if (pluginConfig != null) {
            this.useRangerGroups = pluginConfig.isUseRangerGroups();
            this.useOnlyRangerGroups = pluginConfig.isUseOnlyRangerGroups();
            this.convertEmailToUser = pluginConfig.isConvertEmailToUsername();
        } else {
            this.useRangerGroups = false;
            this.useOnlyRangerGroups = false;
            this.convertEmailToUser = false;
        }
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        String owner;
        LOG.debug("==> preProcess({})", (Object)request);
        if (RangerAccessRequestUtil.getIsRequestPreprocessed(request.getContext())) {
            LOG.debug("<== preProcess({})", (Object)request);
            return;
        }
        this.setResourceServiceDef(request);
        RangerPluginContext pluginContext = this.policyEngine.getPluginContext();
        RangerAccessRequestImpl reqImpl = null;
        if (request instanceof RangerAccessRequestImpl) {
            reqImpl = (RangerAccessRequestImpl)request;
            if (reqImpl.getClientIPAddress() == null) {
                reqImpl.extractAndSetClientIPAddress(this.policyEngine.getUseForwardedIPAddress(), this.policyEngine.getTrustedProxyAddresses());
            }
            if (pluginContext != null) {
                if (reqImpl.getClusterName() == null) {
                    reqImpl.setClusterName(pluginContext.getClusterName());
                }
                if (reqImpl.getClusterType() == null) {
                    reqImpl.setClusterType(pluginContext.getClusterType());
                }
                RangerPluginConfig config = this.policyEngine.getPluginContext().getConfig();
                boolean isNameTransformationSupported = config.getBoolean(config.getPropertyPrefix() + ".supports.name.transformation", false);
                LOG.debug("isNameTransformationSupported = {}", (Object)isNameTransformationSupported);
                if (isNameTransformationSupported) {
                    reqImpl.setUser(this.getTransformedUser(this.policyEngine, request));
                    reqImpl.setUserGroups(this.getTransformedGroups(this.policyEngine, request));
                }
                this.convertEmailToUsername(reqImpl);
                this.updateUserGroups(reqImpl);
            }
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        String string = owner = request.getResource() != null ? request.getResource().getOwnerUser() : null;
        if (StringUtils.isNotEmpty((String)owner)) {
            RangerAccessRequestUtil.setOwnerInContext(request.getContext(), owner);
        }
        Set<String> roles = request.getUserRoles();
        if (pluginContext != null && CollectionUtils.isEmpty(roles)) {
            roles = pluginContext.getAuthContext().getRolesForUserAndGroups(request.getUser(), request.getUserGroups());
            if (reqImpl != null && roles != null && !roles.isEmpty()) {
                reqImpl.setUserRoles(roles);
            }
        }
        if (CollectionUtils.isNotEmpty(roles)) {
            RangerAccessRequestUtil.setCurrentUserRolesInContext(request.getContext(), roles);
        }
        Set<String> zoneNames = this.policyEngine.getMatchedZonesForResourceAndChildren(request.getResource());
        RangerAccessRequestUtil.setResourceZoneNamesInContext(request, zoneNames);
        this.enrich(request);
        RangerAccessRequestUtil.setIsRequestPreprocessed(request.getContext(), Boolean.TRUE);
        LOG.debug("<== preProcess({})", (Object)request);
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        List<RangerContextEnricher> enrichers = this.policyEngine.getAllContextEnrichers();
        if (!CollectionUtils.isEmpty(enrichers)) {
            for (RangerContextEnricher enricher : enrichers) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_REQUEST_LOG, "RangerContextEnricher.enrich(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ", enricherName=" + enricher.getName() + ")");
                }
                enricher.enrich(request);
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.debug("No context-enrichers!!!");
        }
    }

    private String getTransformedUser(PolicyEngine policyEngine, RangerAccessRequest request) {
        RangerAuthContext authContext = policyEngine.getPluginContext().getAuthContext();
        boolean toLowerCase = authContext.getUserNameCaseConversion() == UgsyncCommonConstants.CaseConversion.TO_LOWER;
        boolean toUpperCase = authContext.getUserNameCaseConversion() == UgsyncCommonConstants.CaseConversion.TO_UPPER;
        Mapper nameTransformer = authContext.getUserNameTransformer();
        if (toLowerCase || toUpperCase || nameTransformer != null) {
            String user = request.getUser();
            if (toLowerCase) {
                user = user.toLowerCase();
            } else if (toUpperCase) {
                user = user.toUpperCase();
            }
            if (nameTransformer != null) {
                user = nameTransformer.transform(user);
            }
            LOG.debug("Original username = {}, Transformed username = {}", (Object)request.getUser(), (Object)user);
            return user;
        }
        return request.getUser();
    }

    private Set<String> getTransformedGroups(PolicyEngine policyEngine, RangerAccessRequest request) {
        if (CollectionUtils.isNotEmpty(request.getUserGroups())) {
            RangerAuthContext authContext = policyEngine.getPluginContext().getAuthContext();
            boolean toLowerCase = authContext.getGroupNameCaseConversion() == UgsyncCommonConstants.CaseConversion.TO_LOWER;
            boolean toUpperCase = authContext.getGroupNameCaseConversion() == UgsyncCommonConstants.CaseConversion.TO_UPPER;
            Mapper nameTransformer = authContext.getGroupNameTransformer();
            if (toLowerCase || toUpperCase || nameTransformer != null) {
                return request.getUserGroups().stream().filter(Objects::nonNull).map(group -> {
                    String originalGroup = group;
                    if (toLowerCase) {
                        group = group.toLowerCase();
                    } else if (toUpperCase) {
                        group = group.toUpperCase();
                    }
                    String transformedGroup = nameTransformer.transform(group);
                    LOG.debug("Original group name = {}, Transformed group name = {}", (Object)originalGroup, (Object)transformedGroup);
                    return transformedGroup;
                }).collect(Collectors.toSet());
            }
        }
        return request.getUserGroups();
    }

    private void setResourceServiceDef(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null && resource instanceof RangerMutableResource) {
            RangerMutableResource mutable = (RangerMutableResource)resource;
            mutable.setServiceDef(this.policyEngine.getServiceDef());
        }
    }

    private void convertEmailToUsername(RangerAccessRequestImpl reqImpl) {
        if (this.convertEmailToUser) {
            String userName;
            int idxSep;
            RangerUserStoreUtil userStoreUtil;
            RangerPluginContext pluginContext = this.policyEngine.getPluginContext();
            RangerUserStoreUtil rangerUserStoreUtil = userStoreUtil = pluginContext != null ? pluginContext.getAuthContext().getUserStoreUtil() : null;
            if (userStoreUtil != null && (idxSep = StringUtils.indexOf((String)(userName = reqImpl.getUser()), (char)'@')) > 0) {
                String userNameFromEmail = userStoreUtil.getUserNameFromEmail(userName);
                if (StringUtils.isBlank((String)userNameFromEmail)) {
                    userNameFromEmail = userName.substring(0, idxSep);
                }
                LOG.debug("replacing req.user '{}' with '{}'", (Object)userName, (Object)userNameFromEmail);
                reqImpl.setUser(userNameFromEmail);
            }
        }
    }

    private void updateUserGroups(RangerAccessRequestImpl reqImpl) {
        if (this.useRangerGroups) {
            RangerPluginContext pluginContext = this.policyEngine.getPluginContext();
            RangerUserStoreUtil userStoreUtil = pluginContext != null ? pluginContext.getAuthContext().getUserStoreUtil() : null;
            String userName = reqImpl.getUser();
            if (userStoreUtil != null && userName != null) {
                Set<String> userGroups = reqImpl.getUserGroups();
                Set<String> rangerUserGroups = userStoreUtil.getUserGroups(userName);
                if (rangerUserGroups == null) {
                    rangerUserGroups = Collections.emptySet();
                }
                if (this.useOnlyRangerGroups) {
                    userGroups = new HashSet<String>(rangerUserGroups);
                    LOG.debug("replacing req.userGroups '{}' with '{}'", reqImpl.getUserGroups(), userGroups);
                    reqImpl.setUserGroups(userGroups);
                } else if (!rangerUserGroups.isEmpty()) {
                    userGroups = userGroups != null ? new HashSet<String>(userGroups) : new HashSet();
                    userGroups.addAll(rangerUserGroups);
                    LOG.debug("replacing req.userGroups '{}' with '{}'", reqImpl.getUserGroups(), userGroups);
                    reqImpl.setUserGroups(userGroups);
                }
            }
        }
    }
}

