/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.policyengine.RangerSecurityZoneMatcher;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerRolesUtil;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.RangerUserStoreUtil;
import org.apache.ranger.ugsyncutil.transform.Mapper;
import org.apache.ranger.ugsyncutil.util.UgsyncCommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthContext {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthContext.class);
    private final Map<RangerContextEnricher, Object> requestContextEnrichers;
    private final RangerSecurityZoneMatcher zoneMatcher;
    private RangerRolesUtil rolesUtil;
    private RangerUserStoreUtil userStoreUtil;
    private Mapper userNameTransformer;
    private Mapper groupNameTransformer;
    private UgsyncCommonConstants.CaseConversion userNameCaseConversion;
    private UgsyncCommonConstants.CaseConversion groupNameCaseConversion;

    public RangerAuthContext(RangerAuthContext prevContext, RangerSecurityZoneMatcher zoneMatcher, RangerRoles roles) {
        this(null, zoneMatcher, roles, prevContext != null ? prevContext.getUserStoreUtil().getUserStore() : null);
        if (prevContext != null) {
            this.userNameTransformer = prevContext.userNameTransformer;
            this.groupNameTransformer = prevContext.groupNameTransformer;
            this.userNameCaseConversion = prevContext.userNameCaseConversion;
            this.groupNameCaseConversion = prevContext.groupNameCaseConversion;
        }
    }

    public RangerAuthContext(Map<RangerContextEnricher, Object> requestContextEnrichers, RangerSecurityZoneMatcher zoneMatcher, RangerRoles roles, RangerUserStore userStore) {
        this.requestContextEnrichers = requestContextEnrichers != null ? requestContextEnrichers : new ConcurrentHashMap();
        this.zoneMatcher = zoneMatcher;
        this.setRoles(roles);
        this.setUserStore(userStore);
    }

    public Map<RangerContextEnricher, Object> getRequestContextEnrichers() {
        return this.requestContextEnrichers;
    }

    public RangerSecurityZoneMatcher getZoneMatcher() {
        return this.zoneMatcher;
    }

    public void addOrReplaceRequestContextEnricher(RangerContextEnricher enricher, Object database) {
        this.requestContextEnrichers.put(enricher, database != null ? database : enricher);
        if (database instanceof RangerUserStore) {
            this.setUserStore((RangerUserStore)database);
        }
    }

    public void cleanupRequestContextEnricher(RangerContextEnricher enricher) {
        this.requestContextEnrichers.remove(enricher);
    }

    public void setRoles(RangerRoles roles) {
        this.rolesUtil = new RangerRolesUtil(roles);
    }

    public Set<String> getRolesForUserAndGroups(String user, Set<String> groups) {
        Object userRoles;
        RangerRolesUtil rolesUtil = this.rolesUtil;
        Map<String, Set<String>> userRoleMapping = rolesUtil.getUserRoleMapping();
        Map<String, Set<String>> groupRoleMapping = rolesUtil.getGroupRoleMapping();
        HashSet<String> allRoles = new HashSet<String>();
        if (MapUtils.isNotEmpty(userRoleMapping) && StringUtils.isNotEmpty((String)user) && CollectionUtils.isNotEmpty(userRoles = userRoleMapping.get(user))) {
            allRoles.addAll((Collection<String>)userRoles);
        }
        if (MapUtils.isNotEmpty(groupRoleMapping)) {
            Set<String> publicGroupRoles;
            if (CollectionUtils.isNotEmpty(groups)) {
                for (String group : groups) {
                    Set<String> groupRoles = groupRoleMapping.get(group);
                    if (!CollectionUtils.isNotEmpty(groupRoles)) continue;
                    allRoles.addAll(groupRoles);
                }
            }
            if (CollectionUtils.isNotEmpty(publicGroupRoles = groupRoleMapping.get("public"))) {
                allRoles.addAll(publicGroupRoles);
            }
        }
        return allRoles;
    }

    public long getRoleVersion() {
        return this.rolesUtil.getRoleVersion();
    }

    public RangerRolesUtil getRangerRolesUtil() {
        return this.rolesUtil;
    }

    public long getUserStoreVersion() {
        return this.userStoreUtil.getUserStoreVersion();
    }

    public RangerUserStoreUtil getUserStoreUtil() {
        return this.userStoreUtil;
    }

    public void setUserStore(RangerUserStore userStore) {
        this.userStoreUtil = new RangerUserStoreUtil(userStore);
    }

    public Mapper getUserNameTransformer() {
        return this.userNameTransformer;
    }

    public Mapper getGroupNameTransformer() {
        return this.groupNameTransformer;
    }

    public UgsyncCommonConstants.CaseConversion getUserNameCaseConversion() {
        return this.userNameCaseConversion;
    }

    public UgsyncCommonConstants.CaseConversion getGroupNameCaseConversion() {
        return this.groupNameCaseConversion;
    }

    public void onServiceConfigsUpdate(Map<String, String> serviceConfigs) {
        String userNameCaseConversion = null;
        String groupNameCaseConversion = null;
        Mapper userNameTransformer = null;
        Mapper groupNameTransformer = null;
        if (MapUtils.isNotEmpty(serviceConfigs)) {
            String mappingGroupNameHandler;
            LOG.debug("==> onServiceConfigsUpdate({})", serviceConfigs.keySet());
            userNameCaseConversion = serviceConfigs.get("ranger.plugins.conf.ldap.username.caseconversion");
            groupNameCaseConversion = serviceConfigs.get("ranger.plugins.conf.ldap.groupname.caseconversion");
            String mappingUserNameHandler = serviceConfigs.get("ranger.plugins.conf.mapping.username.handler");
            if (mappingUserNameHandler != null) {
                try {
                    Class<?> regExClass = Class.forName(mappingUserNameHandler);
                    userNameTransformer = (Mapper)regExClass.newInstance();
                    String baseProperty = "ranger.plugins.conf.mapping.username.regex";
                    userNameTransformer.init(baseProperty, this.getAllRegexPatterns(baseProperty, serviceConfigs), serviceConfigs.get("ranger.plugins.conf.mapping.regex.separator"));
                }
                catch (ClassNotFoundException cne) {
                    LOG.error("Failed to load {}", (Object)mappingUserNameHandler, (Object)cne);
                }
                catch (Throwable te) {
                    LOG.error("Failed to instantiate {}", (Object)mappingUserNameHandler, (Object)te);
                }
            }
            if ((mappingGroupNameHandler = serviceConfigs.get("ranger.plugins.conf.mapping.groupname.handler")) != null) {
                try {
                    Class<?> regExClass = Class.forName(mappingGroupNameHandler);
                    groupNameTransformer = (Mapper)regExClass.newInstance();
                    String baseProperty = "ranger.plugins.conf.mapping.groupname.regex";
                    groupNameTransformer.init(baseProperty, this.getAllRegexPatterns(baseProperty, serviceConfigs), serviceConfigs.get("ranger.plugins.conf.mapping.regex.separator"));
                }
                catch (ClassNotFoundException cne) {
                    LOG.error("Failed to load {}", (Object)mappingGroupNameHandler, (Object)cne);
                }
                catch (Throwable te) {
                    LOG.error("Failed to instantiate {}", (Object)mappingGroupNameHandler, (Object)te);
                }
            }
        }
        this.setUserNameCaseConversion(userNameCaseConversion);
        this.setGroupNameCaseConversion(groupNameCaseConversion);
        this.setUserNameTransformer(userNameTransformer);
        this.setGroupNameTransformer(groupNameTransformer);
    }

    private void setUserNameTransformer(Mapper userNameTransformer) {
        this.userNameTransformer = userNameTransformer;
    }

    private void setGroupNameTransformer(Mapper groupNameTransformer) {
        this.groupNameTransformer = groupNameTransformer;
    }

    private void setUserNameCaseConversion(String userNameCaseConversion) {
        this.userNameCaseConversion = UgsyncCommonConstants.toCaseConversion((String)userNameCaseConversion);
    }

    private void setGroupNameCaseConversion(String groupNameCaseConversion) {
        this.groupNameCaseConversion = UgsyncCommonConstants.toCaseConversion((String)groupNameCaseConversion);
    }

    private List<String> getAllRegexPatterns(String baseProperty, Map<String, String> serviceConfig) {
        LOG.debug("==> getAllRegexPatterns({})", (Object)baseProperty);
        ArrayList<String> regexPatterns = new ArrayList<String>();
        String baseRegex = serviceConfig != null ? serviceConfig.get(baseProperty) : null;
        LOG.debug("baseRegex = {}, pluginConfig = {}", (Object)baseRegex, serviceConfig == null ? null : serviceConfig.keySet());
        if (baseRegex != null) {
            String nextRegex;
            regexPatterns.add(baseRegex);
            int i = 1;
            while ((nextRegex = serviceConfig.get(baseProperty + "." + i)) != null) {
                regexPatterns.add(nextRegex);
                ++i;
            }
        }
        LOG.debug("<== getAllRegexPatterns({}): ret={}", (Object)baseProperty, regexPatterns);
        return regexPatterns;
    }
}

