/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;
import org.apache.ranger.plugin.util.StringTokenReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ResourceMatcher {
    static final int DYNAMIC_EVALUATION_PENALTY = 8;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMatcher.class);
    protected final String value;
    protected final RangerRequestExprResolver exprResolver;
    protected StringTokenReplacer tokenReplacer;

    ResourceMatcher(String value, Map<String, String> options) {
        this.value = value;
        this.exprResolver = RangerAbstractResourceMatcher.getOptionReplaceReqExpressions(options) && RangerRequestExprResolver.hasExpressions(value) ? new RangerRequestExprResolver(value, null) : null;
    }

    public static boolean startsWithAnyChar(String value, String startChars) {
        boolean ret = false;
        if (value != null && !value.isEmpty() && startChars != null) {
            ret = StringUtils.contains((String)startChars, (char)value.charAt(0));
        }
        return ret;
    }

    public static boolean isMatch(RangerAccessRequest.ResourceElementMatchType matchType, RangerAccessRequest.ResourceElementMatchingScope matchingScope) {
        boolean ret;
        switch (matchType) {
            case SELF: {
                ret = true;
                break;
            }
            case CHILD: {
                ret = matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_CHILD;
                break;
            }
            case PREFIX: {
                ret = matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_PREFIX;
                break;
            }
            case NONE: {
                ret = false;
                break;
            }
            default: {
                LOG.error("invalid ResourceElementMatchType: {}}", (Object)matchType);
                ret = false;
            }
        }
        return ret;
    }

    public static boolean wildcardPrefixMatch(String value, String wildcardMatcher, IOCase caseSensitivity) {
        if (value == null && wildcardMatcher == null) {
            return true;
        }
        if (value == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        List<String> wcsTokens = ResourceMatcher.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcsTokens.size()) {
                String wcsToken = wcsTokens.get(wcsIdx);
                if (wcsToken.equals("?")) {
                    if (++textIdx > value.length()) break;
                    anyChars = false;
                } else if (wcsToken.equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcsTokens.size() - 1) {
                        textIdx = value.length();
                    }
                } else {
                    if (wcsToken.length() > value.length() - textIdx) {
                        wcsToken = wcsToken.substring(0, value.length() - textIdx);
                    }
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(value, textIdx, wcsToken)) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(value, textIdx + 1, wcsToken);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(value, textIdx, wcsToken)) break;
                    textIdx += wcsToken.length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcsTokens.size() && textIdx != value.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return anyChars;
    }

    static List<String> splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return Collections.singletonList(text);
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>(2);
        StringBuilder buffer = new StringBuilder();
        int prevChar = 0;
        for (int n : array) {
            if (n != 63 && n != 42) {
                buffer.append((char)n);
            } else {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (n == 63) {
                    list.add("?");
                } else if (prevChar != 42) {
                    list.add("*");
                }
            }
            prevChar = n;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.value + ")";
    }

    abstract boolean isMatch(String var1, Map<String, Object> var2);

    abstract boolean isPrefixMatch(String var1, Map<String, Object> var2);

    abstract boolean isChildMatch(String var1, Map<String, Object> var2);

    final boolean isMatch(String resourceValue, RangerAccessRequest.ResourceElementMatchingScope matchingScope, Map<String, Object> evalContext) {
        RangerAccessRequest.ResourceElementMatchType matchType = this.getMatchType(resourceValue, matchingScope, evalContext);
        return ResourceMatcher.isMatch(matchType, matchingScope);
    }

    final RangerAccessRequest.ResourceElementMatchType getMatchType(String resourceValue, RangerAccessRequest.ResourceElementMatchingScope matchingScope, Map<String, Object> evalContext) {
        RangerAccessRequest.ResourceElementMatchType ret = RangerAccessRequest.ResourceElementMatchType.NONE;
        if (this.isMatch(resourceValue, evalContext)) {
            ret = RangerAccessRequest.ResourceElementMatchType.SELF;
        } else if (matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_PREFIX) {
            if (this.isPrefixMatch(resourceValue, evalContext)) {
                ret = RangerAccessRequest.ResourceElementMatchType.PREFIX;
            }
        } else if (matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_CHILD && this.isChildMatch(resourceValue, evalContext)) {
            ret = RangerAccessRequest.ResourceElementMatchType.CHILD;
        }
        return ret;
    }

    abstract int getPriority();

    boolean isMatchAny() {
        return this.value != null && this.value.isEmpty();
    }

    boolean getNeedsDynamicEval() {
        return this.exprResolver != null || this.tokenReplacer != null;
    }

    void setDelimiters(char startDelimiterChar, char endDelimiterChar, char escapeChar, String tokenPrefix) {
        LOG.debug("==> setDelimiters(value= {}, startDelimiter={}, endDelimiter={}, escapeChar={}, prefix={}", new Object[]{this.value, Character.valueOf(startDelimiterChar), Character.valueOf(endDelimiterChar), Character.valueOf(escapeChar), tokenPrefix});
        if (this.exprResolver != null || StringTokenReplacer.hasToken(this.value, startDelimiterChar, endDelimiterChar, escapeChar)) {
            this.tokenReplacer = new StringTokenReplacer(startDelimiterChar, endDelimiterChar, escapeChar, tokenPrefix);
        }
        LOG.debug("<== setDelimiters(value= {}, startDelimiter={}, endDelimiter={}, escapeChar={}, prefix={}", new Object[]{this.value, Character.valueOf(startDelimiterChar), Character.valueOf(endDelimiterChar), Character.valueOf(escapeChar), tokenPrefix});
    }

    String getExpandedValue(Map<String, Object> evalContext) {
        RangerAccessRequest accessRequest;
        String ret = this.value;
        if (this.exprResolver != null && (accessRequest = RangerAccessRequestUtil.getRequestFromContext(evalContext)) != null) {
            ret = this.exprResolver.resolveExpressions(accessRequest);
        }
        if (this.tokenReplacer != null) {
            ret = this.tokenReplacer.replaceTokens(ret, evalContext);
        }
        return ret;
    }

    public static class PriorityComparator
    implements Comparator<ResourceMatcher>,
    Serializable {
        @Override
        public int compare(ResourceMatcher me, ResourceMatcher other) {
            return Integer.compare(me.getPriority(), other.getPriority());
        }
    }
}

