/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAbstractResourceMatcher
implements RangerResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAbstractResourceMatcher.class);
    public static final String WILDCARD_ASTERISK = "*";
    public static final String WILDCARD_QUESTION_MARK = "?";
    public static final String OPTION_IGNORE_CASE = "ignoreCase";
    public static final String OPTION_QUOTED_CASE_SENSITIVE = "quotedCaseSensitive";
    public static final String OPTION_QUOTE_CHARS = "quoteChars";
    public static final String OPTION_WILD_CARD = "wildCard";
    public static final String OPTION_REPLACE_TOKENS = "replaceTokens";
    public static final String OPTION_TOKEN_DELIMITER_START = "tokenDelimiterStart";
    public static final String OPTION_TOKEN_DELIMITER_END = "tokenDelimiterEnd";
    public static final String OPTION_TOKEN_DELIMITER_ESCAPE = "tokenDelimiterEscape";
    public static final String OPTION_TOKEN_DELIMITER_PREFIX = "tokenDelimiterPrefix";
    public static final String OPTION_REPLACE_REQ_EXPRESSIONS = "replaceReqExpressions";
    protected RangerServiceDef.RangerResourceDef resourceDef;
    protected RangerPolicy.RangerPolicyResource policyResource;
    protected boolean optIgnoreCase;
    protected boolean optQuotedCaseSensitive;
    protected String optQuoteChars = "\"";
    protected boolean optWildCard;
    protected List<String> policyValues;
    protected boolean policyIsExcludes;
    protected boolean isMatchAny;
    protected ResourceMatcherWrapper resourceMatchers;
    protected boolean optReplaceTokens;
    protected char startDelimiterChar = (char)123;
    protected char endDelimiterChar = (char)125;
    protected char escapeChar = (char)92;
    protected String tokenPrefix = "";

    public static boolean getOptionIgnoreCase(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_IGNORE_CASE, true);
    }

    public static boolean getOptionQuotedCaseSensitive(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_QUOTED_CASE_SENSITIVE, false);
    }

    public static String getOptionQuoteChars(Map<String, String> options) {
        return ServiceDefUtil.getOption(options, OPTION_QUOTE_CHARS, "\"");
    }

    public static boolean getOptionWildCard(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_WILD_CARD, true);
    }

    public static boolean getOptionReplaceTokens(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_REPLACE_TOKENS, true);
    }

    public static char getOptionDelimiterStart(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_START, '{');
    }

    public static char getOptionDelimiterEnd(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_END, '}');
    }

    public static char getOptionDelimiterEscape(Map<String, String> options) {
        return ServiceDefUtil.getCharOption(options, OPTION_TOKEN_DELIMITER_ESCAPE, '\\');
    }

    public static String getOptionDelimiterPrefix(Map<String, String> options) {
        return ServiceDefUtil.getOption(options, OPTION_TOKEN_DELIMITER_PREFIX, "");
    }

    public static boolean getOptionReplaceReqExpressions(Map<String, String> options) {
        return ServiceDefUtil.getBooleanOption(options, OPTION_REPLACE_REQ_EXPRESSIONS, true);
    }

    @Override
    public void setResourceDef(RangerServiceDef.RangerResourceDef resourceDef) {
        this.resourceDef = resourceDef;
    }

    @Override
    public void setPolicyResource(RangerPolicy.RangerPolicyResource policyResource) {
        this.policyResource = policyResource;
    }

    @Override
    public void init() {
        LOG.debug("==> RangerAbstractResourceMatcher.init()");
        Map<String, String> options = this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(options);
        this.optQuotedCaseSensitive = RangerAbstractResourceMatcher.getOptionQuotedCaseSensitive(options);
        this.optQuoteChars = RangerAbstractResourceMatcher.getOptionQuoteChars(options);
        this.optWildCard = RangerAbstractResourceMatcher.getOptionWildCard(options);
        this.policyValues = new ArrayList<String>();
        boolean bl = this.policyIsExcludes = this.policyResource != null && this.policyResource.getIsExcludes() != false;
        if (this.policyResource != null && this.policyResource.getValues() != null) {
            for (String policyValue : this.policyResource.getValues()) {
                if (StringUtils.isEmpty((String)policyValue)) continue;
                this.policyValues.add(policyValue);
            }
        }
        this.optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(options);
        if (this.optReplaceTokens) {
            this.startDelimiterChar = RangerAbstractResourceMatcher.getOptionDelimiterStart(options);
            this.endDelimiterChar = RangerAbstractResourceMatcher.getOptionDelimiterEnd(options);
            this.escapeChar = RangerAbstractResourceMatcher.getOptionDelimiterEscape(options);
            this.tokenPrefix = RangerAbstractResourceMatcher.getOptionDelimiterPrefix(options);
            if (this.escapeChar == this.startDelimiterChar || this.escapeChar == this.endDelimiterChar || this.tokenPrefix.indexOf(this.escapeChar) != -1 || this.tokenPrefix.indexOf(this.startDelimiterChar) != -1 || this.tokenPrefix.indexOf(this.endDelimiterChar) != -1) {
                String resouceName = this.resourceDef == null ? "" : this.resourceDef.getName();
                String msg = "Invalid token-replacement parameters for resource '" + resouceName + "': { ";
                msg = msg + "tokenDelimiterStart='" + this.startDelimiterChar + "'; ";
                msg = msg + "tokenDelimiterEnd='" + this.endDelimiterChar + "'; ";
                msg = msg + "tokenDelimiterEscape='" + this.escapeChar + "'; ";
                msg = msg + "tokenDelimiterPrefix='" + this.tokenPrefix + "' }. ";
                msg = msg + "Token replacement disabled";
                LOG.error(msg);
                this.optReplaceTokens = false;
            }
        }
        this.resourceMatchers = this.buildResourceMatchers();
        this.isMatchAny = this.resourceMatchers == null || CollectionUtils.isEmpty(this.resourceMatchers.getResourceMatchers());
        LOG.debug("<== RangerAbstractResourceMatcher.init()");
    }

    @Override
    public boolean isMatchAny() {
        return this.isMatchAny;
    }

    @Override
    public boolean isCompleteMatch(String resource, Map<String, Object> evalContext) {
        LOG.debug("==> RangerAbstractResourceMatcher.isCompleteMatch({}, {})", (Object)resource, evalContext);
        boolean ret = false;
        if (CollectionUtils.isEmpty(this.policyValues)) {
            ret = StringUtils.isEmpty((String)resource);
        } else if (this.policyValues.size() == 1) {
            String policyValue = this.policyValues.get(0);
            if (this.isMatchAny) {
                ret = StringUtils.isEmpty((String)resource) || StringUtils.containsOnly((String)resource, (String)WILDCARD_ASTERISK);
            } else {
                boolean bl = ret = this.optIgnoreCase && (!this.optQuotedCaseSensitive || !ResourceMatcher.startsWithAnyChar(resource, this.optQuoteChars)) ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
            }
            if (this.policyIsExcludes) {
                ret = !ret;
            }
        }
        LOG.debug("<== RangerAbstractResourceMatcher.isCompleteMatch({}, {}): {}", new Object[]{resource, evalContext, ret});
        return ret;
    }

    @Override
    public boolean getNeedsDynamicEval() {
        return this.resourceMatchers != null && this.resourceMatchers.getNeedsDynamicEval();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractResourceMatcher={");
        sb.append("resourceDef={");
        if (this.resourceDef != null) {
            this.resourceDef.toString(sb);
        }
        sb.append("} ");
        sb.append("policyResource={");
        if (this.policyResource != null) {
            this.policyResource.toString(sb);
        }
        sb.append("} ");
        sb.append("optIgnoreCase={").append(this.optIgnoreCase).append("} ");
        sb.append("optQuotedCaseSensitive={").append(this.optQuotedCaseSensitive).append("} ");
        sb.append("optQuoteChars={").append(this.optQuoteChars).append("} ");
        sb.append("optWildCard={").append(this.optWildCard).append("} ");
        sb.append("policyValues={");
        if (this.policyValues != null) {
            for (String string : this.policyValues) {
                sb.append(string).append(",");
            }
        }
        sb.append("} ");
        sb.append("policyIsExcludes={").append(this.policyIsExcludes).append("} ");
        sb.append("isMatchAny={").append(this.isMatchAny).append("} ");
        sb.append("options={");
        if (this.resourceDef != null && this.resourceDef.getMatcherOptions() != null) {
            for (Map.Entry entry : this.resourceDef.getMatcherOptions().entrySet()) {
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(';');
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    public boolean applyExcludes(boolean allValuesRequested, boolean resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return !resultWithoutExcludes;
    }

    public RangerAccessRequest.ResourceElementMatchType applyExcludes(boolean allValuesRequested, RangerAccessRequest.ResourceElementMatchType resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return resultWithoutExcludes == RangerAccessRequest.ResourceElementMatchType.NONE ? RangerAccessRequest.ResourceElementMatchType.SELF : RangerAccessRequest.ResourceElementMatchType.NONE;
    }

    protected Map<String, String> getOptions() {
        return this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
    }

    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher = this.getMatcher(policyValue);
            if (matcher == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        resourceMatchers.sort(new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    boolean isAllValuesRequested(Object resource) {
        boolean result = resource == null ? true : (resource instanceof String ? StringUtils.isEmpty((String)((String)resource)) || WILDCARD_ASTERISK.equals(resource) : false);
        LOG.debug("isAllValuesRequested({}): {}", resource, (Object)result);
        return result;
    }

    ResourceMatcher getMatcher(String policyValue) {
        AbstractStringResourceMatcher ret;
        int len;
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        int wildcardStartIdx = -1;
        int wildcardEndIdx = -1;
        boolean needWildcardMatch = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c == '?') {
                    needWildcardMatch = true;
                    break;
                }
                if (c != '*') continue;
                if (wildcardEndIdx == -1 || wildcardEndIdx == i - 1) {
                    wildcardEndIdx = i;
                    if (wildcardStartIdx != -1) continue;
                    wildcardStartIdx = i;
                    continue;
                }
                needWildcardMatch = true;
                break;
            }
        }
        if (needWildcardMatch) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveWildcardMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveWildcardMatcher(policyValue, this.getOptions())) : new CaseSensitiveWildcardMatcher(policyValue, this.getOptions());
        } else if (wildcardStartIdx == -1) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveStringMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveStringMatcher(policyValue, this.getOptions())) : new CaseSensitiveStringMatcher(policyValue, this.getOptions());
        } else if (wildcardStartIdx == 0) {
            String matchStr = policyValue.substring(wildcardEndIdx + 1);
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveEndsWithMatcher(matchStr, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveEndsWithMatcher(matchStr, this.getOptions())) : new CaseSensitiveEndsWithMatcher(matchStr, this.getOptions());
        } else if (wildcardEndIdx != len - 1) {
            ret = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveWildcardMatcher(policyValue, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveWildcardMatcher(policyValue, this.getOptions())) : new CaseSensitiveWildcardMatcher(policyValue, this.getOptions());
        } else {
            String matchStr = policyValue.substring(0, wildcardStartIdx);
            AbstractStringResourceMatcher abstractStringResourceMatcher = this.optIgnoreCase ? (this.optQuotedCaseSensitive ? new QuotedCaseSensitiveStartsWithMatcher(matchStr, this.getOptions(), this.optQuoteChars) : new CaseInsensitiveStartsWithMatcher(matchStr, this.getOptions())) : (ret = new CaseSensitiveStartsWithMatcher(matchStr, this.getOptions()));
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static final class ResourceMatcherWrapper {
        private final boolean needsDynamicEval;
        private final List<ResourceMatcher> resourceMatchers;

        ResourceMatcherWrapper() {
            this(false, null);
        }

        ResourceMatcherWrapper(boolean needsDynamicEval, List<ResourceMatcher> resourceMatchers) {
            this.needsDynamicEval = needsDynamicEval;
            this.resourceMatchers = resourceMatchers;
        }

        boolean getNeedsDynamicEval() {
            return this.needsDynamicEval;
        }

        List<ResourceMatcher> getResourceMatchers() {
            return this.resourceMatchers;
        }
    }

    static final class QuotedCaseSensitiveWildcardMatcher
    extends AbstractStringResourceMatcher {
        private final String quoteChars;

        QuotedCaseSensitiveWildcardMatcher(String value, Map<String, String> options, String quoteChars) {
            super(value, options);
            this.quoteChars = quoteChars;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            IOCase caseSensitivity = QuotedCaseSensitiveWildcardMatcher.startsWithAnyChar(resourceValue, this.quoteChars) ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
            return FilenameUtils.wildcardMatch((String)resourceValue, (String)this.getExpandedValue(evalContext), (IOCase)caseSensitivity);
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            IOCase caseSensitivity = QuotedCaseSensitiveWildcardMatcher.startsWithAnyChar(resourceValue, this.quoteChars) ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
            return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), caseSensitivity);
        }

        @Override
        int getPriority() {
            return 6 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseInsensitiveWildcardMatcher
    extends AbstractStringResourceMatcher {
        CaseInsensitiveWildcardMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return FilenameUtils.wildcardMatch((String)resourceValue, (String)this.getExpandedValue(evalContext), (IOCase)IOCase.INSENSITIVE);
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), IOCase.INSENSITIVE);
        }

        @Override
        int getPriority() {
            return 6 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveWildcardMatcher
    extends AbstractStringResourceMatcher {
        CaseSensitiveWildcardMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return FilenameUtils.wildcardMatch((String)resourceValue, (String)this.getExpandedValue(evalContext), (IOCase)IOCase.SENSITIVE);
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), IOCase.SENSITIVE);
        }

        @Override
        int getPriority() {
            return 5 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class QuotedCaseSensitiveEndsWithMatcher
    extends AbstractStringResourceMatcher {
        private final String quoteChars;

        QuotedCaseSensitiveEndsWithMatcher(String value, Map<String, String> options, String quoteChars) {
            super(value, options);
            this.quoteChars = quoteChars;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            if (QuotedCaseSensitiveEndsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
                return StringUtils.endsWith((String)resourceValue, (String)this.getExpandedValue(evalContext));
            }
            return StringUtils.endsWithIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return true;
        }

        @Override
        int getPriority() {
            return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseInsensitiveEndsWithMatcher
    extends AbstractStringResourceMatcher {
        CaseInsensitiveEndsWithMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.endsWithIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return true;
        }

        @Override
        int getPriority() {
            return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveEndsWithMatcher
    extends AbstractStringResourceMatcher {
        CaseSensitiveEndsWithMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.endsWith((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return true;
        }

        @Override
        int getPriority() {
            return 3 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class QuotedCaseSensitiveStartsWithMatcher
    extends AbstractStringResourceMatcher {
        private final String quoteChars;

        QuotedCaseSensitiveStartsWithMatcher(String value, Map<String, String> options, String quoteChars) {
            super(value, options);
            this.quoteChars = quoteChars;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
                return StringUtils.startsWith((String)resourceValue, (String)this.getExpandedValue(evalContext));
            }
            return StringUtils.startsWithIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
                return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
            }
            return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseInsensitiveStartsWithMatcher
    extends AbstractStringResourceMatcher {
        CaseInsensitiveStartsWithMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWithIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveStartsWithMatcher
    extends AbstractStringResourceMatcher {
        CaseSensitiveStartsWithMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWith((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 3 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class QuotedCaseSensitiveStringMatcher
    extends AbstractStringResourceMatcher {
        private final String quoteChars;

        QuotedCaseSensitiveStringMatcher(String value, Map<String, String> options, String quoteChars) {
            super(value, options);
            this.quoteChars = quoteChars;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            if (QuotedCaseSensitiveStringMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
                return StringUtils.equals((String)resourceValue, (String)this.getExpandedValue(evalContext));
            }
            return StringUtils.equalsIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (QuotedCaseSensitiveStringMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
                return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
            }
            return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 2 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseInsensitiveStringMatcher
    extends AbstractStringResourceMatcher {
        CaseInsensitiveStringMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.equalsIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 2 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveStringMatcher
    extends AbstractStringResourceMatcher {
        CaseSensitiveStringMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.equals((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 1 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static abstract class AbstractStringResourceMatcher
    extends ResourceMatcher {
        protected AbstractStringResourceMatcher(String value, Map<String, String> options) {
            super(value, options);
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            return false;
        }
    }
}

