/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;

public interface RangerPolicyEvaluator {
    public static final Comparator<RangerPolicyEvaluator> EVAL_ORDER_COMPARATOR = new PolicyEvalOrderComparator();
    public static final Comparator<RangerPolicyEvaluator> NAME_COMPARATOR = new PolicyNameComparator();
    public static final Integer ACCESS_DENIED = -1;
    public static final Integer ACCESS_UNDETERMINED = 0;
    public static final Integer ACCESS_ALLOWED = 1;
    public static final Integer ACCESS_CONDITIONAL = 2;
    public static final String EVALUATOR_TYPE_AUTO = "auto";
    public static final String EVALUATOR_TYPE_OPTIMIZED = "optimized";
    public static final String EVALUATOR_TYPE_CACHED = "cached";

    public static boolean hasContextSensitiveSpecification(RangerPolicy.RangerPolicyItem policyItem) {
        return CollectionUtils.isNotEmpty(policyItem.getConditions()) || policyItem.getUsers().contains("{OWNER}");
    }

    public static boolean hasReference(RangerPolicy.RangerPolicyItem policyItem, Set<String> users, Set<String> groups, Set<String> roles) {
        return RangerPolicyEvaluator.containsAny(policyItem.getUsers(), users) || RangerPolicyEvaluator.containsAny(policyItem.getGroups(), groups) || RangerPolicyEvaluator.containsAny(policyItem.getRoles(), roles);
    }

    public static boolean hasRoles(RangerPolicy.RangerPolicyItem policyItem) {
        return CollectionUtils.isNotEmpty(policyItem.getRoles());
    }

    public static int compareStrings(String str1, String str2) {
        if (str1 == null) {
            return str2 == null ? 0 : -1;
        }
        return str2 == null ? 1 : str1.compareTo(str2);
    }

    public static boolean containsAny(Collection<String> coll1, Collection<String> coll2) {
        return coll1 != null && coll2 != null && CollectionUtils.containsAny(coll1, coll2);
    }

    public void init(RangerPolicy var1, RangerServiceDef var2, RangerPolicyEngineOptions var3);

    public RangerPolicy getPolicy();

    public RangerServiceDef getServiceDef();

    public boolean hasAllow();

    public boolean hasDeny();

    public long getPolicyId();

    public int getPolicyPriority();

    public List<RangerPolicyResourceEvaluator> getResourceEvaluators();

    public boolean isApplicable(Date var1);

    public int getEvalOrder();

    public int getPolicyConditionsCount();

    public int getCustomConditionsCount();

    public int getValidityScheduleEvaluatorsCount();

    public boolean isAuditEnabled();

    public void evaluate(RangerAccessRequest var1, RangerAccessResult var2);

    public void getResourceACLs(RangerAccessRequest var1, RangerResourceACLs var2, boolean var3, Set<String> var4, RangerPolicyResourceMatcher.MatchType var5, PolicyEngine var6);

    public boolean isMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isCompleteMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> var1, List<Map<String, RangerPolicy.RangerPolicyResource>> var2, Map<String, Object> var3);

    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> var1, List<Map<String, RangerPolicy.RangerPolicyResource>> var2, String var3, Set<String> var4, String var5);

    public void updateAccessResult(RangerAccessResult var1, RangerPolicyResourceMatcher.MatchType var2, boolean var3, String var4);

    public void getResourceAccessInfo(RangerAccessRequest var1, RangerResourceAccessInfo var2);

    public Set<String> getAllowedAccesses(RangerAccessResource var1, String var2, Set<String> var3, Set<String> var4, Set<String> var5);

    public Set<String> getAllowedAccesses(Map<String, RangerPolicy.RangerPolicyResource> var1, String var2, Set<String> var3, Set<String> var4, Set<String> var5, Map<String, Object> var6);

    public PolicyACLSummary getPolicyACLSummary();

    default public boolean hasContextSensitiveSpecification() {
        RangerPolicy policy = this.getPolicy();
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getPolicyItems()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyPolicyItems()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getAllowExceptions()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyExceptions()) {
            if (!RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasReference(Set<String> users, Set<String> groups, Set<String> roles) {
        RangerPolicy policy = this.getPolicy();
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getPolicyItems()) {
            if (!RangerPolicyEvaluator.hasReference(policyItem, users, groups, roles)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyPolicyItems()) {
            if (!RangerPolicyEvaluator.hasReference(policyItem, users, groups, roles)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getAllowExceptions()) {
            if (!RangerPolicyEvaluator.hasReference(policyItem, users, groups, roles)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getDenyExceptions()) {
            if (!RangerPolicyEvaluator.hasReference(policyItem, users, groups, roles)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasRoles(RangerPolicy policy) {
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getPolicyItems()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerPolicyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyPolicyItems()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerPolicyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getAllowExceptions()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerPolicyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyExceptions()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerPolicyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerDataMaskPolicyItem rangerDataMaskPolicyItem : policy.getDataMaskPolicyItems()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerDataMaskPolicyItem)) continue;
            return true;
        }
        for (RangerPolicy.RangerRowFilterPolicyItem rangerRowFilterPolicyItem : policy.getRowFilterPolicyItems()) {
            if (!RangerPolicyEvaluator.hasRoles(rangerRowFilterPolicyItem)) continue;
            return true;
        }
        return false;
    }

    public static class PolicyACLSummary {
        private final Map<String, Map<String, AccessResult>> usersAccessInfo = new HashMap<String, Map<String, AccessResult>>();
        private final Map<String, Map<String, AccessResult>> groupsAccessInfo = new HashMap<String, Map<String, AccessResult>>();
        private final Map<String, Map<String, AccessResult>> rolesAccessInfo = new HashMap<String, Map<String, AccessResult>>();
        private final List<RangerResourceACLs.RowFilterResult> rowFilters = new ArrayList<RangerResourceACLs.RowFilterResult>();
        private final List<RangerResourceACLs.DataMaskResult> dataMasks = new ArrayList<RangerResourceACLs.DataMaskResult>();

        PolicyACLSummary() {
        }

        public Map<String, Map<String, AccessResult>> getUsersAccessInfo() {
            return this.usersAccessInfo;
        }

        public Map<String, Map<String, AccessResult>> getGroupsAccessInfo() {
            return this.groupsAccessInfo;
        }

        public Map<String, Map<String, AccessResult>> getRolesAccessInfo() {
            return this.rolesAccessInfo;
        }

        public List<RangerResourceACLs.RowFilterResult> getRowFilters() {
            return this.rowFilters;
        }

        public List<RangerResourceACLs.DataMaskResult> getDataMasks() {
            return this.dataMasks;
        }

        void processPolicyItem(RangerPolicy.RangerPolicyItem policyItem, int policyItemType, boolean isConditional, Map<String, Collection<String>> impliedAccessGrants) {
            Integer result;
            boolean hasContextSensitiveSpecification = CollectionUtils.isNotEmpty(policyItem.getConditions());
            switch (policyItemType) {
                case 0: {
                    result = hasContextSensitiveSpecification || isConditional ? ACCESS_CONDITIONAL : ACCESS_ALLOWED;
                    break;
                }
                case 2: {
                    result = hasContextSensitiveSpecification || isConditional ? null : ACCESS_DENIED;
                    break;
                }
                case 1: {
                    result = hasContextSensitiveSpecification || isConditional ? ACCESS_CONDITIONAL : ACCESS_DENIED;
                    break;
                }
                case 3: {
                    result = hasContextSensitiveSpecification || isConditional ? null : ACCESS_ALLOWED;
                    break;
                }
                default: {
                    result = null;
                }
            }
            if (result != null) {
                ArrayList<RangerPolicy.RangerPolicyItemAccess> accesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>(policyItem.getAccesses());
                if (policyItem.getDelegateAdmin().booleanValue()) {
                    accesses.add(new RangerPolicy.RangerPolicyItemAccess("_admin", policyItem.getDelegateAdmin()));
                }
                if (impliedAccessGrants != null && !impliedAccessGrants.isEmpty() && CollectionUtils.isNotEmpty(policyItem.getAccesses())) {
                    for (Map.Entry<String, Collection<String>> e : impliedAccessGrants.entrySet()) {
                        String implyingAccessType = e.getKey();
                        Collection<String> impliedGrants = e.getValue();
                        RangerPolicy.RangerPolicyItemAccess access = RangerDefaultPolicyEvaluator.getAccess(policyItem, implyingAccessType);
                        if (access == null) continue;
                        for (String impliedGrant : impliedGrants) {
                            RangerPolicy.RangerPolicyItemAccess impliedAccess = RangerDefaultPolicyEvaluator.getAccess(policyItem, impliedGrant);
                            if (impliedAccess == null) {
                                impliedAccess = new RangerPolicy.RangerPolicyItemAccess(impliedGrant, access.getIsAllowed());
                                accesses.add(impliedAccess);
                                continue;
                            }
                            if (impliedAccess.getIsAllowed().booleanValue()) continue;
                            impliedAccess.setIsAllowed(access.getIsAllowed());
                        }
                    }
                }
                List<String> groups = policyItem.getGroups();
                List<String> users = policyItem.getUsers();
                List<String> roles = policyItem.getRoles();
                boolean hasPublicGroup = false;
                for (RangerPolicy.RangerPolicyItemAccess access : accesses) {
                    for (String user : users) {
                        if (StringUtils.equals((String)user, (String)"{USER}")) {
                            hasPublicGroup = true;
                            continue;
                        }
                        if (StringUtils.isBlank((String)user)) continue;
                        this.addAccess(user, AccessorType.USER, access.getType(), result, policyItemType);
                    }
                    for (String group : groups) {
                        if (StringUtils.equals((String)group, (String)"public")) {
                            hasPublicGroup = true;
                            continue;
                        }
                        this.addAccess(group, AccessorType.GROUP, access.getType(), result, policyItemType);
                    }
                    if (hasPublicGroup) {
                        this.addAccess("public", AccessorType.GROUP, access.getType(), result, policyItemType);
                    }
                    for (String role : roles) {
                        this.addAccess(role, AccessorType.ROLE, access.getType(), result, policyItemType);
                    }
                }
            }
        }

        void processRowFilterPolicyItem(RangerPolicy.RangerRowFilterPolicyItem policyItem) {
            HashSet<String> users = new HashSet<String>(policyItem.getUsers());
            HashSet<String> groups = new HashSet<String>(policyItem.getGroups());
            HashSet<String> roles = new HashSet<String>(policyItem.getRoles());
            HashSet<String> accessTypes = new HashSet<String>();
            policyItem.getAccesses().forEach(accessType -> accessTypes.add(accessType.getType()));
            if (users.contains("{USER}")) {
                users.remove("{USER}");
                groups.add("public");
            }
            RangerResourceACLs.RowFilterResult filterResult = new RangerResourceACLs.RowFilterResult(users, groups, roles, accessTypes, policyItem.getRowFilterInfo());
            if (RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) {
                filterResult.setIsConditional(true);
            }
            this.rowFilters.add(filterResult);
        }

        void processDataMaskPolicyItem(RangerPolicy.RangerDataMaskPolicyItem policyItem) {
            HashSet<String> users = new HashSet<String>(policyItem.getUsers());
            HashSet<String> groups = new HashSet<String>(policyItem.getGroups());
            HashSet<String> roles = new HashSet<String>(policyItem.getRoles());
            HashSet<String> accessTypes = new HashSet<String>();
            policyItem.getAccesses().forEach(accessType -> accessTypes.add(accessType.getType()));
            if (users.contains("{USER}")) {
                users.remove("{USER}");
                groups.add("public");
            }
            RangerResourceACLs.DataMaskResult dataMaskResult = new RangerResourceACLs.DataMaskResult(users, groups, roles, accessTypes, policyItem.getDataMaskInfo());
            if (RangerPolicyEvaluator.hasContextSensitiveSpecification(policyItem)) {
                dataMaskResult.setIsConditional(true);
            }
            this.dataMasks.add(dataMaskResult);
        }

        void finalizeAcls(boolean isDenyAllElse, Set<String> allAccessTypeNames) {
            Map publicGroupAccessInfo = this.groupsAccessInfo.get("public");
            if (publicGroupAccessInfo != null) {
                for (Map.Entry<String, Object> entry : publicGroupAccessInfo.entrySet()) {
                    Map<String, AccessResult> mapValue;
                    Iterator<Object> accessType = entry.getKey();
                    AccessResult accessResult = (AccessResult)entry.getValue();
                    int access = accessResult.getResult();
                    if (access != ACCESS_DENIED && access != ACCESS_ALLOWED) continue;
                    ArrayList<String> keysToRemove = null;
                    for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.usersAccessInfo.entrySet()) {
                        mapValue = mapEntry.getValue();
                        mapValue.remove(accessType);
                        if (!mapValue.isEmpty()) continue;
                        if (keysToRemove == null) {
                            keysToRemove = new ArrayList<String>();
                        }
                        keysToRemove.add(mapEntry.getKey());
                    }
                    if (keysToRemove != null) {
                        for (String keyToRemove : keysToRemove) {
                            this.usersAccessInfo.remove(keyToRemove);
                        }
                        keysToRemove.clear();
                    }
                    for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.groupsAccessInfo.entrySet()) {
                        if (StringUtils.equals((String)mapEntry.getKey(), (String)"public")) continue;
                        mapValue = mapEntry.getValue();
                        mapValue.remove(accessType);
                        if (!mapValue.isEmpty()) continue;
                        if (keysToRemove == null) {
                            keysToRemove = new ArrayList();
                        }
                        keysToRemove.add(mapEntry.getKey());
                    }
                    if (keysToRemove == null) continue;
                    for (String keyToRemove : keysToRemove) {
                        this.groupsAccessInfo.remove(keyToRemove);
                    }
                    keysToRemove.clear();
                }
            }
            if (isDenyAllElse) {
                for (Map.Entry<String, Object> entry : this.usersAccessInfo.entrySet()) {
                    for (Map.Entry accessEntry : ((Map)entry.getValue()).entrySet()) {
                        AccessResult result = (AccessResult)accessEntry.getValue();
                        if (result.getResult() != ACCESS_UNDETERMINED.intValue()) continue;
                        result.setResult(ACCESS_DENIED);
                    }
                }
                for (Map.Entry<String, Object> entry : this.groupsAccessInfo.entrySet()) {
                    for (Map.Entry accessEntry : ((Map)entry.getValue()).entrySet()) {
                        AccessResult result = (AccessResult)accessEntry.getValue();
                        if (result.getResult() != ACCESS_UNDETERMINED.intValue()) continue;
                        result.setResult(ACCESS_DENIED);
                    }
                }
                for (Map.Entry<String, Object> entry : this.usersAccessInfo.entrySet()) {
                    for (String accessTypeName : allAccessTypeNames) {
                        if (((Map)entry.getValue()).containsKey(accessTypeName)) continue;
                        ((Map)entry.getValue()).put(accessTypeName, new AccessResult(ACCESS_DENIED, true));
                    }
                }
                for (Map.Entry<String, Object> entry : this.groupsAccessInfo.entrySet()) {
                    for (String accessTypeName : allAccessTypeNames) {
                        if (((Map)entry.getValue()).containsKey(accessTypeName)) continue;
                        ((Map)entry.getValue()).put(accessTypeName, new AccessResult(ACCESS_DENIED, true));
                    }
                }
                publicGroupAccessInfo = this.groupsAccessInfo.computeIfAbsent("public", k -> new HashMap());
                Set accessTypeNamesInPublicGroup = publicGroupAccessInfo.keySet();
                for (String accessTypeName : allAccessTypeNames) {
                    AccessResult result;
                    if (accessTypeNamesInPublicGroup.contains(accessTypeName)) continue;
                    boolean isDenyAccess = true;
                    for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.usersAccessInfo.entrySet()) {
                        result = mapEntry.getValue().get(accessTypeName);
                        if (result != null && result.getResult() == ACCESS_DENIED.intValue()) continue;
                        isDenyAccess = false;
                        break;
                    }
                    if (isDenyAccess) {
                        for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.groupsAccessInfo.entrySet()) {
                            if (StringUtils.equals((String)mapEntry.getKey(), (String)"public") || (result = mapEntry.getValue().get(accessTypeName)) != null && result.getResult() == ACCESS_DENIED.intValue()) continue;
                            isDenyAccess = false;
                            break;
                        }
                    }
                    publicGroupAccessInfo.put(accessTypeName, new AccessResult(isDenyAccess ? ACCESS_DENIED : ACCESS_CONDITIONAL, true));
                }
            }
        }

        public String toString() {
            return "PolicyACLSummary{usersAccessInfo=" + this.usersAccessInfo + ", groupsAccessInfo=" + this.groupsAccessInfo + ", rolesAccessInfo=" + this.rolesAccessInfo + ", rowFilters=" + this.rowFilters + ", dataMasks=" + this.dataMasks + '}';
        }

        private void addAccess(String accessorName, AccessorType accessorType, String accessType, Integer access, int policyItemType) {
            Map<String, Map<String, AccessResult>> accessorsAccessInfo;
            switch (accessorType) {
                case USER: {
                    accessorsAccessInfo = this.usersAccessInfo;
                    break;
                }
                case GROUP: {
                    accessorsAccessInfo = this.groupsAccessInfo;
                    break;
                }
                case ROLE: {
                    accessorsAccessInfo = this.rolesAccessInfo;
                    break;
                }
                default: {
                    return;
                }
            }
            Map accessorAccessInfo = accessorsAccessInfo.computeIfAbsent(accessorName, k -> new HashMap());
            AccessResult currentAccess = (AccessResult)accessorAccessInfo.get(accessType);
            if (currentAccess == null) {
                if (policyItemType == 0 || policyItemType == 1) {
                    accessorAccessInfo.put(accessType, new AccessResult(access, policyItemType == 1));
                }
            } else if (access.equals(ACCESS_DENIED)) {
                if (currentAccess.getResult() == ACCESS_CONDITIONAL.intValue()) {
                    currentAccess.setResult(access);
                } else {
                    int updatedAccessValue = currentAccess.getResult() + access;
                    updatedAccessValue = policyItemType == 1 ? (updatedAccessValue < ACCESS_DENIED ? ACCESS_DENIED : updatedAccessValue) : (updatedAccessValue < ACCESS_UNDETERMINED ? ACCESS_UNDETERMINED : updatedAccessValue);
                    currentAccess.setResult(updatedAccessValue);
                }
            } else if (access.equals(ACCESS_ALLOWED)) {
                if (currentAccess.getResult() == ACCESS_CONDITIONAL.intValue()) {
                    if (policyItemType == 0) {
                        currentAccess.setResult(access);
                    }
                } else {
                    int updatedAccessValue = currentAccess.getResult() + access;
                    boolean replaceValue = false;
                    if (policyItemType == 0) {
                        updatedAccessValue = updatedAccessValue > ACCESS_ALLOWED ? ACCESS_ALLOWED : updatedAccessValue;
                        replaceValue = true;
                    } else {
                        int n = updatedAccessValue = updatedAccessValue > ACCESS_UNDETERMINED ? ACCESS_UNDETERMINED : updatedAccessValue;
                    }
                    if (replaceValue) {
                        accessorAccessInfo.put(accessType, new AccessResult(updatedAccessValue));
                    } else {
                        currentAccess.setResult(updatedAccessValue);
                    }
                }
            } else if (currentAccess.getResult() == ACCESS_UNDETERMINED.intValue()) {
                currentAccess.setResult(access);
            }
        }

        public static class AccessResult {
            private final boolean hasSeenDeny;
            private int result;

            public AccessResult(int result) {
                this(result, false);
            }

            public AccessResult(int result, boolean hasSeenDeny) {
                this.result = result;
                this.hasSeenDeny = hasSeenDeny;
            }

            public int getResult() {
                return this.result;
            }

            public void setResult(int result) {
                this.result = result;
            }

            public boolean getHasSeenDeny() {
                return this.hasSeenDeny;
            }

            public String toString() {
                if (this.result == ACCESS_ALLOWED) {
                    return "ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                if (this.result == ACCESS_DENIED) {
                    return "NOT_ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                if (this.result == ACCESS_CONDITIONAL) {
                    return "CONDITIONAL_ALLOWED, hasSeenDeny=" + this.hasSeenDeny;
                }
                return "NOT_DETERMINED, hasSeenDeny=" + this.hasSeenDeny;
            }
        }

        private static enum AccessorType {
            USER,
            GROUP,
            ROLE;

        }
    }

    public static class PolicyNameComparator
    implements Comparator<RangerPolicyEvaluator>,
    Serializable {
        @Override
        public int compare(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = Integer.compare(other.getPolicyPriority(), me.getPolicyPriority());
            return result == 0 ? this.compareNormal(me, other) : result;
        }

        private int compareNormal(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = me.hasDeny() && !other.hasDeny() ? -1 : (!me.hasDeny() && other.hasDeny() ? 1 : RangerPolicyEvaluator.compareStrings(me.getPolicy().getName(), other.getPolicy().getName()));
            return result;
        }
    }

    public static class PolicyEvalOrderComparator
    implements Comparator<RangerPolicyEvaluator>,
    Serializable {
        @Override
        public int compare(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result = Integer.compare(other.getPolicyPriority(), me.getPolicyPriority());
            return result == 0 ? this.compareNormal(me, other) : result;
        }

        private int compareNormal(RangerPolicyEvaluator me, RangerPolicyEvaluator other) {
            int result;
            if (me.hasDeny() && !other.hasDeny()) {
                result = -1;
            } else if (!me.hasDeny() && other.hasDeny()) {
                result = 1;
            } else {
                result = Integer.compare(me.getEvalOrder(), other.getEvalOrder());
                if (result == 0) {
                    result = RangerPolicyEvaluator.compareStrings(me.getPolicy().getName(), other.getPolicy().getName());
                }
            }
            return result;
        }
    }

    public static interface RangerPolicyResourceEvaluator
    extends RangerResourceEvaluator {
        default public long getPolicyId() {
            RangerPolicyEvaluator evaluator = this.getPolicyEvaluator();
            return evaluator != null ? evaluator.getPolicyId() : -1L;
        }

        public RangerPolicyEvaluator getPolicyEvaluator();

        public RangerPolicyResourceMatcher getMacrosReplaceWithWildcardMatcher(PolicyEngine var1);
    }
}

