/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsDshidEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerCustomConditionEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsSharedResourceEvaluator
implements RangerResourceEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsSharedResourceEvaluator.class);
    public static final GdsSharedResourceEvalOrderComparator EVAL_ORDER_COMPARATOR = new GdsSharedResourceEvalOrderComparator();
    private final ServiceGdsInfo.SharedResourceInfo resource;
    private final RangerConditionEvaluator conditionEvaluator;
    private final Map<String, RangerPolicy.RangerPolicyResource> policyResource;
    private final RangerPolicyResourceMatcher policyResourceMatcher;
    private final RangerServiceDef.RangerResourceDef leafResourceDef;
    private final Set<String> allowedAccessTypes;
    private final List<GdsMaskEvaluator> maskEvaluators;

    public GdsSharedResourceEvaluator(ServiceGdsInfo.SharedResourceInfo resource, Set<String> defaultAccessTypes, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        this.resource = resource;
        this.conditionEvaluator = RangerCustomConditionEvaluator.getInstance().getExpressionEvaluator(resource.getConditionExpr(), serviceDefHelper.getServiceDef());
        if (this.resource.getResource() == null) {
            this.resource.setResource(Collections.emptyMap());
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getSubResourceType()) && resource.getSubResource() != null && CollectionUtils.isNotEmpty(resource.getSubResource().getValues())) {
            this.policyResource = new HashMap<String, RangerPolicy.RangerPolicyResource>(resource.getResource());
            this.policyResource.put(resource.getSubResourceType(), resource.getSubResource());
        } else {
            this.policyResource = resource.getResource();
        }
        this.policyResourceMatcher = GdsSharedResourceEvaluator.initPolicyResourceMatcher(this.policyResource, serviceDefHelper, pluginContext);
        this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDefHelper.getServiceDef(), this.policyResource);
        this.allowedAccessTypes = serviceDefHelper.expandImpliedAccessGrants(resource.getAccessTypes() != null ? resource.getAccessTypes() : defaultAccessTypes);
        if (serviceDefHelper.isDataMaskSupported(this.policyResource.keySet()) && CollectionUtils.isNotEmpty(resource.getSubResourceMasks())) {
            this.maskEvaluators = new ArrayList<GdsMaskEvaluator>(resource.getSubResourceMasks().size());
            RangerServiceDef.RangerResourceDef maskResourceDef = serviceDefHelper.getResourceDef(resource.getSubResourceType(), 1);
            for (RangerGds.RangerGdsMaskInfo maskInfo : resource.getSubResourceMasks()) {
                RangerDefaultResourceMatcher resourceMatcher = new RangerDefaultResourceMatcher();
                resourceMatcher.setResourceDef(maskResourceDef);
                resourceMatcher.setPolicyResource(new RangerPolicy.RangerPolicyResource(maskInfo.getValues(), Boolean.FALSE, Boolean.FALSE));
                resourceMatcher.init();
                this.maskEvaluators.add(new GdsMaskEvaluator(resourceMatcher, maskInfo.getMaskInfo()));
            }
        } else {
            this.maskEvaluators = Collections.emptyList();
        }
        LOG.debug("GdsSharedResourceEvaluator: resource={}, conditionEvaluator={}, policyResource={}, leafResourceDef={}, allowedAccessTypes={}", new Object[]{resource, this.conditionEvaluator, this.policyResource, this.leafResourceDef, this.allowedAccessTypes});
    }

    private GdsSharedResourceEvaluator(GdsSharedResourceEvaluator other, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext, int policyType) {
        this.resource = other.resource;
        this.conditionEvaluator = other.conditionEvaluator;
        this.allowedAccessTypes = other.allowedAccessTypes;
        List<Object> list = this.maskEvaluators = policyType == 1 ? other.maskEvaluators : Collections.emptyList();
        if (policyType == 2 && other.policyResource != other.resource.getResource()) {
            this.policyResource = new HashMap<String, RangerPolicy.RangerPolicyResource>(this.resource.getResource());
            this.policyResourceMatcher = GdsSharedResourceEvaluator.initPolicyResourceMatcher(this.policyResource, serviceDefHelper, pluginContext);
            this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDefHelper.getServiceDef(), this.policyResource);
        } else {
            this.policyResource = other.policyResource;
            this.policyResourceMatcher = other.policyResourceMatcher;
            this.leafResourceDef = other.leafResourceDef;
        }
    }

    @Override
    public long getId() {
        return this.resource.getId();
    }

    @Override
    public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
        return this.policyResourceMatcher;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policyResource;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.policyResourceMatcher.getResourceMatcher(resourceName);
    }

    @Override
    public boolean isAncestorOf(RangerServiceDef.RangerResourceDef resourceDef) {
        return ServiceDefUtil.isAncestorOf(this.policyResourceMatcher.getServiceDef(), this.leafResourceDef, resourceDef);
    }

    @Override
    public boolean isLeaf(String resourceName) {
        return StringUtils.equals((CharSequence)this.leafResourceDef.getName(), (CharSequence)resourceName);
    }

    public Long getDataShareId() {
        return this.resource.getDataShareId();
    }

    public Collection<String> getResourceKeys() {
        return this.resource != null && this.resource.getResource() != null ? this.resource.getResource().keySet() : Collections.emptySet();
    }

    public boolean isConditional() {
        return this.conditionEvaluator != null;
    }

    public Set<String> getAllowedAccessTypes() {
        return this.allowedAccessTypes;
    }

    public boolean isAllowed(RangerAccessRequest request) {
        boolean ret;
        LOG.debug("==> GdsSharedResourceEvaluator.evaluate({})", (Object)request);
        boolean bl = ret = this.conditionEvaluator == null || this.conditionEvaluator.isMatched(request);
        if (ret) {
            boolean bl2 = request.isAccessTypeAny() ? !this.allowedAccessTypes.isEmpty() : (ret = this.allowedAccessTypes.contains(request.getAccessType()));
            if (ret) {
                RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = request.getResourceMatchingScope() != null ? request.getResourceMatchingScope() : RangerAccessRequest.ResourceMatchingScope.SELF;
                RangerPolicyResourceMatcher.MatchType matchType = this.policyResourceMatcher.getMatchType(request.getResource(), request.getResourceElementMatchingScopes(), request.getContext());
                if (request.isAccessTypeAny() || resourceMatchingScope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                    ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS || matchType == RangerPolicyResourceMatcher.MatchType.DESCENDANT;
                } else {
                    boolean bl3 = ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                }
                if (!ret) {
                    LOG.debug("GdsSharedResourceEvaluator.evaluate({}): not matched for resource {}", (Object)request, (Object)request.getResource());
                }
            } else {
                LOG.debug("GdsSharedResourceEvaluator.evaluate({}): not matched for accessType {}", (Object)request, (Object)request.getAccessType());
            }
        } else {
            LOG.debug("GdsSharedResourceEvaluator.evaluate({}): not matched for condition {}", (Object)request, (Object)this.resource.getConditionExpr());
        }
        LOG.debug("<== GdsSharedResourceEvaluator.evaluate({})", (Object)request);
        return ret;
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls, boolean isConditional, List<GdsDshidEvaluator> dshidEvaluators) {
        LOG.debug("==> GdsSharedResourceEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
        boolean isResourceMatch = this.policyResourceMatcher.isMatch(request.getResource(), request.getResourceElementMatchingScopes(), request.getContext());
        if (isResourceMatch) {
            isConditional = isConditional || this.conditionEvaluator != null;
            for (GdsDshidEvaluator dshidEvaluator : dshidEvaluators) {
                dshidEvaluator.getResourceACLs(request, acls, isConditional, this.getAllowedAccessTypes());
            }
        }
        LOG.debug("<== GdsSharedResourceEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
    }

    public RangerPolicy.RangerPolicyItemRowFilterInfo getRowFilter() {
        return this.resource.getRowFilter();
    }

    public RangerPolicy.RangerPolicyItemDataMaskInfo getDataMask(String subResourceName) {
        GdsMaskEvaluator maskEvaluator = this.maskEvaluators.stream().filter(e -> e.isMatch(subResourceName)).findFirst().orElse(null);
        return maskEvaluator != null ? maskEvaluator.maskInfo : null;
    }

    GdsSharedResourceEvaluator createDataMaskEvaluator(RangerServiceDefHelper serviceDefHelper) {
        if (!serviceDefHelper.isDataMaskSupported(this.policyResource.keySet())) {
            return null;
        }
        return this;
    }

    GdsSharedResourceEvaluator createRowFilterEvaluator(RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        if (!serviceDefHelper.isRowFilterSupported(this.resource.getResource().keySet())) {
            return null;
        }
        if (this.policyResource == this.resource.getResource()) {
            return this;
        }
        return new GdsSharedResourceEvaluator(this, serviceDefHelper, pluginContext, 2);
    }

    private static RangerPolicyResourceMatcher initPolicyResourceMatcher(Map<String, RangerPolicy.RangerPolicyResource> policyResource, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
        matcher.setServiceDefHelper(serviceDefHelper);
        matcher.setServiceDef(serviceDefHelper.getServiceDef());
        matcher.setPolicyResources(policyResource, 0);
        matcher.setPluginContext(pluginContext);
        matcher.init();
        return matcher;
    }

    public static class GdsSharedResourceEvalOrderComparator
    implements Comparator<GdsSharedResourceEvaluator> {
        static int compareStrings(String str1, String str2) {
            if (str1 == null) {
                return str2 == null ? 0 : -1;
            }
            return str2 == null ? 1 : str1.compareTo(str2);
        }

        @Override
        public int compare(GdsSharedResourceEvaluator me, GdsSharedResourceEvaluator other) {
            int ret = 0;
            if (me != null && other != null) {
                ret = GdsSharedResourceEvalOrderComparator.compareStrings(me.resource.getName(), other.resource.getName());
                if (ret == 0 && (ret = Integer.compare(me.resource.getResource().size(), other.resource.getResource().size())) == 0) {
                    ret = Long.compare(me.getId(), other.getId());
                }
            } else if (me != null) {
                ret = -1;
            } else if (other != null) {
                ret = 1;
            }
            return ret;
        }
    }

    private static class GdsMaskEvaluator {
        private final RangerDefaultResourceMatcher resourceMatcher;
        private final RangerPolicy.RangerPolicyItemDataMaskInfo maskInfo;

        public GdsMaskEvaluator(RangerDefaultResourceMatcher resourceMatcher, RangerPolicy.RangerPolicyItemDataMaskInfo maskInfo) {
            this.resourceMatcher = resourceMatcher;
            this.maskInfo = maskInfo;
        }

        public boolean isMatch(String value) {
            return this.resourceMatcher.isMatch(value, RangerAccessRequest.ResourceElementMatchingScope.SELF, null);
        }

        public RangerPolicy.RangerPolicyItemDataMaskInfo getMaskInfo() {
            return this.maskInfo;
        }
    }
}

