/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsProjectEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsProjectEvaluator.class);
    public static final GdsProjectEvalOrderComparator EVAL_ORDER_COMPARATOR = new GdsProjectEvalOrderComparator();
    private final ServiceGdsInfo.ProjectInfo project;
    private final RangerServiceDef gdsServiceDef;
    private final String name;
    private final RangerValidityScheduleEvaluator scheduleEvaluator;
    private final List<RangerPolicyEvaluator> policyEvaluators;

    public GdsProjectEvaluator(ServiceGdsInfo.ProjectInfo project, RangerServiceDef gdsServiceDef, RangerPolicyEngineOptions options) {
        LOG.debug("==> GdsProjectEvaluator({})", (Object)project);
        this.project = project;
        this.gdsServiceDef = gdsServiceDef;
        this.name = StringUtils.isBlank((String)project.getName()) ? "" : project.getName();
        this.scheduleEvaluator = project.getValiditySchedule() != null ? new RangerValidityScheduleEvaluator(project.getValiditySchedule()) : null;
        if (project.getPolicies() != null) {
            this.policyEvaluators = new ArrayList<RangerPolicyEvaluator>(project.getPolicies().size());
            for (RangerPolicy policy : project.getPolicies()) {
                RangerOptimizedPolicyEvaluator evaluator = new RangerOptimizedPolicyEvaluator();
                evaluator.init(policy, gdsServiceDef, options);
                this.policyEvaluators.add(evaluator);
            }
        } else {
            this.policyEvaluators = Collections.emptyList();
        }
        LOG.debug("<== GdsProjectEvaluator({})", (Object)project);
    }

    public Long getId() {
        return this.project.getId();
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.scheduleEvaluator == null || this.scheduleEvaluator.isApplicable(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(RangerAccessRequest request, GdsAccessResult result) {
        LOG.debug("==> GdsDatasetEvaluator.evaluate({}, {})", (Object)request, (Object)result);
        if (this.isActive()) {
            result.addProject(this.getName());
            if (!this.policyEvaluators.isEmpty()) {
                GdsProjectAccessRequest projectRequest = new GdsProjectAccessRequest(this.getId(), this.gdsServiceDef, request);
                RangerAccessResult projectResult = projectRequest.createAccessResult();
                try {
                    RangerAccessRequestUtil.setAllRequestedAccessTypes(projectRequest.getContext(), null);
                    RangerAccessRequestUtil.setAccessTypeACLResults(projectRequest.getContext(), null);
                    this.policyEvaluators.forEach(e -> e.evaluate(projectRequest, projectResult));
                }
                finally {
                    RangerAccessRequestUtil.setAccessTypeResults(projectRequest.getContext(), null);
                    RangerAccessRequestUtil.setAccessTypeACLResults(projectRequest.getContext(), null);
                }
                if (projectResult.getIsAllowed()) {
                    result.addAllowedByProject(this.getName());
                }
                if (!result.getIsAllowed() && projectResult.getIsAllowed()) {
                    result.setIsAllowed(true);
                    result.setPolicyId(projectResult.getPolicyId());
                    result.setPolicyVersion(projectResult.getPolicyVersion());
                }
                if (!result.getIsAudited()) {
                    result.setIsAudited(projectResult.getIsAudited());
                }
            }
        }
        LOG.debug("<== GdsDatasetEvaluator.evaluate({}, {})", (Object)request, (Object)result);
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls, boolean isConditional, Set<String> allowedAccessTypes) {
        if (this.isActive()) {
            acls.getProjects().add(this.getName());
            if (!this.policyEvaluators.isEmpty()) {
                GdsProjectAccessRequest projectRequest = new GdsProjectAccessRequest(this.getId(), this.gdsServiceDef, request);
                for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                    policyEvaluator.getResourceACLs(projectRequest, acls, isConditional, allowedAccessTypes, RangerPolicyResourceMatcher.MatchType.SELF, null);
                }
            }
        }
    }

    public boolean hasReference(Set<String> users, Set<String> groups, Set<String> roles) {
        RangerPolicyEvaluator policyEvaluator;
        boolean ret = false;
        Iterator<RangerPolicyEvaluator> iterator = this.policyEvaluators.iterator();
        while (iterator.hasNext() && !(ret = (policyEvaluator = iterator.next()).hasReference(users, groups, roles))) {
        }
        return ret;
    }

    public static class GdsProjectEvalOrderComparator
    implements Comparator<GdsProjectEvaluator> {
        @Override
        public int compare(GdsProjectEvaluator me, GdsProjectEvaluator other) {
            int ret = 0;
            if (me != null && other != null) {
                ret = me.getName().compareTo(other.getName());
                if (ret == 0) {
                    ret = me.getId().compareTo(other.getId());
                }
            } else if (me != null) {
                ret = -1;
            } else if (other != null) {
                ret = 1;
            }
            return ret;
        }
    }

    public static class RangerProjectResource
    extends RangerAccessResourceImpl {
        public RangerProjectResource(Long projectd, RangerServiceDef gdsServiceDef, String ownerUser) {
            super.setValue("project-id", projectd.toString());
            super.setServiceDef(gdsServiceDef);
            super.setOwnerUser(ownerUser);
        }
    }

    private static class GdsProjectAccessRequest
    extends RangerAccessRequestImpl {
        public GdsProjectAccessRequest(Long projectId, RangerServiceDef gdsServiceDef, RangerAccessRequest request) {
            super.setResource(new RangerProjectResource(projectId, gdsServiceDef, request.getResource().getOwnerUser()));
            super.setUser(request.getUser());
            super.setUserGroups(request.getUserGroups());
            super.setUserRoles(request.getUserRoles());
            super.setAction(request.getAction());
            super.setAccessType(request.getAccessType());
            super.setAccessTime(request.getAccessTime());
            super.setRequestData(request.getRequestData());
            super.setContext(request.getContext());
            super.setClientType(request.getClientType());
            super.setClientIPAddress(request.getClientIPAddress());
            super.setRemoteIPAddress(request.getRemoteIPAddress());
            super.setForwardedAddresses(request.getForwardedAddresses());
            super.setSessionId(request.getSessionId());
            super.setResourceMatchingScope(request.getResourceMatchingScope());
        }

        public RangerAccessResult createAccessResult() {
            return new RangerAccessResult(0, "_gds", this.getResource().getServiceDef(), this);
        }
    }
}

