/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.policyengine.gds.GdsDataShareEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsDatasetEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsDipEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsDshidEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsProjectEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsSharedResourceEvaluator;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerResourceEvaluatorsRetriever;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsPolicyEngine {
    private static final Logger LOG = LoggerFactory.getLogger(GdsPolicyEngine.class);
    public static final String GDS_SERVICE_NAME = "_gds";
    public static final String RESOURCE_NAME_DATASET_ID = "dataset-id";
    public static final String RESOURCE_NAME_PROJECT_ID = "project-id";
    private final ServiceGdsInfo gdsInfo;
    private final RangerServiceDefHelper serviceDefHelper;
    private final Set<String> allAccessTypes;
    private final Map<Long, GdsProjectEvaluator> projects = new HashMap<Long, GdsProjectEvaluator>();
    private final Map<Long, GdsDatasetEvaluator> datasets = new HashMap<Long, GdsDatasetEvaluator>();
    private final Map<Long, GdsDataShareEvaluator> dataShares = new HashMap<Long, GdsDataShareEvaluator>();
    private final Map<String, GdsZoneResources> zoneResources = new HashMap<String, GdsZoneResources>();

    public GdsPolicyEngine(ServiceGdsInfo gdsInfo, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        LOG.debug("==> RangerGdsPolicyEngine()");
        this.gdsInfo = gdsInfo;
        this.serviceDefHelper = serviceDefHelper;
        this.allAccessTypes = serviceDefHelper.getAllAccessTypes();
        this.init(serviceDefHelper, pluginContext);
        LOG.debug("<== RangerGdsPolicyEngine()");
    }

    public ServiceGdsInfo getGdsInfo() {
        return this.gdsInfo;
    }

    public GdsAccessResult evaluate(RangerAccessRequest request) {
        GdsAccessResult ret;
        LOG.debug("==> RangerGdsPolicyEngine.evaluate({})", (Object)request);
        if (!this.datasets.isEmpty()) {
            ret = new GdsAccessResult();
            this.evaluate(request, 0, ret);
            if (ret.getIsAllowed()) {
                this.evaluate(request, 1, ret);
            }
            if (this.serviceDefHelper.isRowFilterSupported(request.getResource().getKeys())) {
                boolean isAccessAllowed = ret.getIsAllowed();
                this.evaluate(request, 2, ret);
                if (!isAccessAllowed) {
                    ret.setIsAllowed(false);
                }
            }
        } else {
            ret = null;
        }
        LOG.debug("<== RangerGdsPolicyEngine.evaluate({}): ret={}", (Object)request, (Object)ret);
        return ret == null || CollectionUtils.isEmpty(ret.getDatasets()) ? null : ret;
    }

    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        RangerResourceACLs ret = new RangerResourceACLs();
        this.getDataShareResources(request, 0).keySet().forEach(e -> e.getResourceACLs(request, ret));
        ret.finalizeAcls();
        return ret;
    }

    public Set<Long> getDatasetsSharedWith(Set<String> users, Set<String> groups, Set<String> roles) {
        HashSet<Long> ret = new HashSet<Long>();
        for (GdsDatasetEvaluator dataset : this.datasets.values()) {
            if (!dataset.hasReference(users, groups, roles)) continue;
            ret.add(dataset.getId());
        }
        return ret;
    }

    public Set<Long> getProjectsSharedWith(Set<String> users, Set<String> groups, Set<String> roles) {
        HashSet<Long> ret = new HashSet<Long>();
        for (GdsProjectEvaluator project : this.projects.values()) {
            if (!project.hasReference(users, groups, roles)) continue;
            ret.add(project.getId());
        }
        return ret;
    }

    public long getDatasetId(String datasetName) {
        GdsDatasetEvaluator evaluator = this.getDatasetEvaluator(datasetName);
        return evaluator == null ? -1L : evaluator.getId();
    }

    public long getProjectId(String projectName) {
        GdsProjectEvaluator evaluator = this.getProjectEvaluator(projectName);
        return evaluator == null ? -1L : evaluator.getId();
    }

    public String getDatasetName(Long id) {
        GdsDatasetEvaluator evaluator = this.datasets.get(id);
        return evaluator == null ? null : evaluator.getName();
    }

    public String getProjectName(Long id) {
        GdsProjectEvaluator evaluator = this.projects.get(id);
        return evaluator == null ? null : evaluator.getName();
    }

    public Iterator<GdsSharedResourceEvaluator> getDatasetResources(long datasetId) {
        TreeSet<GdsDataShareEvaluator> dshEvaluators = new TreeSet<GdsDataShareEvaluator>(GdsDataShareEvaluator.EVAL_ORDER_COMPARATOR);
        this.collectDataSharesForDataset(datasetId, dshEvaluators);
        return new SharedResourceIter(dshEvaluators);
    }

    public Iterator<GdsSharedResourceEvaluator> getProjectResources(long projectId) {
        TreeSet<GdsDataShareEvaluator> dshEvaluators = new TreeSet<GdsDataShareEvaluator>(GdsDataShareEvaluator.EVAL_ORDER_COMPARATOR);
        this.collectDataSharesForProject(projectId, dshEvaluators);
        return new SharedResourceIter(dshEvaluators);
    }

    public Iterator<GdsSharedResourceEvaluator> getDataShareResources(long dataShareId) {
        GdsDataShareEvaluator dshEvaluator = this.dataShares.get(dataShareId);
        Set<GdsDataShareEvaluator> dshEvaluators = dshEvaluator == null ? Collections.emptySet() : Collections.singleton(dshEvaluator);
        return new SharedResourceIter(dshEvaluators);
    }

    public Iterator<GdsSharedResourceEvaluator> getResources(List<Long> projectIds, List<Long> datasetIds, List<Long> dataShareIds) {
        TreeSet<GdsDataShareEvaluator> dshEvaluators = new TreeSet<GdsDataShareEvaluator>(GdsDataShareEvaluator.EVAL_ORDER_COMPARATOR);
        this.collectDataShares(projectIds, datasetIds, dataShareIds, dshEvaluators);
        return new SharedResourceIter(dshEvaluators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(RangerAccessRequest request, int policyType, GdsAccessResult result) {
        LOG.debug("==> RangerGdsPolicyEngine.evaluate({}, {}, {})", new Object[]{request, policyType, result});
        boolean isAnyAccess = request.isAccessTypeAny();
        try {
            Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> dshResources;
            if (isAnyAccess) {
                RangerAccessRequestUtil.setAllRequestedAccessTypes(request.getContext(), this.allAccessTypes);
                RangerAccessRequestUtil.setIsAnyAccessInContext(request.getContext(), Boolean.TRUE);
            }
            if (!(dshResources = this.getDataShareResources(request, policyType)).isEmpty()) {
                TreeMap<GdsDatasetEvaluator, Set<GdsDataShareEvaluator>> datasetsToEval = new TreeMap<GdsDatasetEvaluator, Set<GdsDataShareEvaluator>>(GdsDatasetEvaluator.EVAL_ORDER_COMPARATOR);
                dshResources.keySet().forEach(e -> e.collectDatasets(request, datasetsToEval));
                if (!datasetsToEval.isEmpty()) {
                    TreeSet<GdsProjectEvaluator> projectsToEval = new TreeSet<GdsProjectEvaluator>(GdsProjectEvaluator.EVAL_ORDER_COMPARATOR);
                    this.evaluateDatasetPolicies(datasetsToEval.keySet(), request, result, projectsToEval);
                    this.evaluateProjectPolicies(projectsToEval, request, result);
                    if (result.getIsAllowed() && (policyType == 1 || policyType == 2)) {
                        TreeSet<GdsDatasetEvaluator> datasets = new TreeSet<GdsDatasetEvaluator>(GdsDatasetEvaluator.EVAL_ORDER_COMPARATOR);
                        if (result.getAllowedByDatasets() != null) {
                            datasetsToEval.keySet().stream().filter(dataset -> result.getAllowedByDatasets().contains(dataset.getName())).forEach(datasets::add);
                        }
                        if (result.getAllowedByProjects() != null) {
                            datasetsToEval.keySet().stream().filter(dataset -> dataset.isInAnyProject(result.getAllowedByProjects())).forEach(datasets::add);
                        }
                        datasetsToEval.keySet().retainAll(datasets);
                        if (policyType == 1) {
                            this.setDataMask(request, result, datasetsToEval, dshResources);
                        } else if (policyType == 2) {
                            this.setRowFilters(request, result, datasetsToEval, dshResources);
                        }
                    }
                }
            }
        }
        finally {
            if (isAnyAccess) {
                RangerAccessRequestUtil.setAllRequestedAccessTypes(request.getContext(), null);
                RangerAccessRequestUtil.setIsAnyAccessInContext(request.getContext(), Boolean.FALSE);
            }
        }
        LOG.debug("<== RangerGdsPolicyEngine.evaluate({}, {}, {})", new Object[]{request, policyType, result});
    }

    private void setDataMask(RangerAccessRequest request, GdsAccessResult result, Map<GdsDatasetEvaluator, Set<GdsDataShareEvaluator>> datasetsToEval, Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> dshResources) {
        LOG.debug("==> RangerGdsPolicyEngine.setDataMask(request={}, result={}, datasetsToEval={}, dshResources={})", new Object[]{request, result, datasetsToEval, dshResources});
        String leafResource = Objects.toString(request.getResource().getValue(request.getResource().getLeafName()));
        RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo = null;
        for (Set<GdsDataShareEvaluator> dataShares : datasetsToEval.values()) {
            for (GdsDataShareEvaluator dataShare : dataShares) {
                RangerPolicy.RangerPolicyItemDataMaskInfo dshMask = null;
                for (GdsSharedResourceEvaluator resource : dshResources.get(dataShare)) {
                    RangerPolicy.RangerPolicyItemDataMaskInfo resourceMask = resource.getDataMask(leafResource);
                    if (resourceMask == null) {
                        dshMask = null;
                        break;
                    }
                    if (dshMask != null) continue;
                    dshMask = resourceMask;
                }
                if (dshMask == null) {
                    dataMaskInfo = null;
                    break;
                }
                if (dataMaskInfo != null) continue;
                dataMaskInfo = dshMask;
            }
            if (dataMaskInfo != null) continue;
            break;
        }
        if (dataMaskInfo == null) {
            result.setMaskType(null);
            result.setMaskedValue(null);
            result.setMaskCondition(null);
        } else {
            result.setMaskType(dataMaskInfo.getDataMaskType());
            result.setMaskedValue(dataMaskInfo.getValueExpr());
            result.setMaskCondition(dataMaskInfo.getConditionExpr());
        }
        LOG.debug("<== RangerGdsPolicyEngine.setDataMask(request={}, result={}, datasetsToEval={}, dshResources={})", new Object[]{request, result, datasetsToEval, dshResources});
    }

    private void setRowFilters(RangerAccessRequest request, GdsAccessResult result, Map<GdsDatasetEvaluator, Set<GdsDataShareEvaluator>> datasetsToEval, Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> dshResources) {
        LOG.debug("==> RangerGdsPolicyEngine.setRowFilters(request={}, result={}, datasetsToEval={}, dshResources={})", new Object[]{request, result, datasetsToEval, dshResources});
        ArrayList<String> rowFilters = new ArrayList<String>();
        for (Set<GdsDataShareEvaluator> dataShares : datasetsToEval.values()) {
            for (GdsDataShareEvaluator dataShare : dataShares) {
                for (GdsSharedResourceEvaluator resource : dshResources.get(dataShare)) {
                    RangerPolicy.RangerPolicyItemRowFilterInfo rowFilterInfo = resource.getRowFilter();
                    if (rowFilterInfo == null || StringUtils.isBlank((String)rowFilterInfo.getFilterExpr())) {
                        rowFilters = null;
                        break;
                    }
                    if (rowFilters.contains(rowFilterInfo.getFilterExpr())) continue;
                    rowFilters.add(rowFilterInfo.getFilterExpr());
                }
                if (rowFilters != null) continue;
                break;
            }
            if (rowFilters != null) continue;
            break;
        }
        result.setRowFilters(rowFilters);
        LOG.debug("<== RangerGdsPolicyEngine.setRowFilters(request={}, result={}, datasetsToEval={}, dshResources={})", new Object[]{request, result, datasetsToEval, dshResources});
    }

    private void init(RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        LOG.debug("==> RangerGdsPolicyEngine.init()");
        this.preprocess(serviceDefHelper);
        RangerServiceDef gdsServiceDef = this.gdsInfo.getGdsServiceDef();
        RangerPolicyEngineOptions options = new RangerPolicyEngineOptions(pluginContext.getConfig().getPolicyEngineOptions(), new RangerServiceDefHelper(gdsServiceDef, false));
        this.gdsInfo.getProjects().forEach(project -> this.projects.put(project.getId(), new GdsProjectEvaluator((ServiceGdsInfo.ProjectInfo)project, gdsServiceDef, options)));
        this.gdsInfo.getDatasets().forEach(dataset -> this.datasets.put(dataset.getId(), new GdsDatasetEvaluator((ServiceGdsInfo.DatasetInfo)dataset, gdsServiceDef, options)));
        this.gdsInfo.getDataShares().forEach(dataShare -> this.dataShares.put(dataShare.getId(), new GdsDataShareEvaluator((ServiceGdsInfo.DataShareInfo)dataShare, serviceDefHelper)));
        this.gdsInfo.getDshids().forEach(dshid -> {
            if (dshid.getStatus() == RangerGds.GdsShareStatus.ACTIVE) {
                GdsDataShareEvaluator dshEvaluator = this.dataShares.get(dshid.getDataShareId());
                if (dshEvaluator != null) {
                    GdsDatasetEvaluator datasetEvaluator = this.datasets.get(dshid.getDatasetId());
                    if (datasetEvaluator != null) {
                        GdsDshidEvaluator dshidEvaluator = new GdsDshidEvaluator((ServiceGdsInfo.DataShareInDatasetInfo)dshid, datasetEvaluator);
                        dshEvaluator.addDshidEvaluator(dshidEvaluator);
                    } else {
                        LOG.error("RangerGdsPolicyEngine(): invalid datasetId in dshid: {}. Ignored", dshid);
                    }
                } else {
                    LOG.error("RangerGdsPolicyEngine(): invalid dataShareId in dshid: {}. Ignored", dshid);
                }
            } else {
                LOG.error("RangerGdsPolicyEngine(): dshid is not active {}. Ignored", dshid);
            }
        });
        this.gdsInfo.getDips().forEach(dip -> {
            if (dip.getStatus() == RangerGds.GdsShareStatus.ACTIVE) {
                GdsDatasetEvaluator datasetEvaluator = this.datasets.get(dip.getDatasetId());
                if (datasetEvaluator != null) {
                    GdsProjectEvaluator projectEvaluator = this.projects.get(dip.getProjectId());
                    if (projectEvaluator != null) {
                        GdsDipEvaluator dipEvaluator = new GdsDipEvaluator((ServiceGdsInfo.DatasetInProjectInfo)dip, projectEvaluator);
                        datasetEvaluator.addDipEvaluator(dipEvaluator);
                    } else {
                        LOG.error("RangerGdsPolicyEngine(): invalid projectId in dip: {}. Ignored", dip);
                    }
                } else {
                    LOG.error("RangerGdsPolicyEngine(): invalid datasetId in dip: {}. Ignored", dip);
                }
            } else {
                LOG.error("RangerGdsPolicyEngine(): dip is not active {}. Ignored", dip);
            }
        });
        this.dataShares.values().removeIf(evaluator -> CollectionUtils.isEmpty(evaluator.getDshidEvaluators()));
        HashMap<String, List> zoneResEvaluators = new HashMap<String, List>();
        this.gdsInfo.getResources().forEach(resource -> {
            GdsDataShareEvaluator dshEvaluator = this.dataShares.get(resource.getDataShareId());
            if (dshEvaluator != null) {
                GdsSharedResourceEvaluator evaluator = new GdsSharedResourceEvaluator((ServiceGdsInfo.SharedResourceInfo)resource, dshEvaluator.getDefaultAccessTypes(), serviceDefHelper, pluginContext);
                dshEvaluator.addResourceEvaluator(evaluator);
                zoneResEvaluators.computeIfAbsent(dshEvaluator.getZoneName(), k -> new ArrayList()).add(evaluator);
            }
        });
        zoneResEvaluators.forEach((zoneName, evaluators) -> this.zoneResources.put((String)zoneName, new GdsZoneResources((String)zoneName, (List<GdsSharedResourceEvaluator>)evaluators, serviceDefHelper, pluginContext)));
        LOG.debug("<== RangerGdsPolicyEngine.init()");
    }

    private void preprocess(RangerServiceDefHelper serviceDefHelper) {
        if (this.gdsInfo.getProjects() == null) {
            this.gdsInfo.setProjects(Collections.emptyList());
        }
        if (this.gdsInfo.getDatasets() == null) {
            this.gdsInfo.setDatasets(Collections.emptyList());
        }
        if (this.gdsInfo.getDataShares() == null) {
            this.gdsInfo.setDataShares(Collections.emptyList());
        } else {
            this.gdsInfo.getDataShares().stream().filter(dsh -> dsh.getZoneName() == null).forEach(dsh -> dsh.setZoneName(""));
        }
        if (this.gdsInfo.getResources() == null) {
            this.gdsInfo.setResources(Collections.emptyList());
        }
        if (this.gdsInfo.getDshids() == null) {
            this.gdsInfo.setDshids(Collections.emptyList());
        }
        if (this.gdsInfo.getDips() == null) {
            this.gdsInfo.setDips(Collections.emptyList());
        }
        RangerServiceDef gdsServiceDef = this.gdsInfo.getGdsServiceDef();
        for (RangerServiceDef.RangerAccessTypeDef gdsAccessTypeDef : gdsServiceDef.getAccessTypes()) {
            Collection<String> impliedGrants = serviceDefHelper.getImpliedAccessGrants().get(gdsAccessTypeDef.getName());
            if (impliedGrants == null) continue;
            gdsAccessTypeDef.getImpliedGrants().addAll(impliedGrants);
        }
        gdsServiceDef.getAccessTypes().addAll(serviceDefHelper.getServiceDef().getAccessTypes());
    }

    private Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> getDataShareResources(RangerAccessRequest request, int policyType) {
        Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> ret;
        LOG.debug("==> RangerGdsPolicyEngine.getDataShareResources({}, {})", (Object)request, (Object)policyType);
        if (!this.dataShares.isEmpty()) {
            Set<String> zoneNames = RangerAccessRequestUtil.getResourceZoneNamesFromContext(request.getContext());
            if (zoneNames == null || zoneNames.isEmpty()) {
                zoneNames = Collections.singleton("");
            } else if (zoneNames.size() > 1 && !request.isAccessTypeAny()) {
                LOG.warn("RangerGdsPolicyEngine.getDataShareResources(): resource matches multiple zones and accessType is not ANY - ignored. resource={}, zones={}", (Object)request.getResource(), zoneNames);
                zoneNames = Collections.emptySet();
            }
            ret = new TreeMap(GdsDataShareEvaluator.EVAL_ORDER_COMPARATOR);
            zoneNames.stream().map(this.zoneResources::get).filter(Objects::nonNull).forEach(zr -> zr.collectDataShareResources(request, policyType, ret));
        } else {
            ret = Collections.emptyMap();
        }
        LOG.debug("<== RangerGdsPolicyEngine.getDataShareResources({}, {}): {}", new Object[]{request, policyType, ret});
        return ret;
    }

    private void evaluateDatasetPolicies(Set<GdsDatasetEvaluator> datasets, RangerAccessRequest request, GdsAccessResult result, Set<GdsProjectEvaluator> projectsToEval) {
        datasets.forEach(e -> e.evaluate(request, result, projectsToEval));
    }

    private void evaluateProjectPolicies(Set<GdsProjectEvaluator> projects, RangerAccessRequest request, GdsAccessResult result) {
        projects.forEach(e -> e.evaluate(request, result));
    }

    private GdsDatasetEvaluator getDatasetEvaluator(String dsName) {
        return this.datasets.values().stream().filter(e -> StringUtils.equals((String)e.getName(), (String)dsName)).findFirst().orElse(null);
    }

    private GdsProjectEvaluator getProjectEvaluator(String projectName) {
        return this.projects.values().stream().filter(e -> StringUtils.equals((String)e.getName(), (String)projectName)).findFirst().orElse(null);
    }

    private void collectDataSharesForDataset(Long datasetId, Set<GdsDataShareEvaluator> evaluators) {
        this.dataShares.values().stream().filter(e -> e.isInDataset(datasetId)).forEach(evaluators::add);
    }

    private void collectDataSharesForProject(Long projectId, Set<GdsDataShareEvaluator> evaluators) {
        this.dataShares.values().stream().filter(e -> e.isInProject(projectId)).forEach(evaluators::add);
    }

    private void collectDataShares(List<Long> projectIds, List<Long> datasetIds, List<Long> dataShareIds, Set<GdsDataShareEvaluator> evaluators) {
        if (projectIds != null) {
            projectIds.forEach(projectId -> this.collectDataSharesForProject((Long)projectId, evaluators));
        }
        if (datasetIds != null) {
            datasetIds.forEach(datasetId -> this.collectDataSharesForDataset((Long)datasetId, evaluators));
        }
        if (dataShareIds != null) {
            dataShareIds.stream().map(this.dataShares::get).filter(Objects::nonNull).forEach(evaluators::add);
        }
    }

    private Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> createRowFilterTries(List<GdsSharedResourceEvaluator> evaluators, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> ret;
        if (!serviceDefHelper.isRowFilterSupported() || evaluators.isEmpty()) {
            ret = Collections.emptyMap();
        } else {
            List rowFilterEvaluators = evaluators.stream().map(e -> e.createRowFilterEvaluator(serviceDefHelper, pluginContext)).filter(Objects::nonNull).collect(Collectors.toList());
            if (rowFilterEvaluators.isEmpty()) {
                ret = Collections.emptyMap();
            } else {
                ret = new HashMap<String, RangerResourceTrie<GdsSharedResourceEvaluator>>();
                for (RangerServiceDef.RangerResourceDef resourceDef : serviceDefHelper.getServiceDef().getRowFilterDef().getResources()) {
                    ret.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, rowFilterEvaluators, true, pluginContext));
                }
            }
        }
        return ret;
    }

    private class GdsZoneResources {
        private final String zoneName;
        private final Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> accessTries;
        private final Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> dataMaskTries;
        private final Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> rowFilterTries;

        public GdsZoneResources(String zoneName, List<GdsSharedResourceEvaluator> evaluators, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
            this.zoneName = zoneName;
            this.accessTries = this.createAccessTries(evaluators, serviceDefHelper, pluginContext);
            this.dataMaskTries = this.createDataMaskTries(evaluators, serviceDefHelper, pluginContext);
            this.rowFilterTries = GdsPolicyEngine.this.createRowFilterTries(evaluators, serviceDefHelper, pluginContext);
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void collectDataShareResources(RangerAccessRequest request, int policyType, Map<GdsDataShareEvaluator, Set<GdsSharedResourceEvaluator>> dshResources) {
            Map<String, RangerResourceTrie<Object>> tries = policyType == 1 ? this.dataMaskTries : (policyType == 2 ? this.rowFilterTries : this.accessTries);
            Collection<GdsSharedResourceEvaluator> resources = RangerResourceEvaluatorsRetriever.getEvaluators(tries, request.getResource().getAsMap(), request.getResourceElementMatchingScopes());
            if (resources != null) {
                for (GdsSharedResourceEvaluator resource : resources) {
                    GdsDataShareEvaluator dataShare;
                    if (!resource.isAllowed(request) || (dataShare = (GdsDataShareEvaluator)GdsPolicyEngine.this.dataShares.get(resource.getDataShareId())) == null) continue;
                    dshResources.computeIfAbsent(dataShare, l -> new TreeSet<GdsSharedResourceEvaluator>(GdsSharedResourceEvaluator.EVAL_ORDER_COMPARATOR)).add(resource);
                }
            }
        }

        private Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> createAccessTries(List<GdsSharedResourceEvaluator> evaluators, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
            HashMap<String, RangerResourceTrie<GdsSharedResourceEvaluator>> ret = new HashMap<String, RangerResourceTrie<GdsSharedResourceEvaluator>>();
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDefHelper.getServiceDef().getResources()) {
                ret.put(resourceDef.getName(), new RangerResourceTrie<GdsSharedResourceEvaluator>(resourceDef, evaluators, true, pluginContext));
            }
            return ret;
        }

        private Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> createDataMaskTries(List<GdsSharedResourceEvaluator> evaluators, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
            Map<String, RangerResourceTrie<GdsSharedResourceEvaluator>> ret;
            if (!serviceDefHelper.isDataMaskSupported() || evaluators.isEmpty()) {
                ret = Collections.emptyMap();
            } else {
                List dataMaskEvaluators = evaluators.stream().map(e -> e.createDataMaskEvaluator(serviceDefHelper)).filter(Objects::nonNull).collect(Collectors.toList());
                if (dataMaskEvaluators.isEmpty()) {
                    ret = Collections.emptyMap();
                } else {
                    ret = new HashMap<String, RangerResourceTrie<GdsSharedResourceEvaluator>>();
                    for (RangerServiceDef.RangerResourceDef resourceDef : serviceDefHelper.getServiceDef().getDataMaskDef().getResources()) {
                        ret.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, dataMaskEvaluators, true, pluginContext));
                    }
                }
            }
            return ret;
        }
    }

    static class SharedResourceIter
    implements Iterator<GdsSharedResourceEvaluator> {
        private final Iterator<GdsDataShareEvaluator> dataShareIter;
        private Iterator<GdsSharedResourceEvaluator> sharedResourceIter = Collections.emptyIterator();
        private GdsSharedResourceEvaluator nextResource;

        SharedResourceIter(Set<GdsDataShareEvaluator> evaluators) {
            this.dataShareIter = evaluators == null ? Collections.emptyIterator() : evaluators.iterator();
            this.setNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public GdsSharedResourceEvaluator next() {
            GdsSharedResourceEvaluator ret = this.nextResource;
            if (ret != null) {
                this.setNext();
            }
            return ret;
        }

        private void setNext() {
            if (!this.sharedResourceIter.hasNext()) {
                while (this.dataShareIter.hasNext()) {
                    GdsDataShareEvaluator dataShareEvaluator = this.dataShareIter.next();
                    this.sharedResourceIter = dataShareEvaluator.getResourceEvaluators().iterator();
                    if (!this.sharedResourceIter.hasNext()) continue;
                    break;
                }
            }
            this.nextResource = this.sharedResourceIter.hasNext() ? this.sharedResourceIter.next() : null;
        }
    }
}

