/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.policyengine.gds.GdsDipEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsProjectEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsDatasetEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsDatasetEvaluator.class);
    public static final GdsDatasetEvalOrderComparator EVAL_ORDER_COMPARATOR = new GdsDatasetEvalOrderComparator();
    private final ServiceGdsInfo.DatasetInfo dataset;
    private final RangerServiceDef gdsServiceDef;
    private final String name;
    private final RangerValidityScheduleEvaluator scheduleEvaluator;
    private final List<GdsDipEvaluator> dipEvaluators = new ArrayList<GdsDipEvaluator>();
    private final List<RangerPolicyEvaluator> policyEvaluators;

    public GdsDatasetEvaluator(ServiceGdsInfo.DatasetInfo dataset, RangerServiceDef gdsServiceDef, RangerPolicyEngineOptions options) {
        LOG.debug("==> GdsDatasetEvaluator()");
        this.dataset = dataset;
        this.gdsServiceDef = gdsServiceDef;
        this.name = StringUtils.isBlank((String)dataset.getName()) ? "" : dataset.getName();
        this.scheduleEvaluator = dataset.getValiditySchedule() != null ? new RangerValidityScheduleEvaluator(dataset.getValiditySchedule()) : null;
        if (dataset.getPolicies() != null) {
            this.policyEvaluators = new ArrayList<RangerPolicyEvaluator>(dataset.getPolicies().size());
            for (RangerPolicy policy : dataset.getPolicies()) {
                RangerOptimizedPolicyEvaluator evaluator = new RangerOptimizedPolicyEvaluator();
                evaluator.init(policy, gdsServiceDef, options);
                this.policyEvaluators.add(evaluator);
            }
        } else {
            this.policyEvaluators = Collections.emptyList();
        }
        LOG.debug("<== GdsDatasetEvaluator()");
    }

    public Long getId() {
        return this.dataset.getId();
    }

    public String getName() {
        return this.name;
    }

    public boolean isInProject(Long projectId) {
        return this.dipEvaluators.stream().anyMatch(e -> e.getProjectId().equals(projectId) && e.isActive());
    }

    public boolean isInAnyProject(Set<String> projectNames) {
        return this.dipEvaluators.stream().anyMatch(e -> projectNames.contains(e.getProjectEvaluator().getName()) && e.isActive());
    }

    public boolean isActive() {
        return this.scheduleEvaluator == null || this.scheduleEvaluator.isApplicable(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(RangerAccessRequest request, GdsAccessResult result, Collection<GdsProjectEvaluator> projectsToEval) {
        LOG.debug("==> GdsDatasetEvaluator.evaluate({}, {}, {})", new Object[]{request, result, projectsToEval});
        if (this.isActive()) {
            result.addDataset(this.getName());
            if (!this.policyEvaluators.isEmpty()) {
                GdsDatasetAccessRequest datasetRequest = new GdsDatasetAccessRequest(this.getId(), this.gdsServiceDef, request);
                RangerAccessResult datasetResult = datasetRequest.createAccessResult();
                try {
                    RangerAccessRequestUtil.setAccessTypeResults(datasetRequest.getContext(), null);
                    RangerAccessRequestUtil.setAccessTypeACLResults(datasetRequest.getContext(), null);
                    this.policyEvaluators.forEach(e -> e.evaluate(datasetRequest, datasetResult));
                }
                finally {
                    RangerAccessRequestUtil.setAccessTypeResults(datasetRequest.getContext(), null);
                    RangerAccessRequestUtil.setAccessTypeACLResults(datasetRequest.getContext(), null);
                }
                if (datasetResult.getIsAllowed()) {
                    result.addAllowedByDataset(this.getName());
                }
                if (!result.getIsAllowed() && datasetResult.getIsAllowed()) {
                    result.setIsAllowed(true);
                    result.setPolicyId(datasetResult.getPolicyId());
                    result.setPolicyVersion(datasetResult.getPolicyVersion());
                }
                if (!result.getIsAudited()) {
                    result.setIsAudited(datasetResult.getIsAudited());
                }
            }
            this.dipEvaluators.stream().filter(e -> e.isAllowed(request) && e.getProjectEvaluator().isActive()).forEach(dip -> projectsToEval.add(dip.getProjectEvaluator()));
        }
        LOG.debug("<== GdsDatasetEvaluator.evaluate({}, {}, {})", new Object[]{request, result, projectsToEval});
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls, boolean isConditional, Set<String> allowedAccessTypes) {
        if (this.isActive()) {
            acls.getDatasets().add(this.getName());
            if (!this.policyEvaluators.isEmpty()) {
                GdsDatasetAccessRequest datasetRequest = new GdsDatasetAccessRequest(this.getId(), this.gdsServiceDef, request);
                for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                    policyEvaluator.getResourceACLs(datasetRequest, acls, isConditional, allowedAccessTypes, RangerPolicyResourceMatcher.MatchType.SELF, null);
                }
            }
            for (GdsDipEvaluator dipEvaluator : this.dipEvaluators) {
                dipEvaluator.getResourceACLs(request, acls, isConditional, allowedAccessTypes);
            }
        }
    }

    public boolean hasReference(Set<String> users, Set<String> groups, Set<String> roles) {
        RangerPolicyEvaluator policyEvaluator;
        boolean ret = false;
        Iterator<RangerPolicyEvaluator> iterator = this.policyEvaluators.iterator();
        while (iterator.hasNext() && !(ret = (policyEvaluator = iterator.next()).hasReference(users, groups, roles))) {
        }
        return ret;
    }

    void addDipEvaluator(GdsDipEvaluator dipEvaluator) {
        this.dipEvaluators.add(dipEvaluator);
    }

    public static class GdsDatasetEvalOrderComparator
    implements Comparator<GdsDatasetEvaluator> {
        @Override
        public int compare(GdsDatasetEvaluator me, GdsDatasetEvaluator other) {
            int ret = 0;
            if (me != null && other != null) {
                ret = me.getName().compareTo(other.getName());
                if (ret == 0) {
                    ret = me.getId().compareTo(other.getId());
                }
            } else if (me != null) {
                ret = -1;
            } else if (other != null) {
                ret = 1;
            }
            return ret;
        }
    }

    public static class RangerDatasetResource
    extends RangerAccessResourceImpl {
        public RangerDatasetResource(Long datasetd, RangerServiceDef gdsServiceDef, String ownerUser) {
            super.setValue("dataset-id", datasetd.toString());
            super.setServiceDef(gdsServiceDef);
            super.setOwnerUser(ownerUser);
        }
    }

    private static class GdsDatasetAccessRequest
    extends RangerAccessRequestImpl {
        public GdsDatasetAccessRequest(Long datasetId, RangerServiceDef gdsServiceDef, RangerAccessRequest request) {
            super.setResource(new RangerDatasetResource(datasetId, gdsServiceDef, request.getResource().getOwnerUser()));
            super.setUser(request.getUser());
            super.setUserGroups(request.getUserGroups());
            super.setUserRoles(request.getUserRoles());
            super.setAction(request.getAction());
            super.setAccessType(request.getAccessType());
            super.setAccessTime(request.getAccessTime());
            super.setRequestData(request.getRequestData());
            super.setContext(request.getContext());
            super.setClientType(request.getClientType());
            super.setClientIPAddress(request.getClientIPAddress());
            super.setRemoteIPAddress(request.getRemoteIPAddress());
            super.setForwardedAddresses(request.getForwardedAddresses());
            super.setSessionId(request.getSessionId());
            super.setResourceMatchingScope(request.getResourceMatchingScope());
        }

        public RangerAccessResult createAccessResult() {
            return new RangerAccessResult(0, "_gds", this.getResource().getServiceDef(), this);
        }
    }
}

