/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;

public class RangerResourceACLs {
    private final Map<String, Map<String, AccessResult>> userACLs = new HashMap<String, Map<String, AccessResult>>();
    private final Map<String, Map<String, AccessResult>> groupACLs = new HashMap<String, Map<String, AccessResult>>();
    private final Map<String, Map<String, AccessResult>> roleACLs = new HashMap<String, Map<String, AccessResult>>();
    private final List<RowFilterResult> rowFilters = new ArrayList<RowFilterResult>();
    private final List<DataMaskResult> dataMasks = new ArrayList<DataMaskResult>();
    private final Set<String> datasets = new HashSet<String>();
    private final Set<String> projects = new HashSet<String>();

    public Map<String, Map<String, AccessResult>> getUserACLs() {
        return this.userACLs;
    }

    public Map<String, Map<String, AccessResult>> getGroupACLs() {
        return this.groupACLs;
    }

    public Map<String, Map<String, AccessResult>> getRoleACLs() {
        return this.roleACLs;
    }

    public List<RowFilterResult> getRowFilters() {
        return this.rowFilters;
    }

    public List<DataMaskResult> getDataMasks() {
        return this.dataMasks;
    }

    public Set<String> getDatasets() {
        return this.datasets;
    }

    public Set<String> getProjects() {
        return this.projects;
    }

    public void finalizeAcls() {
        Map<String, AccessResult> publicGroupAccessInfo = this.groupACLs.get("public");
        if (publicGroupAccessInfo != null) {
            for (Map.Entry<String, AccessResult> entry : publicGroupAccessInfo.entrySet()) {
                AccessResult savedAccessResult;
                Map<String, AccessResult> mapValue;
                String accessType = entry.getKey();
                AccessResult accessResult = entry.getValue();
                int access = accessResult.getResult();
                if (access != RangerPolicyEvaluator.ACCESS_DENIED && access != RangerPolicyEvaluator.ACCESS_ALLOWED) continue;
                for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.userACLs.entrySet()) {
                    mapValue = mapEntry.getValue();
                    savedAccessResult = mapValue.get(accessType);
                    if (savedAccessResult == null || savedAccessResult.getIsFinal()) continue;
                    mapValue.remove(accessType);
                }
                for (Map.Entry<String, Map<String, AccessResult>> mapEntry : this.groupACLs.entrySet()) {
                    if (StringUtils.equals((String)mapEntry.getKey(), (String)"public") || (savedAccessResult = (mapValue = mapEntry.getValue()).get(accessType)) == null || savedAccessResult.getIsFinal()) continue;
                    mapValue.remove(accessType);
                }
            }
        }
        this.finalizeAcls(this.userACLs);
        this.finalizeAcls(this.groupACLs);
        this.finalizeAcls(this.roleACLs);
    }

    public void setUserAccessInfo(String userName, String accessType, Integer access, RangerPolicy policy) {
        Map userAccessInfo = this.userACLs.computeIfAbsent(userName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)userAccessInfo.get(accessType);
        if (existingResult == null) {
            userAccessInfo.put(accessType, new AccessResult(access, policy));
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(access)) {
            existingResult.setResult(access);
            existingResult.setPolicy(policy);
        }
    }

    public void setGroupAccessInfo(String groupName, String accessType, Integer access, RangerPolicy policy) {
        Map groupAccessInfo = this.groupACLs.computeIfAbsent(groupName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)groupAccessInfo.get(accessType);
        if (existingResult == null) {
            groupAccessInfo.put(accessType, new AccessResult(access, policy));
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(access)) {
            existingResult.setResult(access);
            existingResult.setPolicy(policy);
        }
    }

    public void setRoleAccessInfo(String roleName, String accessType, Integer access, RangerPolicy policy) {
        Map roleAccessInfo = this.roleACLs.computeIfAbsent(roleName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)roleAccessInfo.get(accessType);
        if (existingResult == null) {
            roleAccessInfo.put(accessType, new AccessResult(access, policy));
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(access)) {
            existingResult.setResult(access);
            existingResult.setPolicy(policy);
        }
    }

    public void setUserAccessInfo(String userName, String accessType, AccessResult accessResult) {
        Map userAccessInfo = this.userACLs.computeIfAbsent(userName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)userAccessInfo.get(accessType);
        if (existingResult == null) {
            userAccessInfo.put(accessType, accessResult);
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(accessResult.getResult())) {
            existingResult.setResult(accessResult.getResult());
            existingResult.setPolicy(accessResult.getPolicy());
        }
    }

    public void setGroupAccessInfo(String groupName, String accessType, AccessResult accessResult) {
        Map groupAccessInfo = this.groupACLs.computeIfAbsent(groupName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)groupAccessInfo.get(accessType);
        if (existingResult == null) {
            groupAccessInfo.put(accessType, accessResult);
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(accessResult.getResult())) {
            existingResult.setResult(accessResult.getResult());
            existingResult.setPolicy(accessResult.getPolicy());
        }
    }

    public void setRoleAccessInfo(String roleName, String accessType, AccessResult accessResult) {
        Map roleAccessInfo = this.roleACLs.computeIfAbsent(roleName, k -> new HashMap());
        AccessResult existingResult = (AccessResult)roleAccessInfo.get(accessType);
        if (existingResult == null) {
            roleAccessInfo.put(accessType, accessResult);
        } else if (!RangerPolicyEvaluator.ACCESS_CONDITIONAL.equals(accessResult.getResult())) {
            existingResult.setResult(accessResult.getResult());
            existingResult.setPolicy(accessResult.getPolicy());
        }
    }

    public int hashCode() {
        return Objects.hash(this.userACLs, this.groupACLs, this.roleACLs, this.rowFilters, this.dataMasks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RangerResourceACLs other = (RangerResourceACLs)obj;
        return Objects.equals(this.userACLs, other.userACLs) && Objects.equals(this.groupACLs, other.groupACLs) && Objects.equals(this.roleACLs, other.roleACLs) && Objects.equals(this.rowFilters, other.rowFilters) && Objects.equals(this.dataMasks, other.dataMasks) && Objects.equals(this.datasets, other.datasets) && Objects.equals(this.projects, other.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("UserACLs={");
        for (Map.Entry<String, Map<String, AccessResult>> entry : this.userACLs.entrySet()) {
            sb.append("user=").append(entry.getKey()).append(":");
            sb.append("permissions={");
            for (Map.Entry<String, AccessResult> permission : entry.getValue().entrySet()) {
                sb.append("{Permission=").append(permission.getKey()).append(", value=").append(permission.getValue()).append("},");
                sb.append("{RangerPolicyID=").append(permission.getValue().getPolicy() == null ? null : permission.getValue().getPolicy().getId()).append("},");
            }
            sb.append("},");
        }
        sb.append("}");
        sb.append(", GroupACLs={");
        for (Map.Entry<String, Map<String, AccessResult>> entry : this.groupACLs.entrySet()) {
            sb.append("group=").append(entry.getKey()).append(":");
            sb.append("permissions={");
            for (Map.Entry<String, AccessResult> permission : entry.getValue().entrySet()) {
                sb.append("{Permission=").append(permission.getKey()).append(", value=").append(permission.getValue()).append("}, ");
                sb.append("{RangerPolicy ID=").append(permission.getValue().getPolicy() == null ? null : permission.getValue().getPolicy().getId()).append("},");
            }
            sb.append("},");
        }
        sb.append("}");
        sb.append(", RoleACLs={");
        for (Map.Entry<String, Map<String, AccessResult>> entry : this.roleACLs.entrySet()) {
            sb.append("role=").append(entry.getKey()).append(":");
            sb.append("permissions={");
            for (Map.Entry<String, AccessResult> permission : entry.getValue().entrySet()) {
                sb.append("{Permission=").append(permission.getKey()).append(", value=").append(permission.getValue()).append("}, ");
                sb.append("{RangerPolicy ID=").append(permission.getValue().getPolicy() == null ? null : permission.getValue().getPolicy().getId()).append("},");
            }
            sb.append("},");
        }
        sb.append("}");
        sb.append("}");
        sb.append(", rowFilters=[");
        for (RowFilterResult rowFilter : this.rowFilters) {
            rowFilter.toString(sb);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", dataMasks=[");
        for (DataMaskResult dataMask : this.dataMasks) {
            dataMask.toString(sb);
            sb.append(" ");
        }
        sb.append("]");
        sb.append(", datasets=[");
        for (String dataset : this.datasets) {
            sb.append(dataset).append(" ");
        }
        sb.append("]");
        sb.append(", projects=[");
        for (String project : this.projects) {
            sb.append(project).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void finalizeAcls(Map<String, Map<String, AccessResult>> acls) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Map<String, AccessResult>> entry : acls.entrySet()) {
            if (entry.getValue().isEmpty()) {
                keysToRemove.add(entry.getKey());
                continue;
            }
            for (Map.Entry<String, AccessResult> permission : entry.getValue().entrySet()) {
                permission.getValue().setIsFinal(true);
            }
        }
        for (String keyToRemove : keysToRemove) {
            acls.remove(keyToRemove);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RowFilterResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<String> users;
        private final Set<String> groups;
        private final Set<String> roles;
        private final Set<String> accessTypes;
        private final RangerPolicy.RangerPolicyItemRowFilterInfo filterInfo;
        private boolean isConditional;

        public RowFilterResult(Set<String> users, Set<String> groups, Set<String> roles, Set<String> accessTypes, RangerPolicy.RangerPolicyItemRowFilterInfo filterInfo) {
            this.users = users;
            this.groups = groups;
            this.roles = roles;
            this.accessTypes = accessTypes;
            this.filterInfo = filterInfo;
        }

        public RowFilterResult(RowFilterResult that) {
            this.users = that.users;
            this.groups = that.groups;
            this.roles = that.roles;
            this.accessTypes = that.accessTypes;
            this.filterInfo = that.filterInfo;
            this.isConditional = that.isConditional;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Set<String> getAccessTypes() {
            return this.accessTypes;
        }

        public RangerPolicy.RangerPolicyItemRowFilterInfo getFilterInfo() {
            return this.filterInfo;
        }

        public boolean getIsConditional() {
            return this.isConditional;
        }

        public void setIsConditional(boolean isConditional) {
            this.isConditional = isConditional;
        }

        public int hashCode() {
            return Objects.hash(this.users, this.groups, this.roles, this.accessTypes, this.filterInfo, this.isConditional);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RowFilterResult that = (RowFilterResult)other;
            return Objects.equals(this.users, that.users) && Objects.equals(this.groups, that.groups) && Objects.equals(this.roles, that.roles) && Objects.equals(this.accessTypes, that.accessTypes) && Objects.equals(this.filterInfo, that.filterInfo) && this.isConditional == that.isConditional;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("{");
            if (this.users != null && !this.users.isEmpty()) {
                sb.append("users:[");
                for (String user : this.users) {
                    sb.append(user).append(' ');
                }
                sb.append("] ");
            }
            if (this.groups != null && !this.groups.isEmpty()) {
                sb.append("groups:[");
                for (String group : this.groups) {
                    sb.append(group).append(' ');
                }
                sb.append("] ");
            }
            if (this.roles != null && !this.roles.isEmpty()) {
                sb.append("roles:[");
                for (String role : this.roles) {
                    sb.append(role).append(' ');
                }
                sb.append("] ");
            }
            if (this.accessTypes != null && !this.accessTypes.isEmpty()) {
                sb.append("accessTypes:[");
                for (String accessType : this.accessTypes) {
                    sb.append(accessType).append(' ');
                }
                sb.append("] ");
            }
            sb.append("filterInfo=");
            this.filterInfo.toString(sb);
            sb.append(" isConditional=").append(this.isConditional);
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataMaskResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<String> users;
        private final Set<String> groups;
        private final Set<String> roles;
        private final Set<String> accessTypes;
        private final RangerPolicy.RangerPolicyItemDataMaskInfo maskInfo;
        private boolean isConditional;

        public DataMaskResult(Set<String> users, Set<String> groups, Set<String> roles, Set<String> accessTypes, RangerPolicy.RangerPolicyItemDataMaskInfo maskInfo) {
            this.users = users;
            this.groups = groups;
            this.roles = roles;
            this.accessTypes = accessTypes;
            this.maskInfo = maskInfo;
        }

        public DataMaskResult(DataMaskResult that) {
            this.users = that.users;
            this.groups = that.groups;
            this.roles = that.roles;
            this.accessTypes = that.accessTypes;
            this.maskInfo = that.maskInfo;
            this.isConditional = that.isConditional;
        }

        public Set<String> getUsers() {
            return this.users;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Set<String> getAccessTypes() {
            return this.accessTypes;
        }

        public RangerPolicy.RangerPolicyItemDataMaskInfo getMaskInfo() {
            return this.maskInfo;
        }

        public boolean getIsConditional() {
            return this.isConditional;
        }

        public void setIsConditional(boolean isConditional) {
            this.isConditional = isConditional;
        }

        public int hashCode() {
            return Objects.hash(this.users, this.groups, this.roles, this.accessTypes, this.maskInfo, this.isConditional);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DataMaskResult that = (DataMaskResult)other;
            return Objects.equals(this.users, that.users) && Objects.equals(this.groups, that.groups) && Objects.equals(this.roles, that.roles) && Objects.equals(this.accessTypes, that.accessTypes) && Objects.equals(this.maskInfo, that.maskInfo) && this.isConditional == that.isConditional;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("{");
            if (this.users != null && !this.users.isEmpty()) {
                sb.append("users:[");
                for (String user : this.users) {
                    sb.append(user).append(' ');
                }
                sb.append("] ");
            }
            if (this.groups != null && !this.groups.isEmpty()) {
                sb.append("groups:[");
                for (String group : this.groups) {
                    sb.append(group).append(' ');
                }
                sb.append("] ");
            }
            if (this.roles != null && !this.roles.isEmpty()) {
                sb.append("roles:[");
                for (String role : this.roles) {
                    sb.append(role).append(' ');
                }
                sb.append("] ");
            }
            if (this.accessTypes != null && !this.accessTypes.isEmpty()) {
                sb.append("accessTypes:[");
                for (String accessType : this.accessTypes) {
                    sb.append(accessType).append(' ');
                }
                sb.append("] ");
            }
            sb.append("maskInfo=");
            this.maskInfo.toString(sb);
            sb.append(" isConditional=").append(this.isConditional);
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AccessResult {
        private int result;
        private boolean isFinal;
        private RangerPolicy policy;

        public AccessResult() {
            this(-1, null);
        }

        public AccessResult(int result, RangerPolicy policy) {
            this(result, false, policy);
        }

        public AccessResult(int result, boolean isFinal, RangerPolicy policy) {
            this.setIsFinal(isFinal);
            this.setResult(result);
            this.setPolicy(policy);
        }

        public int getResult() {
            return this.result;
        }

        public void setResult(int result) {
            if (!this.isFinal) {
                this.result = result;
                if (this.result == RangerPolicyEvaluator.ACCESS_DENIED) {
                    this.isFinal = true;
                }
            }
        }

        public boolean getIsFinal() {
            return this.isFinal;
        }

        public void setIsFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public RangerPolicy getPolicy() {
            return this.policy;
        }

        public void setPolicy(RangerPolicy policy) {
            this.policy = policy;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof AccessResult) {
                AccessResult otherObject = (AccessResult)other;
                return this.result == otherObject.result && this.isFinal == otherObject.isFinal;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.result, this.isFinal);
        }

        public String toString() {
            if (this.result == RangerPolicyEvaluator.ACCESS_ALLOWED) {
                return "ALLOWED, final=" + this.isFinal;
            }
            if (this.result == RangerPolicyEvaluator.ACCESS_DENIED) {
                return "NOT_ALLOWED, final=" + this.isFinal;
            }
            return "CONDITIONAL_ALLOWED, final=" + this.isFinal;
        }
    }
}

