/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestProcessor;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerDefaultRequestProcessor;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyEngineImpl.class);
    private static final Logger PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Logger PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Logger PERF_POLICYENGINE_GET_ACLS_LOG = RangerPerfTracer.getPerfLogger("policyengine.getResourceACLs");
    private final PolicyEngine policyEngine;
    private final RangerAccessRequestProcessor requestProcessor;
    private final ServiceConfig serviceConfig;

    public RangerPolicyEngineImpl(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles) {
        boolean isDeltasSupported;
        RangerPluginConfig config;
        RangerPluginConfig rangerPluginConfig = config = pluginContext != null ? pluginContext.getConfig() : null;
        boolean isUseReadWriteLock = config != null ? (isDeltasSupported = config.getBoolean(pluginContext.getConfig().getPropertyPrefix() + ".supports.policy.deltas", false)) && config.getBoolean(pluginContext.getConfig().getPropertyPrefix() + ".supports.in.place.policy.updates", false) : false;
        this.policyEngine = new PolicyEngine(servicePolicies, pluginContext, roles, isUseReadWriteLock);
        this.serviceConfig = new ServiceConfig(servicePolicies.getServiceConfig());
        this.requestProcessor = new RangerDefaultRequestProcessor(this.policyEngine);
    }

    private RangerPolicyEngineImpl(PolicyEngine policyEngine, RangerPolicyEngineImpl other) {
        this.policyEngine = policyEngine;
        this.requestProcessor = new RangerDefaultRequestProcessor(policyEngine);
        this.serviceConfig = new ServiceConfig(other.serviceConfig);
    }

    public static RangerPolicyEngine getPolicyEngine(RangerPolicyEngineImpl other, ServicePolicies servicePolicies) {
        PolicyEngine policyEngine;
        RangerPolicyEngineImpl ret = null;
        if (other != null && servicePolicies != null && (policyEngine = other.policyEngine.cloneWithDelta(servicePolicies)) != null) {
            ret = policyEngine == other.policyEngine ? other : new RangerPolicyEngineImpl(policyEngine, other);
        }
        return ret;
    }

    public String toString() {
        return this.policyEngine.toString();
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (writeLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)writeLock);
            }
            this.policyEngine.setUseForwardedIPAddress(useForwardedIPAddress);
        }
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (writeLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)writeLock);
            }
            this.policyEngine.setTrustedProxyAddresses(trustedProxyAddresses);
        }
    }

    @Override
    public RangerServiceDef getServiceDef() {
        RangerServiceDef ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = this.policyEngine.getServiceDef();
        }
        return ret;
    }

    @Override
    public RangerServiceDefHelper getServiceDefHelper() {
        RangerServiceDefHelper ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = this.policyEngine.getServiceDefHelper();
        }
        return ret;
    }

    @Override
    public long getPolicyVersion() {
        long ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = this.policyEngine.getPolicyVersion();
        }
        return ret;
    }

    @Override
    public long getRoleVersion() {
        return this.policyEngine.getRoleVersion();
    }

    @Override
    public void setRoles(RangerRoles roles) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (writeLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)writeLock);
            }
            this.policyEngine.setRoles(roles);
        }
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        RangerAccessResult ret;
        LOG.debug("==> RangerPolicyEngineImpl.evaluatePolicies({}, policyType={})", (Object)request, (Object)policyType);
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.evaluatePolicies(requestHashCode=" + requestHashCode + ")");
            LOG.info("RangerPolicyEngineImpl.evaluatePolicies({}, {})", (Object)requestHashCode, (Object)request);
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            this.requestProcessor.preProcess(request);
            ret = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
            if (resultProcessor != null) {
                RangerPerfTracer perfAuditTracer = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                    String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
                    perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + requestHashCode + ")");
                }
                resultProcessor.processResult(ret);
                RangerPerfTracer.log(perfAuditTracer);
            }
        }
        RangerPerfTracer.log(perf);
        LOG.debug("<== RangerPolicyEngineImpl.evaluatePolicies({}, policyType={}): {}", new Object[]{request, policyType, ret});
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        LOG.debug("==> RangerPolicyEngineImpl.evaluatePolicies({}, policyType={})", requests, (Object)policyType);
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            if (requests != null) {
                for (RangerAccessRequest request : requests) {
                    this.requestProcessor.preProcess(request);
                    RangerAccessResult result = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
                    ret.add(result);
                }
            }
            if (resultProcessor != null) {
                resultProcessor.processResults(ret);
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluatePolicies({}, policyType={}): {}", new Object[]{requests, policyType, ret});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateAuditPolicies(RangerAccessResult result) {
        LOG.debug("==> RangerPolicyEngineImpl.evaluateAuditPolicies(result={})", (Object)result);
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
            RangerPolicyRepository policyRepository = this.policyEngine.getPolicyRepository();
            RangerAccessRequest request = result.getAccessRequest();
            boolean savedIsAuditedDetermined = result.getIsAuditedDetermined();
            boolean savedIsAudited = result.getIsAudited();
            result.setIsAudited(false);
            result.setIsAuditedDetermined(false);
            try {
                if (tagPolicyRepository != null) {
                    this.evaluateTagAuditPolicies(request, result, tagPolicyRepository);
                }
                if (!result.getIsAuditedDetermined() && policyRepository != null) {
                    this.evaluateResourceAuditPolicies(request, result, policyRepository);
                }
            }
            finally {
                if (!result.getIsAuditedDetermined()) {
                    result.setIsAudited(savedIsAudited);
                    result.setIsAuditedDetermined(savedIsAuditedDetermined);
                }
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluateAuditPolicies(result={})", (Object)result);
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        return this.getResourceACLs(request, null);
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request, Integer requestedPolicyType) {
        LOG.debug("==> RangerPolicyEngineImpl.getResourceACLs(request={}, policyType={})", (Object)request, (Object)requestedPolicyType);
        RangerResourceACLs ret = new RangerResourceACLs();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_GET_ACLS_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_GET_ACLS_LOG, "RangerPolicyEngine.getResourceACLs(requestHashCode=" + request.getResource().getAsString() + ")");
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            int[] policyTypes;
            int[] nArray;
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            this.requestProcessor.preProcess(request);
            String zoneName = RangerAccessRequestUtil.getResourceZoneNameFromContext(request.getContext());
            LOG.debug("zoneName:[{}]", (Object)zoneName);
            if (requestedPolicyType == null) {
                nArray = RangerPolicy.POLICY_TYPES;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = requestedPolicyType;
            }
            for (int policyType : policyTypes = nArray) {
                boolean requireExactMatch;
                boolean bl = requireExactMatch = policyType == 1 || policyType == 2;
                if (!this.policyEngine.getServiceDefHelper().isValidHierarchy(policyType, request.getResource().getKeys(), requireExactMatch)) continue;
                ArrayList<RangerPolicyEvaluator> allEvaluators = new ArrayList<RangerPolicyEvaluator>();
                HashMap<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap = new HashMap<Long, RangerPolicyResourceMatcher.MatchType>();
                HashSet<Long> policyIdForTemporalTags = new HashSet<Long>();
                this.getResourceACLEvaluatorsForZone(request, zoneName, policyType, allEvaluators, tagMatchTypeMap, policyIdForTemporalTags);
                allEvaluators.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
                if (CollectionUtils.isEmpty(allEvaluators)) continue;
                Integer policyPriority = null;
                for (RangerPolicyEvaluator evaluator : allEvaluators) {
                    if (policyPriority == null) {
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    if (policyPriority.intValue() != evaluator.getPolicyPriority()) {
                        if (policyType == 0) {
                            ret.finalizeAcls();
                        }
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    boolean isTemporalTagPolicy = policyIdForTemporalTags.contains(evaluator.getPolicyId());
                    RangerPolicyResourceMatcher.MatchType tagMatchType = (RangerPolicyResourceMatcher.MatchType)((Object)tagMatchTypeMap.get(evaluator.getPolicyId()));
                    if (tagMatchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR) {
                        tagMatchType = RangerPolicyResourceMatcher.MatchType.SELF;
                    }
                    evaluator.getResourceACLs(request, ret, isTemporalTagPolicy, null, tagMatchType, this.policyEngine);
                }
                ret.finalizeAcls();
            }
        }
        RangerPerfTracer.logAlways(perf);
        LOG.debug("<== RangerPolicyEngineImpl.getResourceACLs(request={}, policyType={}) : ret={}", new Object[]{request, requestedPolicyType, ret});
        return ret;
    }

    @Override
    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        Set<String> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = this.policyEngine.getPluginContext().getAuthContext().getRolesForUserAndGroups(user, groups);
        }
        return ret;
    }

    @Override
    public RangerRoles getRangerRoles() {
        return this.policyEngine.getPluginContext().getAuthContext().getRangerRolesUtil().getRoles();
    }

    @Override
    public RangerPluginContext getPluginContext() {
        return this.policyEngine.getPluginContext();
    }

    @Override
    public String getUniquelyMatchedZoneName(GrantRevokeRequest grantRevokeRequest) {
        String ret;
        LOG.debug("==> RangerPolicyEngineImpl.getUniquelyMatchedZoneName({})", (Object)grantRevokeRequest);
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = this.policyEngine.getUniquelyMatchedZoneName(grantRevokeRequest.getResource());
        }
        LOG.debug("<== RangerPolicyEngineImpl.getUniquelyMatchedZoneName({}) : {}", (Object)grantRevokeRequest, (Object)ret);
        return ret;
    }

    @Override
    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            ArrayList<RangerPolicy> oldPolicies;
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            ret = CollectionUtils.isNotEmpty(oldPolicies = this.policyEngine.getResourcePolicies(zoneName)) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getResourcePolicies() {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            RangerPolicyRepository policyRepository;
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            List<Object> oldPolicies = (policyRepository = this.policyEngine.getPolicyRepository()) == null ? Collections.emptyList() : policyRepository.getPolicies();
            ret = CollectionUtils.isNotEmpty(oldPolicies) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getTagPolicies() {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            RangerPolicyRepository tagPolicyRepository;
            if (readLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - {}", (Object)readLock);
            }
            List<Object> oldPolicies = (tagPolicyRepository = this.policyEngine.getTagPolicyRepository()) == null ? Collections.emptyList() : tagPolicyRepository.getPolicies();
            ret = CollectionUtils.isNotEmpty(oldPolicies) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        LOG.debug("==> RangerPolicyEngineImpl.getResourceAccessInfo({})", (Object)request);
        this.requestProcessor.preProcess(request);
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        Set<String> zoneNames = RangerAccessRequestUtil.getResourceZoneNamesFromContext(request.getContext());
        LOG.debug("zoneNames:[{}]", zoneNames);
        if (CollectionUtils.isEmpty(zoneNames)) {
            this.getResourceAccessInfoForZone(request, ret, null);
        } else {
            for (String zoneName : zoneNames) {
                this.getResourceAccessInfoForZone(request, ret, zoneName);
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.getResourceAccessInfo({}): {}", (Object)request, (Object)ret);
        return ret;
    }

    public void releaseResources(boolean isForced) {
        LOG.debug("==> RangerPolicyEngineImpl.releaseResources(isForced={})", (Object)isForced);
        PolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preCleanup(isForced);
        } else {
            LOG.debug("Cannot preCleanup policy-engine as it is null!");
        }
        LOG.debug("<== RangerPolicyEngineImpl.releaseResources(isForced={})", (Object)isForced);
    }

    public boolean isServiceAdmin(String userName) {
        boolean ret = this.serviceConfig.isServiceAdmin(userName);
        if (!ret) {
            RangerPluginConfig pluginConfig = this.policyEngine.getPluginContext().getConfig();
            ret = pluginConfig.isServiceAdmin(userName);
        }
        return ret;
    }

    public PolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    public RangerAccessRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    private RangerAccessResult zoneAwareAccessEvaluationWithNoAudit(RangerAccessRequest request, int policyType) {
        LOG.debug("==> RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit({}, policyType={})", (Object)request, (Object)policyType);
        RangerAccessResult ret = null;
        RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
        Set<String> zoneNames = RangerAccessRequestUtil.getResourceZoneNamesFromContext(request.getContext());
        LOG.debug("zoneNames:[{}]", zoneNames);
        if (CollectionUtils.isEmpty(zoneNames) || zoneNames.size() > 1 && !request.isAccessTypeAny()) {
            RangerPolicyRepository policyRepository = this.policyEngine.getRepositoryForZone(null);
            ret = this.evaluatePoliciesNoAudit(request, policyType, null, policyRepository, tagPolicyRepository);
            ret.setZoneName(null);
        } else if (zoneNames.size() == 1 || request.isAccessTypeAny()) {
            for (String zoneName : zoneNames) {
                RangerPolicyRepository policyRepository = this.policyEngine.getRepositoryForZone(zoneName);
                ret = this.evaluatePoliciesNoAudit(request, policyType, zoneName, policyRepository, tagPolicyRepository);
                ret.setZoneName(zoneName);
                if (!ret.getIsAllowed()) continue;
                LOG.debug("Zone:[{}] allowed access. Completed processing other zones", (Object)zoneName);
                break;
            }
        }
        if (request.isAccessTypeAny() && (request.getResource() == null || CollectionUtils.isEmpty(request.getResource().getKeys())) && ret != null && !ret.getIsAllowed() && MapUtils.isNotEmpty(this.policyEngine.getZonePolicyRepositories())) {
            LOG.debug("Process all security-zones");
            for (Map.Entry<String, RangerPolicyRepository> entry : this.policyEngine.getZonePolicyRepositories().entrySet()) {
                RangerAccessResult accessResult;
                String someZone = entry.getKey();
                RangerPolicyRepository policyRepository = entry.getValue();
                LOG.debug("Evaluating policies for zone:[{}]", (Object)someZone);
                if (policyRepository == null || !(accessResult = this.evaluatePoliciesNoAudit(request, policyType, someZone, policyRepository, tagPolicyRepository)).getIsAllowed()) continue;
                LOG.debug("Zone:[{}] allowed access. Completed processing other zones", (Object)someZone);
                accessResult.setZoneName(someZone);
                ret = accessResult;
                break;
            }
        }
        this.updateFromGdsResult(ret);
        LOG.debug("<== RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit({}, policyType ={}): {}", new Object[]{request, policyType, ret});
        return ret;
    }

    private RangerAccessResult evaluatePoliciesNoAudit(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository policyRepository, RangerPolicyRepository tagPolicyRepository) {
        LOG.debug("==> RangerPolicyEngineImpl.evaluatePoliciesNoAudit({}, policyType={}, zoneName={})", new Object[]{request, policyType, zoneName});
        if (request.isAccessTypeAny()) {
            Set<String> allRequestedAccesses = this.getServiceDefHelper().getAllAccessTypes();
            RangerAccessRequestUtil.setAllRequestedAccessTypes(request.getContext(), allRequestedAccesses);
            RangerAccessRequestUtil.setIsAnyAccessInContext(request.getContext(), Boolean.TRUE);
            if (!request.ignoreDescendantDeny()) {
                Set<Set<String>> accessGroups = allRequestedAccesses.stream().map(Collections::singleton).collect(Collectors.toSet());
                RangerAccessRequestUtil.setAllRequestedAccessTypeGroups(request, accessGroups);
            }
        }
        RangerAccessResult ret = this.evaluatePoliciesForOneAccessTypeNoAudit(request, policyType, zoneName, policyRepository, tagPolicyRepository);
        LOG.debug("<== RangerPolicyEngineImpl.evaluatePoliciesNoAudit({}, policyType={}, zoneName={}): {}", new Object[]{request, policyType, zoneName, ret});
        return ret;
    }

    private RangerAccessResult evaluatePoliciesForOneAccessTypeNoAudit(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository policyRepository, RangerPolicyRepository tagPolicyRepository) {
        LOG.debug("==> RangerPolicyEngineImpl.evaluatePoliciesForOneAccessTypeNoAudit({}, policyType={}, zoneName={})", new Object[]{request, policyType, zoneName});
        boolean isSuperUser = this.isSuperUser(request.getUser(), request.getUserGroups());
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        RangerAccessResult ret = this.createAccessResult(request, policyType);
        if (isSuperUser || StringUtils.equals((String)request.getAccessType(), (String)"_super_user")) {
            ret.setIsAllowed(isSuperUser);
            ret.setIsAccessDetermined(true);
            ret.setPolicyId(-1L);
            ret.setPolicyPriority(Integer.MAX_VALUE);
            ret.setReason("superuser");
        }
        this.evaluateTagPolicies(request, policyType, zoneName, tagPolicyRepository, ret);
        if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
            if (!ret.getIsAllowed()) {
                LOG.debug("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access denied by a tag policy. Higher priority resource policies will be evaluated to check for allow, request={}, result={}", (Object)request, (Object)ret);
            } else {
                LOG.debug("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access allowed by a tag policy. Same or higher priority resource policies will be evaluated to check for deny, request={}, result={}", (Object)request, (Object)ret);
            }
        }
        boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
        boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
        boolean evaluateResourcePolicies = this.policyEngine.hasResourcePolicies(policyRepository);
        if (evaluateResourcePolicies) {
            boolean findAuditByResource = !ret.getIsAuditedDetermined();
            boolean foundInCache = findAuditByResource && policyRepository.setAuditEnabledFromCache(request, ret);
            ret.setIsAccessDetermined(false);
            List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchPolicyEvaluators(request, policyType);
            for (RangerPolicyEvaluator evaluator : evaluators) {
                if (!evaluator.isApplicable(accessTime)) continue;
                if (isDeniedByTags) {
                    if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                } else if (ret.getIsAllowed()) {
                    if (policyType == 0) {
                        if (ret.getPolicyPriority() > evaluator.getPolicyPriority()) {
                            ret.setIsAccessDetermined(true);
                        }
                    } else if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                }
                ret.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(request, ret);
                if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                    ret.setIsAccessDetermined(true);
                }
                if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                break;
            }
            if (!ret.getIsAccessDetermined()) {
                if (isDeniedByTags) {
                    ret.setIsAllowed(false);
                } else if (isAllowedByTags) {
                    ret.setIsAllowed(true);
                } else {
                    this.updateFromGdsResult(ret);
                }
                if (!ret.getIsAllowed() && !this.getIsFallbackSupported()) {
                    ret.setIsAccessDetermined(true);
                }
            }
            if (ret.getIsAllowed()) {
                ret.setIsAccessDetermined(true);
            }
            RangerAccessRequestUtil.setAccessTypeResults(request.getContext(), null);
            RangerAccessRequestUtil.setAccessTypeACLResults(request.getContext(), null);
            RangerAccessRequestUtil.setIsAnyAccessInContext(request.getContext(), null);
            if (findAuditByResource && !foundInCache) {
                policyRepository.storeAuditEnabledInCache(request, ret);
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluatePoliciesForOneAccessTypeNoAudit({}, policyType={}, zoneName={}): {}", new Object[]{request, policyType, zoneName, ret});
        return ret;
    }

    private void evaluateTagPolicies(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository tagPolicyRepository, RangerAccessResult result) {
        List<PolicyEvaluatorForTag> policyEvaluators;
        LOG.debug("==> RangerPolicyEngineImpl.evaluateTagPolicies({}, policyType={}, zoneName={}, {})", new Object[]{request, policyType, zoneName, result});
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = policyEvaluators = tagPolicyRepository == null ? null : tagPolicyRepository.getLikelyMatchPolicyEvaluators(request, tags, policyType, accessTime);
        if (CollectionUtils.isNotEmpty(policyEvaluators)) {
            boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
            for (PolicyEvaluatorForTag policyEvaluator : policyEvaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                String policyZoneName = evaluator.getPolicy().getZoneName();
                if (useTagPoliciesFromDefaultZone) {
                    if (StringUtils.isNotEmpty((String)policyZoneName)) {
                        LOG.debug("Tag policy [zone:{}] does not belong to default zone. Not evaluating this policy:[{}]", (Object)policyZoneName, (Object)evaluator.getPolicy());
                        continue;
                    }
                } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                    LOG.debug("Tag policy [zone:{}] does not belong to the zone:[{}] of the accessed resource. Not evaluating this policy:[{}]", new Object[]{policyZoneName, zoneName, evaluator.getPolicy()});
                    continue;
                }
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, policyType);
                LOG.debug("RangerPolicyEngineImpl.evaluateTagPolicies: Evaluating policies for tag ({})", (Object)tag.getType());
                tagEvalResult.setAccessResultFrom(result);
                tagEvalResult.setAuditResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result.setAuditResultFrom(tagEvalResult);
                }
                if (!result.getIsAccessDetermined()) {
                    if (tagEvalResult.getIsAccessDetermined()) {
                        result.setAccessResultFrom(tagEvalResult);
                    } else if (!result.getIsAllowed() && tagEvalResult.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                    }
                }
                if (!result.getIsAuditedDetermined() || !result.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (result.getIsAllowed()) {
            result.setIsAccessDetermined(true);
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluateTagPolicies({}, policyType={}, zoneName={}, {})", new Object[]{request, policyType, zoneName, result});
    }

    private RangerAccessResult createAccessResult(RangerAccessRequest request, int policyType) {
        RangerPolicyRepository repository = this.policyEngine.getPolicyRepository();
        RangerAccessResult ret = new RangerAccessResult(policyType, repository.getServiceName(), repository.getServiceDef(), request);
        switch (repository.getAuditModeEnum()) {
            case AUDIT_ALL: {
                ret.setIsAudited(true);
                break;
            }
            case AUDIT_NONE: {
                ret.setIsAudited(false);
                break;
            }
            default: {
                if (!CollectionUtils.isEmpty(repository.getPolicies()) || this.policyEngine.getTagPolicyRepository() != null) break;
                ret.setIsAudited(true);
            }
        }
        if (this.isAuditExcludedUser(request.getUser(), request.getUserGroups(), RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext()))) {
            ret.setIsAudited(false);
        }
        return ret;
    }

    private boolean isAuditExcludedUser(String userName, Set<String> userGroups, Set<String> userRoles) {
        boolean ret = this.serviceConfig.isAuditExcludedUser(userName);
        if (!ret) {
            RangerPluginConfig pluginConfig = this.policyEngine.getPluginContext().getConfig();
            ret = pluginConfig.isAuditExcludedUser(userName);
            if (!ret && userGroups != null && !userGroups.isEmpty()) {
                boolean bl = ret = this.serviceConfig.hasAuditExcludedGroup(userGroups) || pluginConfig.hasAuditExcludedGroup(userGroups);
            }
            if (!ret && userRoles != null && !userRoles.isEmpty()) {
                ret = this.serviceConfig.hasAuditExcludedRole(userRoles) || pluginConfig.hasAuditExcludedRole(userRoles);
            }
        }
        return ret;
    }

    private boolean isSuperUser(String userName, Set<String> userGroups) {
        RangerPluginConfig pluginConfig;
        boolean ret = this.serviceConfig.isSuperUser(userName);
        if (!(ret || (ret = (pluginConfig = this.policyEngine.getPluginContext().getConfig()).isSuperUser(userName)) || userGroups == null || userGroups.isEmpty())) {
            ret = this.serviceConfig.hasSuperGroup(userGroups) || pluginConfig.hasSuperGroup(userGroups);
        }
        return ret;
    }

    private void getResourceACLEvaluatorsForZone(RangerAccessRequest request, String zoneName, int policyType, List<RangerPolicyEvaluator> allEvaluators, Map<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap, Set<Long> policyIdForTemporalTags) {
        RangerPolicyRepository matchedRepository = this.policyEngine.getRepositoryForZone(zoneName);
        if (matchedRepository == null) {
            LOG.error("policyRepository for zoneName:[{}], serviceName:[{}], policyVersion:[{}] is null!! ERROR!", new Object[]{zoneName, this.policyEngine.getPolicyRepository().getServiceName(), this.getPolicyVersion()});
        } else {
            List<PolicyEvaluatorForTag> tagPolicyEvaluators;
            Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
            List<PolicyEvaluatorForTag> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(request, tags, policyType, null);
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators)) {
                tagPolicyEvaluators.sort(PolicyEvaluatorForTag.MATCH_TYPE_COMPARATOR);
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (PolicyEvaluatorForTag tagEvaluator : tagPolicyEvaluators) {
                    RangerPolicyEvaluator evaluator = tagEvaluator.getEvaluator();
                    String policyZoneName = evaluator.getPolicy().getZoneName();
                    if (useTagPoliciesFromDefaultZone) {
                        if (StringUtils.isNotEmpty((String)policyZoneName)) {
                            LOG.debug("Tag policy [zone:{}] does not belong to default zone. Not evaluating this policy:[{}]", (Object)policyZoneName, (Object)evaluator.getPolicy());
                            continue;
                        }
                    } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                        LOG.debug("Tag policy [zone:{}] does not belong to the zone:[{}] of the accessed resource. Not evaluating this policy:[{}]", new Object[]{policyZoneName, zoneName, evaluator.getPolicy()});
                        continue;
                    }
                    RangerTagForEval tag = tagEvaluator.getTag();
                    if (tagMatchTypeMap.putIfAbsent(evaluator.getPolicyId(), tag.getMatchType()) == null) {
                        allEvaluators.add(evaluator);
                    }
                    if (!CollectionUtils.isNotEmpty(tag.getValidityPeriods())) continue;
                    policyIdForTemporalTags.add(evaluator.getPolicyId());
                }
            }
            List<RangerPolicyEvaluator> resourcePolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request, policyType);
            allEvaluators.addAll(resourcePolicyEvaluators);
        }
    }

    private void getResourceAccessInfoForZone(RangerAccessRequest request, RangerResourceAccessInfo ret, String zoneName) {
        RangerPolicyRepository matchedRepository = this.policyEngine.getRepositoryForZone(zoneName);
        if (matchedRepository == null) {
            LOG.error("policyRepository for zoneName:[{}], serviceName:[{}], policyVersion:[{}] is null!! ERROR!", new Object[]{zoneName, this.policyEngine.getPolicyRepository().getServiceName(), this.getPolicyVersion()});
        } else {
            List<RangerPolicyEvaluator> resPolicyEvaluators;
            Set<RangerTagForEval> tags;
            List<RangerPolicyEvaluator> tagPolicyEvaluators;
            List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getPolicyEvaluators();
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (RangerTagForEval tag : tags) {
                    RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.policyEngine.getTagPolicyRepository().getServiceDef(), request);
                    List<RangerPolicyEvaluator> evaluators = this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(tagEvalRequest, 0);
                    for (RangerPolicyEvaluator evaluator : evaluators) {
                        String policyZoneName = evaluator.getPolicy().getZoneName();
                        if (useTagPoliciesFromDefaultZone) {
                            if (StringUtils.isNotEmpty((String)policyZoneName)) {
                                LOG.debug("Tag policy [zone:{}] does not belong to default zone. Not evaluating this policy:[{}]", (Object)policyZoneName, (Object)evaluator.getPolicy());
                                continue;
                            }
                        } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                            LOG.debug("Tag policy [zone:{}] does not belong to the zone:[{}] of the accessed resource. Not evaluating this policy:[{}]", new Object[]{policyZoneName, zoneName, evaluator.getPolicy()});
                            continue;
                        }
                        evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(resPolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request, 0))) {
                for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                    evaluator.getResourceAccessInfo(request, ret);
                }
            }
            ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
            ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        }
    }

    private void evaluateTagAuditPolicies(RangerAccessRequest request, RangerAccessResult result, RangerPolicyRepository tagPolicyRepository) {
        Date accessTime;
        List<PolicyEvaluatorForTag> evaluators;
        LOG.debug("==> RangerPolicyEngineImpl.evaluateTagAuditPolicies(request={}, result={})", (Object)request, (Object)result);
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (CollectionUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(evaluators = tagPolicyRepository.getLikelyMatchPolicyEvaluators(request, tags, 3, accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date()))) {
            for (PolicyEvaluatorForTag policyEvaluator : evaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, 3);
                LOG.debug("RangerPolicyEngineImpl.evaluateTagAuditPolicies: Evaluating Audit policies for tag ({}) Tag Evaluator: {}", (Object)tag.getType(), (Object)policyEvaluator);
                tagEvalResult.setAccessResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (!tagEvalResult.getIsAuditedDetermined()) continue;
                result.setIsAudited(tagEvalResult.getIsAudited());
                break;
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluateTagAuditPolicies(request={}, result={})", (Object)request, (Object)result);
    }

    private boolean evaluateResourceAuditPolicies(RangerAccessRequest request, RangerAccessResult result, RangerPolicyRepository policyRepository) {
        LOG.debug("==> RangerPolicyEngineImpl.evaluateResourceAuditPolicies(request={}, result={})", (Object)request, (Object)result);
        boolean ret = false;
        List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchAuditPolicyEvaluators(request);
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyEvaluator evaluator : evaluators) {
                LOG.debug("==> RangerPolicyEngineImpl.evaluateResourceAuditPolicies(): Evaluating RangerPolicyEvaluator...: {}", (Object)evaluator);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(request, result);
                if (!result.getIsAuditedDetermined()) continue;
                ret = true;
                break;
            }
        }
        LOG.debug("<== RangerPolicyEngineImpl.evaluateResourceAuditPolicies(request={}, result={}): ret={}", new Object[]{request, result, ret});
        return ret;
    }

    private boolean getIsFallbackSupported() {
        return this.policyEngine.getPluginContext().getConfig().getIsFallbackSupported();
    }

    private void updateFromGdsResult(RangerAccessResult result) {
        GdsAccessResult gdsResult;
        LOG.debug("==> updateFromGdsResult(result={})", (Object)result);
        RangerAccessRequest request = result.getAccessRequest();
        GdsAccessResult gdsAccessResult = gdsResult = request != null ? RangerAccessRequestUtil.getGdsResultFromContext(request.getContext()) : null;
        if (gdsResult != null) {
            if (result.getPolicyType() == 0) {
                if (!result.getIsAccessDetermined() && gdsResult.getIsAllowed()) {
                    this.copyFromGdsResult(gdsResult, result);
                }
            } else if (result.getPolicyType() == 2) {
                if (result.getPolicyId() == -1L && CollectionUtils.isNotEmpty(gdsResult.getRowFilters())) {
                    this.copyFromGdsResult(gdsResult, result);
                    result.setFilterExpr(gdsResult.getRowFilters().get(0));
                }
            } else if (result.getPolicyType() == 1 && result.getPolicyId() == -1L && StringUtils.isNotEmpty((String)gdsResult.getMaskType())) {
                this.copyFromGdsResult(gdsResult, result);
                result.setMaskType(gdsResult.getMaskType());
                result.setMaskedValue(gdsResult.getMaskedValue());
                result.setMaskCondition(gdsResult.getMaskCondition());
            }
            if (!result.getIsAuditedDetermined() && gdsResult.getIsAudited()) {
                result.setIsAudited(true);
            }
            result.setDatasets(gdsResult.getDatasets());
            result.setProjects(gdsResult.getProjects());
        } else {
            LOG.debug("updateFromGdsResult(): no GdsAccessResult found in request context({})", (Object)request);
        }
        LOG.debug("<== updateFromGdsResult(result={})", (Object)result);
    }

    private void copyFromGdsResult(GdsAccessResult gdsResult, RangerAccessResult result) {
        if (gdsResult != null && result != null) {
            result.setIsAllowed(true);
            result.setIsAccessDetermined(true);
            result.setPolicyId(gdsResult.getPolicyId());
            result.setPolicyVersion(gdsResult.getPolicyVersion());
            result.setPolicyPriority(0);
        }
    }

    private static class ServiceConfig {
        private final Set<String> auditExcludedUsers;
        private final Set<String> auditExcludedGroups;
        private final Set<String> auditExcludedRoles;
        private final Set<String> superUsers;
        private final Set<String> superGroups;
        private final Set<String> serviceAdmins;

        public ServiceConfig(Map<String, String> svcConfig) {
            if (svcConfig != null) {
                this.auditExcludedUsers = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.users"));
                this.auditExcludedGroups = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.groups"));
                this.auditExcludedRoles = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.roles"));
                this.superUsers = StringUtil.toSet(svcConfig.get("ranger.plugin.super.users"));
                this.superGroups = StringUtil.toSet(svcConfig.get("ranger.plugin.super.groups"));
                this.serviceAdmins = StringUtil.toSet(svcConfig.get("ranger.plugin.service.admins"));
            } else {
                this.auditExcludedUsers = Collections.emptySet();
                this.auditExcludedGroups = Collections.emptySet();
                this.auditExcludedRoles = Collections.emptySet();
                this.superUsers = Collections.emptySet();
                this.superGroups = Collections.emptySet();
                this.serviceAdmins = Collections.emptySet();
            }
        }

        public ServiceConfig(ServiceConfig other) {
            this.auditExcludedUsers = other == null || CollectionUtils.isEmpty(other.auditExcludedUsers) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedUsers);
            this.auditExcludedGroups = other == null || CollectionUtils.isEmpty(other.auditExcludedGroups) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedGroups);
            this.auditExcludedRoles = other == null || CollectionUtils.isEmpty(other.auditExcludedRoles) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedRoles);
            this.superUsers = other == null || CollectionUtils.isEmpty(other.superUsers) ? Collections.emptySet() : new HashSet<String>(other.superUsers);
            this.superGroups = other == null || CollectionUtils.isEmpty(other.superGroups) ? Collections.emptySet() : new HashSet<String>(other.superGroups);
            this.serviceAdmins = other == null || CollectionUtils.isEmpty(other.serviceAdmins) ? Collections.emptySet() : new HashSet<String>(other.serviceAdmins);
        }

        public boolean isAuditExcludedUser(String userName) {
            return this.auditExcludedUsers.contains(userName);
        }

        public boolean hasAuditExcludedGroup(Set<String> userGroups) {
            return userGroups != null && !userGroups.isEmpty() && !this.auditExcludedGroups.isEmpty() && CollectionUtils.containsAny(userGroups, this.auditExcludedGroups);
        }

        public boolean hasAuditExcludedRole(Set<String> userRoles) {
            return userRoles != null && !userRoles.isEmpty() && !this.auditExcludedRoles.isEmpty() && CollectionUtils.containsAny(userRoles, this.auditExcludedRoles);
        }

        public boolean isSuperUser(String userName) {
            return this.superUsers.contains(userName);
        }

        public boolean hasSuperGroup(Set<String> userGroups) {
            return userGroups != null && !userGroups.isEmpty() && !this.superGroups.isEmpty() && CollectionUtils.containsAny(userGroups, this.superGroups);
        }

        public boolean isServiceAdmin(String userName) {
            return this.serviceAdmins.contains(userName);
        }
    }
}

