/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginContext {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginContext.class);
    private final RangerPluginConfig config;
    private final Map<String, Map<RangerPolicy.RangerPolicyResource, RangerResourceMatcher>> resourceMatchers = new HashMap<String, Map<RangerPolicy.RangerPolicyResource, RangerResourceMatcher>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private RangerAuthContext authContext;
    private RangerAuthContextListener authContextListener;
    private RangerAdminClient adminClient;

    public RangerPluginContext(RangerPluginConfig config) {
        this.config = config;
    }

    public RangerPluginConfig getConfig() {
        return this.config;
    }

    public String getClusterName() {
        return this.config.getClusterName();
    }

    public String getClusterType() {
        return this.config.getClusterType();
    }

    public RangerAuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(RangerAuthContext authContext) {
        this.authContext = authContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangerResourceMatcher getResourceMatcher(String resourceDefName, RangerPolicy.RangerPolicyResource resource) {
        LOG.debug("==> getResourceMatcher(resourceDefName={}, resource={})", (Object)resourceDefName, (Object)resource);
        RangerResourceMatcher ret = null;
        try {
            this.lock.readLock().lock();
            Map<RangerPolicy.RangerPolicyResource, RangerResourceMatcher> matchersForResource = this.resourceMatchers.get(resourceDefName);
            if (matchersForResource != null) {
                ret = matchersForResource.get(resource);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LOG.debug("<== getResourceMatcher(resourceDefName={}, resource={}) : ret={}", new Object[]{resourceDefName, resource, ret});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceMatcher(String resourceDefName, RangerPolicy.RangerPolicyResource resource, RangerResourceMatcher matcher) {
        LOG.debug("==> setResourceMatcher(resourceDefName={}, resource={}, matcher={})", new Object[]{resourceDefName, resource, matcher});
        if (this.config != null && this.config.getPolicyEngineOptions().enableResourceMatcherReuse) {
            try {
                this.lock.writeLock().lock();
                Map matchersForResource = this.resourceMatchers.computeIfAbsent(resourceDefName, k -> new HashMap());
                matchersForResource.put(resource, matcher);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        LOG.debug("<== setResourceMatcher(resourceDefName={}, resource={}, matcher={})", new Object[]{resourceDefName, resource, matcher});
    }

    public void setAuthContextListener(RangerAuthContextListener authContextListener) {
        this.authContextListener = authContextListener;
    }

    public void notifyAuthContextChanged() {
        RangerAuthContextListener authContextListener = this.authContextListener;
        if (authContextListener != null) {
            authContextListener.contextChanged();
        }
    }

    public RangerAdminClient getAdminClient() {
        return this.adminClient;
    }

    public void setAdminClient(RangerAdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public RangerAdminClient createAdminClient(RangerPluginConfig pluginConfig) {
        LOG.debug("==> RangerBasePlugin.createAdminClient({}, {}, {})", new Object[]{pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix()});
        RangerAdminClient ret = null;
        String propertyName = pluginConfig.getPropertyPrefix() + ".policy.source.impl";
        String policySourceImpl = pluginConfig.get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            LOG.debug("Value for property[{}] was null or empty. Unexpected! Will use policy source of type[{}]", (Object)propertyName, (Object)RangerAdminRESTClient.class.getName());
        } else {
            LOG.debug("Value for property[{}] was [{}].", (Object)propertyName, (Object)policySourceImpl);
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error("failed to instantiate policy source of type '{}'. Will use policy source of type '{}'", new Object[]{policySourceImpl, RangerAdminRESTClient.class.getName(), excp});
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), pluginConfig);
        LOG.debug("<== RangerBasePlugin.createAdminClient({}, {}, {}): policySourceImpl={}, client={}", new Object[]{pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), policySourceImpl, ret});
        this.setAdminClient(ret);
        return ret;
    }

    void cleanResourceMatchers() {
        LOG.debug("==> cleanResourceMatchers()");
        try {
            this.lock.writeLock().lock();
            this.resourceMatchers.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.debug("<== cleanResourceMatchers()");
    }
}

