/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.Objects;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationFailureDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationFailureDetails.class);
    final String fieldName;
    final String subFieldName;
    final boolean missing;
    final boolean semanticError;
    final boolean internalError;
    final String reason;
    final int errorCode;

    public ValidationFailureDetails(ValidationErrorCode errorCode, String fieldName, Object ... errorCodeArgs) {
        this(errorCode.getErrorCode(), fieldName, null, false, false, false, errorCode.getMessage(errorCodeArgs));
    }

    public ValidationFailureDetails(int errorCode, String fieldName, String subFieldName, boolean missing, boolean semanticError, boolean internalError, String reason) {
        this.errorCode = errorCode;
        this.missing = missing;
        this.semanticError = semanticError;
        this.internalError = internalError;
        this.fieldName = fieldName;
        this.subFieldName = subFieldName;
        this.reason = reason;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isMissingRequiredValue() {
        return this.missing;
    }

    public boolean isSemanticallyIncorrect() {
        return this.semanticError;
    }

    public String getSubFieldName() {
        return this.subFieldName;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.subFieldName, this.missing, this.semanticError, this.internalError, this.reason, this.errorCode);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValidationFailureDetails)) {
            return false;
        }
        ValidationFailureDetails that = (ValidationFailureDetails)obj;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.subFieldName, that.subFieldName) && Objects.equals(this.reason, that.reason) && this.internalError == that.internalError && this.missing == that.missing && this.semanticError == that.semanticError && this.errorCode == that.errorCode;
    }

    public String toString() {
        LOG.debug("ValidationFailureDetails.toString()");
        return String.format(" %s: error code[%d], reason[%s], field[%s], subfield[%s], type[%s]", "Validation failure", this.errorCode, this.reason, this.fieldName, this.subFieldName, this.getType());
    }

    String getType() {
        if (this.missing) {
            return "missing";
        }
        if (this.semanticError) {
            return "semantically incorrect";
        }
        if (this.internalError) {
            return "internal error";
        }
        return "";
    }
}

