/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.resourcematcher.RangerPathResourceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceDefHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceDefHelper.class);
    public static final String RRN_RESOURCE_PREFIX = "{";
    public static final String RRN_RESOURCE_SUFFIX = "}";
    public static final String RRN_RESOURCE_SEP = ".";
    public static final String RRN_PATH_RESOURCE_SEP = "/";
    static final Map<String, Delegate> cache = new ConcurrentHashMap<String, Delegate>();
    final Delegate delegate;

    public RangerServiceDefHelper(RangerServiceDef serviceDef) {
        this(serviceDef, true, false);
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef, boolean useCache) {
        this(serviceDef, useCache, false);
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef, boolean useCache, boolean checkForCycles) {
        LOG.debug("==> RangerServiceDefHelper(). The RangerServiceDef: {}", (Object)serviceDef);
        String serviceName = serviceDef.getName();
        Date serviceDefFreshnessDate = serviceDef.getUpdateTime();
        Delegate delegate = null;
        if (useCache && cache.containsKey(serviceName)) {
            LOG.debug("RangerServiceDefHelper(): found delegate in cache with matching serviceName.  Need to check date");
            Delegate that = cache.get(serviceName);
            if (Objects.equals(that.getServiceFreshnessDate(), serviceDefFreshnessDate)) {
                delegate = that;
                LOG.debug("RangerServiceDefHelper(): cached delegate matched in date, too! Will use it now.");
            } else {
                LOG.debug("RangerServiceDefHelper(): cached delegate date mismatch!");
            }
        }
        if (delegate == null) {
            delegate = new Delegate(serviceDef, checkForCycles);
            if (useCache) {
                LOG.debug("RangerServiceDefHelper(): Created new delegate and put in delegate cache!");
                cache.put(serviceName, delegate);
            }
        }
        this.delegate = delegate;
    }

    public static RangerServiceDef getServiceDefForPolicyFiltering(RangerServiceDef serviceDef) {
        ArrayList<RangerServiceDef.RangerResourceDef> modifiedResourceDefs = new ArrayList<RangerServiceDef.RangerResourceDef>();
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            RangerServiceDef.RangerResourceDef modifiedResourceDef;
            String matcherClassName = resourceDef.getMatcher();
            if (RangerPathResourceMatcher.class.getName().equals(matcherClassName)) {
                HashMap<String, String> modifiedMatcherOptions = new HashMap<String, String>(resourceDef.getMatcherOptions());
                modifiedMatcherOptions.put("wildCard", "false");
                modifiedResourceDef = new RangerServiceDef.RangerResourceDef(resourceDef);
                modifiedResourceDef.setMatcherOptions(modifiedMatcherOptions);
                modifiedResourceDef.setRecursiveSupported(false);
            } else {
                modifiedResourceDef = resourceDef;
            }
            modifiedResourceDefs.add(modifiedResourceDef);
        }
        return new RangerServiceDef(serviceDef.getName(), serviceDef.getDisplayName(), serviceDef.getImplClass(), serviceDef.getLabel(), serviceDef.getDescription(), serviceDef.getOptions(), serviceDef.getConfigs(), modifiedResourceDefs, serviceDef.getAccessTypes(), serviceDef.getPolicyConditions(), serviceDef.getContextEnrichers(), serviceDef.getEnums());
    }

    public static Map<String, String> getFilterResourcesForAncestorPolicyFiltering(RangerServiceDef serviceDef, Map<String, String> filterResources) {
        HashMap<String, String> ret = null;
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            String resourceValue;
            String matcherClassName = resourceDef.getMatcher();
            if (!RangerPathResourceMatcher.class.getName().equals(matcherClassName)) continue;
            String resourceDefName = resourceDef.getName();
            Map<String, String> resourceMatcherOptions = resourceDef.getMatcherOptions();
            String delimiter = resourceMatcherOptions.get("pathSeparatorChar");
            if (StringUtils.isBlank((String)delimiter)) {
                delimiter = Character.toString('/');
            }
            if (!StringUtils.isNotBlank((String)(resourceValue = filterResources.get(resourceDefName)))) continue;
            if (!resourceValue.endsWith(delimiter)) {
                resourceValue = resourceValue + delimiter;
            }
            resourceValue = resourceValue + "*";
            if (ret == null) {
                ret = new HashMap<String, String>();
            }
            ret.put(resourceDefName, resourceValue);
        }
        return ret;
    }

    public static Set<String> getAllResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public RangerServiceDef getServiceDef() {
        return this.delegate.servicedef;
    }

    public void patchServiceDefWithDefaultValues() {
        this.delegate.patchServiceDefWithDefaultValues();
    }

    public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName) {
        return this.delegate.getResourceDef(resourceName, 0);
    }

    public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName, Integer policyType) {
        return this.delegate.getResourceDef(resourceName, policyType);
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
        return this.delegate.getResourceHierarchies(policyType);
    }

    public Set<Set<String>> getResourceHierarchyKeys(Integer policyType) {
        return this.delegate.getResourceHierarchyKeys(policyType);
    }

    public String getRrnTemplate(String resourceName) {
        return this.delegate.getRrnTemplate(resourceName);
    }

    public boolean isDataMaskSupported() {
        return this.delegate.isDataMaskSupported();
    }

    public boolean isDataMaskSupported(Set<String> resourceKeys) {
        return this.delegate.isDataMaskSupported(resourceKeys);
    }

    public boolean isRowFilterSupported() {
        return this.delegate.isRowFilterSupported();
    }

    public boolean isRowFilterSupported(Set<String> resourceKeys) {
        return this.delegate.isRowFilterSupported(resourceKeys);
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_containsOnlyMandatoryResources(Integer policyType) {
        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = this.getResourceHierarchies(policyType);
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            Set<String> mandatoryResources = this.getMandatoryResourceNames(aHierarchy);
            if (aHierarchy.size() != mandatoryResources.size()) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    public boolean isValidHierarchy(Integer policyType, Collection<String> keys, boolean requireExactMatch) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isValidHierarchy(policyType={}, keys={}, requireExactMatch={})", new Object[]{policyType, StringUtils.join(keys, (String)", "), requireExactMatch});
        }
        boolean ret = false;
        for (Set<String> hierarchyKeys : this.getResourceHierarchyKeys(policyType)) {
            ret = requireExactMatch ? hierarchyKeys.equals(keys) : hierarchyKeys.containsAll(keys);
            if (!ret) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isValidHierarchy(policyType={}, keys={}, requireExactMatch={}): ret={}", new Object[]{policyType, StringUtils.join(keys, (String)", "), requireExactMatch, ret});
        }
        return ret;
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType, Collection<String> keys) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getResourceHierarchies(policyType={}, keys={})", (Object)policyType, (Object)StringUtils.join(keys, (String)","));
        }
        HashSet<List<RangerServiceDef.RangerResourceDef>> ret = new HashSet<List<RangerServiceDef.RangerResourceDef>>();
        if (policyType == 3) {
            policyType = 0;
        }
        for (List<RangerServiceDef.RangerResourceDef> hierarchy : this.getResourceHierarchies(policyType)) {
            if (!this.hierarchyHasAllResources(hierarchy, keys)) continue;
            ret.add(hierarchy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getResourceHierarchies(policyType={}, keys={}) : {}", new Object[]{policyType, StringUtils.join(keys, (String)","), StringUtils.join(ret, (String)"")});
        }
        return ret;
    }

    public boolean hierarchyHasAllResources(List<RangerServiceDef.RangerResourceDef> hierarchy, Collection<String> resourceNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> hierarchyHasAllResources(hierarchy={}, resourceNames={})", (Object)StringUtils.join(hierarchy, (String)","), (Object)StringUtils.join(resourceNames, (String)","));
        }
        boolean foundAllResourceKeys = true;
        for (String resourceKey : resourceNames) {
            boolean found = false;
            for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
                if (!resourceDef.getName().equals(resourceKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            foundAllResourceKeys = false;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== hierarchyHasAllResources(hierarchy={}, resourceNames={}): {}", new Object[]{StringUtils.join(hierarchy, (String)","), StringUtils.join(resourceNames, (String)","), foundAllResourceKeys});
        }
        return foundAllResourceKeys;
    }

    public Set<String> getMandatoryResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            if (!Boolean.TRUE.equals(resourceDef.getMandatory())) continue;
            result.add(resourceDef.getName());
        }
        return result;
    }

    public List<String> getAllResourceNamesOrdered(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        ArrayList<String> result = new ArrayList<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public boolean isResourceGraphValid() {
        return this.delegate.isResourceGraphValid();
    }

    public Set<String> getAllResourceNames() {
        return this.delegate.rrnTemplates.keySet();
    }

    public List<String> getOrderedResourceNames(Collection<String> resourceNames) {
        List<String> ret;
        if (resourceNames != null) {
            ret = new ArrayList();
            block0: for (String orderedName : this.delegate.getAllOrderedResourceNames()) {
                for (String resourceName : resourceNames) {
                    if (!StringUtils.equals((String)orderedName, (String)resourceName) || ret.contains(resourceName)) continue;
                    ret.add(resourceName);
                    continue block0;
                }
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public RangerServiceDef.RangerResourceDef getWildcardEnabledResourceDef(String resourceName, Integer policyType) {
        return this.delegate.getWildcardEnabledResourceDef(resourceName, policyType);
    }

    public Set<String> getAllAccessTypes() {
        return this.delegate.getAllAccessTypes();
    }

    public Map<String, Collection<String>> getImpliedAccessGrants() {
        return this.delegate.getImpliedAccessGrants();
    }

    public Set<String> expandImpliedAccessGrants(Set<String> accessTypes) {
        Set<String> ret;
        if (CollectionUtils.isNotEmpty(accessTypes)) {
            Map<String, Collection<String>> impliedGrants = this.getImpliedAccessGrants();
            if (CollectionUtils.containsAny(impliedGrants.keySet(), accessTypes)) {
                ret = new HashSet<String>(accessTypes);
                for (String accessType : accessTypes) {
                    Collection<String> impliedAccessTypes = impliedGrants.get(accessType);
                    if (!CollectionUtils.isNotEmpty(impliedAccessTypes)) continue;
                    ret.addAll(impliedAccessTypes);
                }
            } else {
                ret = accessTypes;
            }
        } else {
            ret = Collections.emptySet();
        }
        return ret;
    }

    static class DirectedGraph {
        Map<String, Set<String>> nodes = new HashMap<String, Set<String>>();

        DirectedGraph() {
        }

        public int hashCode() {
            return Objects.hashCode(this.nodes);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            DirectedGraph that = (DirectedGraph)object;
            return Objects.equals(this.nodes, that.nodes);
        }

        public String toString() {
            return "_nodes=" + this.nodes;
        }

        void add(String node) {
            if (node == null) {
                throw new IllegalArgumentException("Node can't be null!");
            }
            if (!this.nodes.containsKey(node)) {
                this.nodes.put(node, new HashSet());
            }
        }

        void addArc(String from, String to) {
            if (!this.nodes.containsKey(from)) {
                this.add(from);
            }
            if (!this.nodes.containsKey(to)) {
                this.add(to);
            }
            this.nodes.get(from).add(to);
        }

        boolean hasArc(String from, String to) {
            return this.nodes.containsKey(from) && this.nodes.containsKey(to) && this.nodes.get(from).contains(to);
        }

        boolean hasNeighbors(String from) {
            return this.nodes.containsKey(from) && !this.nodes.get(from).isEmpty();
        }

        Set<String> getSources() {
            HashSet<String> sources = new HashSet<String>(this.nodes.keySet());
            for (Map.Entry<String, Set<String>> entry : this.nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                sources.removeAll(nbrs);
            }
            LOG.debug("Returning sources: {}", sources);
            return sources;
        }

        Set<String> getSinks() {
            HashSet<String> sinks = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                if (!nbrs.isEmpty()) continue;
                String node = entry.getKey();
                sinks.add(node);
            }
            LOG.debug("Returning sinks: {}", sinks);
            return sinks;
        }

        List<String> getACycle(Set<String> sources, Set<String> sinks) {
            List<String> ret = null;
            Sets.SetView nonSourceOrSinkNodes = Sets.difference(this.nodes.keySet(), (Set)Sets.union(sources, sinks));
            for (String node : nonSourceOrSinkNodes) {
                ArrayList<String> seenNodes = new ArrayList<String>();
                seenNodes.add(node);
                ret = this.findCycle(node, seenNodes);
                if (ret == null) continue;
                break;
            }
            return ret;
        }

        List<String> findCycle(String node, List<String> seenNodes) {
            List<String> ret = null;
            Set<String> nbrs = this.nodes.get(node);
            for (String nbr : nbrs) {
                boolean foundCycle = seenNodes.contains(nbr);
                seenNodes.add(nbr);
                if (foundCycle) {
                    ret = seenNodes;
                    break;
                }
                ret = this.findCycle(nbr, seenNodes);
                if (ret == null) continue;
                break;
            }
            return ret;
        }

        List<String> getAPath(String from, String to, Set<String> alreadyVisited) {
            ArrayList<String> path = new ArrayList<String>(this.nodes.size());
            if (this.nodes.containsKey(from) && this.nodes.containsKey(to)) {
                if (this.hasArc(from, to)) {
                    path.add(from);
                    path.add(to);
                } else {
                    alreadyVisited.add(from);
                    Set<String> nbrs = this.nodes.get(from);
                    for (String nbr : nbrs) {
                        List<String> subPath;
                        if (alreadyVisited.contains(nbr) || (subPath = this.getAPath(nbr, to, alreadyVisited)).isEmpty()) continue;
                        path.add(from);
                        path.addAll(subPath);
                    }
                }
            }
            return path;
        }
    }

    static class Delegate {
        static final Set<List<RangerServiceDef.RangerResourceDef>> EMPTY_RESOURCE_HIERARCHY = Collections.unmodifiableSet(new HashSet());
        final RangerServiceDef servicedef;
        final Map<Integer, Set<List<RangerServiceDef.RangerResourceDef>>> hierarchies = new HashMap<Integer, Set<List<RangerServiceDef.RangerResourceDef>>>();
        final Map<Integer, Set<Set<String>>> hierarchyKeys = new HashMap<Integer, Set<Set<String>>>();
        final Map<Integer, Map<String, RangerServiceDef.RangerResourceDef>> wildcardEnabledResourceDefs = new HashMap<Integer, Map<String, RangerServiceDef.RangerResourceDef>>();
        final Date serviceDefFreshnessDate;
        final String serviceName;
        final boolean checkForCycles;
        final boolean valid;
        final List<String> orderedResourceNames;
        final Map<String, Collection<String>> impliedGrants;
        final Set<String> allAccessTypes;
        final boolean isDataMaskSupported;
        final boolean isRowFilterSupported;
        final Map<String, String> rrnTemplates = new HashMap<String, String>();

        public Delegate(RangerServiceDef serviceDef, boolean checkForCycles) {
            this.servicedef = serviceDef;
            this.serviceName = serviceDef.getName();
            this.serviceDefFreshnessDate = serviceDef.getUpdateTime();
            this.checkForCycles = checkForCycles;
            boolean isValid = true;
            Object object = RangerPolicy.POLICY_TYPES;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                Integer policyType = object[i];
                List<RangerServiceDef.RangerResourceDef> resources = this.getResourceDefs(serviceDef, policyType);
                DirectedGraph graph = this.createGraph(resources);
                if (graph != null) {
                    Map<String, RangerServiceDef.RangerResourceDef> resourceDefMap = this.getResourcesAsMap(resources);
                    if (this.isValid(graph, resourceDefMap)) {
                        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = this.getHierarchies(graph, resourceDefMap);
                        HashSet<Set<String>> hierachyKeys = new HashSet<Set<String>>(hierarchies.size());
                        for (List<RangerServiceDef.RangerResourceDef> hierarchy : hierarchies) {
                            hierachyKeys.add(Collections.unmodifiableSet(RangerServiceDefHelper.getAllResourceNames(hierarchy)));
                        }
                        this.hierarchies.put(policyType, Collections.unmodifiableSet(hierarchies));
                        this.hierarchyKeys.put(policyType, Collections.unmodifiableSet(hierachyKeys));
                        continue;
                    }
                    isValid = false;
                    this.hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
                    this.hierarchyKeys.put(policyType, Collections.emptySet());
                    continue;
                }
                this.hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
                this.hierarchyKeys.put(policyType, Collections.emptySet());
            }
            this.impliedGrants = this.computeImpliedGrants();
            this.allAccessTypes = Collections.unmodifiableSet(serviceDef.getAccessTypes().stream().map(RangerServiceDef.RangerAccessTypeDef::getName).collect(Collectors.toSet()));
            this.isDataMaskSupported = CollectionUtils.isNotEmpty((Collection)this.hierarchyKeys.get(1));
            this.isRowFilterSupported = CollectionUtils.isNotEmpty((Collection)this.hierarchyKeys.get(2));
            if (isValid) {
                this.orderedResourceNames = this.buildSortedResourceNames();
                object = serviceDef.getResources().iterator();
                while (object.hasNext()) {
                    RangerServiceDef.RangerResourceDef resourceDef = (RangerServiceDef.RangerResourceDef)object.next();
                    if (StringUtils.isBlank((String)resourceDef.getRrnTemplate())) {
                        resourceDef.setRrnTemplate(this.getDefaultRrnTemplate(resourceDef));
                        LOG.debug("No rrnTemplate was defined for resource {}.{}. It is now set to default: {}", new Object[]{this.serviceName, resourceDef.getName(), resourceDef.getRrnTemplate()});
                    }
                    this.rrnTemplates.put(resourceDef.getName(), resourceDef.getRrnTemplate());
                }
            } else {
                this.orderedResourceNames = new ArrayList<String>();
            }
            this.valid = isValid;
            LOG.debug("Found [{}] resource hierarchies for service [{}] update-date[{}]: {}", new Object[]{this.hierarchies.size(), this.serviceName, this.serviceDefFreshnessDate, this.hierarchies});
        }

        public void patchServiceDefWithDefaultValues() {
            for (int policyType : RangerPolicy.POLICY_TYPES) {
                Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = this.getResourceHierarchies(policyType);
                for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                    for (int index = 0; index < resourceHierarchy.size(); ++index) {
                        RangerServiceDef.RangerResourceDef resourceDef = resourceHierarchy.get(index);
                        if (Boolean.TRUE.equals(resourceDef.getIsValidLeaf())) continue;
                        resourceDef.setIsValidLeaf(index == resourceHierarchy.size() - 1);
                    }
                }
            }
        }

        public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName, Integer policyType) {
            if (policyType == null) {
                policyType = 0;
            }
            RangerServiceDef.RangerResourceDef ret = null;
            List<RangerServiceDef.RangerResourceDef> resourceDefs = this.getResourceDefs(this.servicedef, policyType);
            if (resourceDefs != null) {
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    if (!StringUtils.equals((String)resourceName, (String)resourceDef.getName())) continue;
                    ret = resourceDef;
                    break;
                }
            }
            return ret;
        }

        public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
            Set<List<RangerServiceDef.RangerResourceDef>> ret;
            if (policyType == null) {
                policyType = 0;
            }
            if ((ret = this.hierarchies.get(policyType)) == null) {
                ret = EMPTY_RESOURCE_HIERARCHY;
            }
            return ret;
        }

        public Set<Set<String>> getResourceHierarchyKeys(Integer policyType) {
            Set<Set<String>> ret;
            if (policyType == null || policyType == 3) {
                policyType = 0;
            }
            return (ret = this.hierarchyKeys.get(policyType)) != null ? ret : Collections.emptySet();
        }

        public String getRrnTemplate(String resourceName) {
            return this.rrnTemplates.get(resourceName);
        }

        public boolean isDataMaskSupported() {
            return this.isDataMaskSupported;
        }

        public boolean isDataMaskSupported(Set<String> resourceKeys) {
            return this.isDataMaskSupported && this.getResourceHierarchyKeys(1).contains(resourceKeys);
        }

        public boolean isRowFilterSupported() {
            return this.isRowFilterSupported;
        }

        public boolean isRowFilterSupported(Set<String> resourceKeys) {
            return this.isRowFilterSupported && this.getResourceHierarchyKeys(2).contains(resourceKeys);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public Date getServiceFreshnessDate() {
            return this.serviceDefFreshnessDate;
        }

        public boolean isResourceGraphValid() {
            return this.valid;
        }

        public Set<String> getAllAccessTypes() {
            return this.allAccessTypes;
        }

        DirectedGraph createGraph(List<RangerServiceDef.RangerResourceDef> resourceDefs) {
            DirectedGraph graph = null;
            if (CollectionUtils.isNotEmpty(resourceDefs)) {
                graph = new DirectedGraph();
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    String name = resourceDef.getName();
                    graph.add(name);
                    String parent = resourceDef.getParent();
                    if (!StringUtils.isNotEmpty((String)parent)) continue;
                    graph.addArc(parent, name);
                }
            }
            LOG.debug("Created graph for resources: {}", (Object)graph);
            return graph;
        }

        RangerServiceDef.RangerResourceDef getWildcardEnabledResourceDef(String resourceName, Integer policyType) {
            if (policyType == null) {
                policyType = 0;
            }
            Map wResourceDefs = this.wildcardEnabledResourceDefs.computeIfAbsent(policyType, k -> new HashMap());
            RangerServiceDef.RangerResourceDef ret = null;
            if (!wResourceDefs.containsKey(resourceName)) {
                List<RangerServiceDef.RangerResourceDef> resourceDefs = this.getResourceDefs(this.servicedef, policyType);
                if (resourceDefs != null) {
                    for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                        if (!StringUtils.equals((String)resourceName, (String)resourceDef.getName())) continue;
                        ret = new RangerServiceDef.RangerResourceDef(resourceDef);
                        ret.getMatcherOptions().put("wildCard", Boolean.TRUE.toString());
                        break;
                    }
                }
                wResourceDefs.put(resourceName, ret);
            } else {
                ret = (RangerServiceDef.RangerResourceDef)wResourceDefs.get(resourceName);
            }
            return ret;
        }

        List<RangerServiceDef.RangerResourceDef> getResourceDefs(RangerServiceDef serviceDef, Integer policyType) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs = policyType == null || policyType == 0 ? serviceDef.getResources() : (policyType == 1 ? (serviceDef.getDataMaskDef() != null ? serviceDef.getDataMaskDef().getResources() : null) : (policyType == 2 ? (serviceDef.getRowFilterDef() != null ? serviceDef.getRowFilterDef().getResources() : null) : serviceDef.getResources()));
            return resourceDefs;
        }

        boolean isValid(DirectedGraph graph, Map<String, RangerServiceDef.RangerResourceDef> resourceDefMap) {
            boolean ret = true;
            Set<String> sources = graph.getSources();
            Set<String> sinks = graph.getSinks();
            if (CollectionUtils.isEmpty(sources) || CollectionUtils.isEmpty(sinks)) {
                ret = false;
            } else {
                List<String> cycle;
                List<String> list = cycle = this.checkForCycles ? graph.getACycle(sources, sinks) : null;
                if (cycle == null) {
                    for (String sink : sinks) {
                        RangerServiceDef.RangerResourceDef sinkResourceDef = resourceDefMap.get(sink);
                        if (!Boolean.FALSE.equals(sinkResourceDef.getIsValidLeaf())) continue;
                        LOG.error("Error in path: sink node:[{}] is not leaf node", (Object)sink);
                        ret = false;
                        break;
                    }
                } else {
                    LOG.error("Graph contains cycle! - {}", cycle);
                    ret = false;
                }
            }
            return ret;
        }

        Set<List<RangerServiceDef.RangerResourceDef>> getHierarchies(DirectedGraph graph, Map<String, RangerServiceDef.RangerResourceDef> resourceMap) {
            HashSet<List<String>> hierarchies = new HashSet<List<String>>();
            Set<String> sources = graph.getSources();
            Set<String> sinks = graph.getSinks();
            for (String source : sources) {
                if (!graph.hasNeighbors(source)) {
                    hierarchies.add(Lists.newArrayList((Object[])new String[]{source}));
                    continue;
                }
                for (String sink : sinks) {
                    List<String> path = graph.getAPath(source, sink, new HashSet<String>());
                    if (path.isEmpty()) continue;
                    hierarchies.add(path);
                    ArrayList<String> workingPath = new ArrayList<String>();
                    int pathSize = path.size();
                    for (int index = 0; index < pathSize - 1; ++index) {
                        String node = path.get(index);
                        workingPath.add(node);
                        if (!Boolean.TRUE.equals(resourceMap.get(node).getIsValidLeaf())) continue;
                        hierarchies.add(new ArrayList(workingPath));
                    }
                }
            }
            return this.convertHierarchies(hierarchies, resourceMap);
        }

        Set<List<RangerServiceDef.RangerResourceDef>> convertHierarchies(Set<List<String>> hierarchies, Map<String, RangerServiceDef.RangerResourceDef> resourceMap) {
            HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
            for (List<String> hierarchy : hierarchies) {
                ArrayList<RangerServiceDef.RangerResourceDef> resourceList = new ArrayList<RangerServiceDef.RangerResourceDef>(hierarchy.size());
                for (String name : hierarchy) {
                    RangerServiceDef.RangerResourceDef def = resourceMap.get(name);
                    resourceList.add(def);
                }
                result.add(resourceList);
            }
            return result;
        }

        Map<String, RangerServiceDef.RangerResourceDef> getResourcesAsMap(List<RangerServiceDef.RangerResourceDef> resourceList) {
            HashMap<String, RangerServiceDef.RangerResourceDef> map = new HashMap<String, RangerServiceDef.RangerResourceDef>(resourceList.size());
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceList) {
                map.put(resourceDef.getName(), resourceDef);
            }
            return map;
        }

        List<String> getAllOrderedResourceNames() {
            return this.orderedResourceNames;
        }

        Map<String, Collection<String>> getImpliedAccessGrants() {
            return this.impliedGrants;
        }

        private Map<String, Collection<String>> computeImpliedGrants() {
            HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
            if (this.servicedef != null && CollectionUtils.isNotEmpty(this.servicedef.getAccessTypes())) {
                Collection impliedAccessGrants;
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : this.servicedef.getAccessTypes()) {
                    if (!CollectionUtils.isNotEmpty(accessTypeDef.getImpliedGrants())) continue;
                    impliedAccessGrants = ret.computeIfAbsent(accessTypeDef.getName(), k -> new HashSet());
                    impliedAccessGrants.addAll(accessTypeDef.getImpliedGrants());
                }
                if (this.servicedef.getMarkerAccessTypes() != null) {
                    for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : this.servicedef.getMarkerAccessTypes()) {
                        if (!CollectionUtils.isNotEmpty(accessTypeDef.getImpliedGrants())) continue;
                        impliedAccessGrants = ret.computeIfAbsent(accessTypeDef.getName(), k -> new HashSet());
                        impliedAccessGrants.addAll(accessTypeDef.getImpliedGrants());
                    }
                }
            }
            return ret;
        }

        private List<String> buildSortedResourceNames() {
            ArrayList<String> ret = new ArrayList<String>();
            boolean isValid = true;
            ArrayList<ResourceNameLevel> resourceNameLevels = new ArrayList<ResourceNameLevel>();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.servicedef.getResources()) {
                String name = resourceDef.getName();
                Integer level = resourceDef.getLevel();
                if (name != null && level != null) {
                    ResourceNameLevel resourceNameLevel = new ResourceNameLevel(name, level);
                    resourceNameLevels.add(resourceNameLevel);
                    continue;
                }
                LOG.error("Incorrect resourceDef:[name={}]", (Object)name);
                isValid = false;
                break;
            }
            if (isValid) {
                Collections.sort(resourceNameLevels);
                for (ResourceNameLevel resourceNameLevel : resourceNameLevels) {
                    ret.add(resourceNameLevel.resourceName);
                }
            }
            return ret;
        }

        private String getDefaultRrnTemplate(RangerServiceDef.RangerResourceDef resourceDef) {
            ArrayList<RangerServiceDef.RangerResourceDef> path = new ArrayList<RangerServiceDef.RangerResourceDef>();
            RangerServiceDef.RangerResourceDef resource = resourceDef;
            while (resource != null) {
                path.add(0, resource);
                resource = this.getResourceDef(resource.getParent(), 0);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < path.size(); ++i) {
                RangerServiceDef.RangerResourceDef res = (RangerServiceDef.RangerResourceDef)path.get(i);
                if (i > 0) {
                    sb.append(StringUtils.equalsIgnoreCase((String)res.getType(), (String)"path") ? RangerServiceDefHelper.RRN_PATH_RESOURCE_SEP : RangerServiceDefHelper.RRN_RESOURCE_SEP);
                }
                sb.append(RangerServiceDefHelper.RRN_RESOURCE_PREFIX).append(res.getName()).append(RangerServiceDefHelper.RRN_RESOURCE_SUFFIX);
            }
            return sb.toString();
        }

        private static class ResourceNameLevel
        implements Comparable<ResourceNameLevel> {
            private final String resourceName;
            private final int level;

            ResourceNameLevel(String resourceName, int level) {
                this.resourceName = resourceName;
                this.level = level;
            }

            @Override
            public int compareTo(ResourceNameLevel other) {
                return Integer.compare(this.level, other.level);
            }
        }
    }
}

