/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RangerServerHealth {
    private final RangerServerStatus status;
    private final Map<String, Object> details;

    private RangerServerHealth(Builder builder) {
        this.status = builder.status;
        this.details = Collections.unmodifiableMap(builder.details);
    }

    public static Builder unknown() {
        return RangerServerHealth.status(RangerServerStatus.UNKNOWN);
    }

    public static Builder up() {
        return RangerServerHealth.status(RangerServerStatus.UP);
    }

    public static Builder down() {
        return RangerServerHealth.status(RangerServerStatus.DOWN);
    }

    public static Builder status(RangerServerStatus status) {
        return new Builder(status);
    }

    public RangerServerStatus getStatus() {
        return this.status;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.details});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangerServerHealth)) {
            return false;
        }
        RangerServerHealth health = (RangerServerHealth)o;
        return Objects.equals((Object)this.status, (Object)health.status) && Objects.equals(this.details, health.details);
    }

    public String toString() {
        return (Object)((Object)this.getStatus()) + " " + this.getDetails();
    }

    public static class Builder {
        private final Map<String, Object> details;
        private RangerServerStatus status;

        public Builder() {
            this.status = RangerServerStatus.UNKNOWN;
            this.details = new LinkedHashMap<String, Object>();
        }

        public Builder(RangerServerStatus status) {
            this.status = status;
            this.details = new LinkedHashMap<String, Object>();
        }

        public Builder(RangerServerStatus status, Map<String, ?> details) {
            this.status = status;
            this.details = new LinkedHashMap(details);
        }

        public Builder withDetail(String key, Object value) {
            this.details.put(key, value);
            return this;
        }

        public RangerServerHealth build() {
            return new RangerServerHealth(this);
        }
    }

    public static enum RangerServerStatus {
        UNKNOWN,
        INITIALIZING,
        INITIALIZATION_FAILURE,
        UP,
        DOWN;

    }
}

