/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerPolicyHeader
extends RangerBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String service;
    private String name;
    private Integer policyType;
    private String zoneName;
    private Map<String, RangerPolicy.RangerPolicyResource> resources;

    public RangerPolicyHeader(RangerPolicy rangerPolicy) {
        this.setId(rangerPolicy.getId());
        this.setGuid(rangerPolicy.getGuid());
        this.setName(rangerPolicy.getName());
        this.setResources(rangerPolicy.getResources());
        this.setIsEnabled(rangerPolicy.getIsEnabled());
        this.setService(rangerPolicy.getService());
        this.setVersion(rangerPolicy.getVersion());
        this.setPolicyType(rangerPolicy.getPolicyType());
        this.setZoneName(rangerPolicy.getZoneName());
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(Integer policyType) {
        this.policyType = policyType;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public Map<String, RangerPolicy.RangerPolicyResource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        if (this.resources == null) {
            this.resources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        }
        if (this.resources == resources) {
            return;
        }
        this.resources.clear();
        if (resources != null) {
            this.resources.putAll(resources);
        }
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("id={").append(this.getId()).append("} ");
        sb.append("guid={").append(this.getGuid()).append("} ");
        sb.append("name={").append(this.name).append("} ");
        sb.append("resources={");
        if (this.resources != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> e : this.resources.entrySet()) {
                sb.append(e.getKey()).append("={");
                e.getValue().toString(sb);
                sb.append("} ");
            }
        }
        sb.append("} ");
        sb.append("isEnabled={").append(this.getIsEnabled()).append("} ");
        sb.append("service={").append(this.service).append("} ");
        sb.append("version={").append(this.name).append("} ");
        sb.append("policyType={").append(this.policyType).append("} ");
        sb.append("zoneName={").append(this.zoneName).append("} ");
        return sb;
    }
}

