/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.geo.BinarySearchTree;
import org.apache.ranger.plugin.geo.GeolocationMetadata;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.ValuePrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerGeolocationDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(RangerGeolocationDatabase.class);
    private BinarySearchTree<RangerGeolocationData, Long> data = new BinarySearchTree();
    private GeolocationMetadata metadata = new GeolocationMetadata();

    public String getValue(RangerGeolocationData geolocationData, String attributeName) {
        String value = null;
        if (geolocationData != null && StringUtils.isNotBlank((String)attributeName)) {
            int index = this.getMetadata().getDataItemNameIndex(attributeName);
            if (index != -1) {
                String[] attrValues = geolocationData.getLocationData();
                if (index < attrValues.length) {
                    value = attrValues[index];
                } else {
                    LOG.debug("RangerGeolocationDatabase.getValue() - No value specified attribute-name:{}", (Object)attributeName);
                }
            } else {
                LOG.error("RangerGeolocationDatabase.getValue() - RangerGeolocationDatabase not initialized or Invalid attribute-name:{}", (Object)attributeName);
            }
        }
        return value;
    }

    public RangerGeolocationData find(String ipAddressStr) {
        RangerGeolocationData ret = null;
        if (StringUtils.isNotBlank((String)ipAddressStr) && RangerGeolocationData.validateAsIP(ipAddressStr, true)) {
            ret = this.data.find(RangerGeolocationData.ipAddressToLong(ipAddressStr));
        }
        return ret;
    }

    public void optimize() {
        long start = System.currentTimeMillis();
        this.data.rebalance();
        long end = System.currentTimeMillis();
        LOG.debug("RangerGeolocationDatabase.optimize() - Time taken for optimizing database = {} milliseconds", (Object)(end - start));
    }

    public GeolocationMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(GeolocationMetadata metadataArg) {
        this.metadata = metadataArg != null ? metadataArg : new GeolocationMetadata();
    }

    public BinarySearchTree<RangerGeolocationData, Long> getData() {
        return this.data;
    }

    public void setData(BinarySearchTree<RangerGeolocationData, Long> dataArg) {
        this.data = dataArg != null ? dataArg : new BinarySearchTree();
    }

    public void dump(ValuePrinter<RangerGeolocationData> processor) {
        BinarySearchTree<RangerGeolocationData, Long> geoDatabase = this.getData();
        GeolocationMetadata metadata = this.getMetadata();
        processor.build();
        processor.print("#================== Geolocation metadata ==================");
        processor.print(metadata.toString());
        processor.print("#================== Dump of geoDatabase - START ==================");
        geoDatabase.preOrderTraverseTree(processor);
        processor.print("#================== Dump of geoDatabase - END   ==================");
        processor.close();
    }
}

