/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher.externalretrievers;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.contextenricher.externalretrievers.GetFromDataFile;
import org.apache.ranger.plugin.contextenricher.externalretrievers.GetFromURL;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerRolesUtil;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMultiSourceUserStoreRetriever
extends RangerUserStoreRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerMultiSourceUserStoreRetriever.class);
    private static final Pattern PATTERN_ROLE_RETRIEVER_NAME = Pattern.compile("\\d+_role");
    private Map<String, Map<String, String>> retrieverOptions = Collections.emptyMap();
    private RangerRolesUtil rolesUtil = new RangerRolesUtil(new RangerRoles());
    private RangerAdminClient adminClient;
    private RangerUserStore userStore;

    @Override
    public void init(Map<String, String> options) {
        LOG.debug("==> init(options={})", options);
        try {
            this.retrieverOptions = this.toRetrieverOptions(options);
            if (this.hasAnyRoleRetriever()) {
                this.adminClient = this.pluginContext.createAdminClient(this.pluginConfig);
            }
        }
        catch (Exception e) {
            LOG.error("init() failed", (Throwable)e);
        }
        LOG.debug("<== init(options={})", options);
    }

    @Override
    public RangerUserStore retrieveUserStoreInfo(long lastKnownVersion, long lastActivationTimeInMillis) {
        LOG.debug("=> retrieveUserStoreInfo(lastKnownVersion={}, lastActivationTimeInMillis={})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        if (this.adminClient != null) {
            try {
                RangerRoles roles = this.rolesUtil.getRoles();
                long rolesVersion = roles.getRoleVersion() != null ? roles.getRoleVersion() : -1L;
                RangerRoles updatedRoles = this.adminClient.getRolesIfUpdated(rolesVersion, lastActivationTimeInMillis);
                if (updatedRoles != null) {
                    this.rolesUtil = new RangerRolesUtil(updatedRoles);
                }
            }
            catch (Exception e) {
                LOG.error("retrieveUserStoreInfo(lastKnownVersion={}) failed to retrieve roles", (Object)lastKnownVersion, (Object)e);
            }
        }
        Map<String, Map<String, String>> userAttrs = null;
        try {
            userAttrs = this.retrieveAll();
        }
        catch (Exception e) {
            LOG.error("retrieveUserStoreInfo(lastKnownVersion={}) failed", (Object)lastKnownVersion, (Object)e);
        }
        if (userAttrs != null) {
            LOG.debug("retrieveUserStoreInfo(lastKnownVersion={}): user-attributes={}", (Object)lastKnownVersion, userAttrs);
            this.userStore = new RangerUserStore();
            this.userStore.setUserStoreVersion(System.currentTimeMillis());
            this.userStore.setUserAttrMapping(userAttrs);
        } else {
            LOG.error("retrieveUserStoreInfo(lastKnownVersion={}): failed to retrieve user-attributes", (Object)lastKnownVersion);
        }
        LOG.debug("<== retrieveUserStoreInfo(lastKnownVersion={}, lastActivationTimeInMillis={}): ret={}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, this.userStore});
        return this.userStore;
    }

    public Map<String, Map<String, String>> retrieveUserAttrFromRoles(String retrieverName, Map<String, String> options) {
        LOG.debug("==> retrieveUserAttrFromRoles(name={}, options={})", (Object)retrieverName, options);
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        Map<String, Set<String>> userToRoles = this.rolesUtil.getUserRoleMapping();
        String attrName = options.get("attrName");
        String rolePrefix = attrName + ".";
        Pattern pattern = Pattern.compile("^.*" + rolePrefix + ".*$");
        for (Map.Entry<String, Set<String>> entry : userToRoles.entrySet()) {
            String user = entry.getKey();
            Set<String> roles = entry.getValue();
            ArrayList<String> attrValues = new ArrayList<String>();
            for (String role : roles) {
                Matcher matcher = pattern.matcher(role);
                if (!matcher.find()) continue;
                String value = matcher.group().replace(rolePrefix, "");
                attrValues.add(value);
            }
            if (attrValues.isEmpty()) continue;
            HashMap<String, String> userAttrs = new HashMap<String, String>();
            userAttrs.put(attrName, String.join((CharSequence)",", attrValues));
            ret.put(user, userAttrs);
        }
        LOG.debug("<== retrieveUserAttrFromRoles(name={}, options={}): ret={}", new Object[]{retrieverName, options, ret});
        return ret;
    }

    private Map<String, Map<String, String>> toRetrieverOptions(Map<String, String> enricherOptions) throws Exception {
        LOG.debug("==> toRetrieverOptions({})", enricherOptions);
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : enricherOptions.entrySet()) {
            String retrieverName = entry.getKey();
            if (!retrieverName.startsWith("retriever")) continue;
            String retrieverOptions = entry.getValue();
            ret.put(retrieverName, this.toRetrieverOptions(retrieverName, retrieverOptions));
        }
        LOG.debug("<== toRetrieverOptions({}): ret={}", enricherOptions, ret);
        return ret;
    }

    private Map<String, String> toRetrieverOptions(String name, String options) throws Exception {
        LOG.debug("==> toRetrieverOptions(name={}, options={})", (Object)name, (Object)options);
        Properties prop = new Properties();
        options = options.replaceAll("\\s", "");
        options = options.replaceAll(",", "\n");
        try {
            prop.load(new StringReader(options));
        }
        catch (Exception e) {
            LOG.error("toRetrieverOptions(name={}, options={}): failed to parse retriever options", new Object[]{name, options, e});
            throw new Exception(name + ": failed to parse retriever options: " + options, e);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String key : prop.stringPropertyNames()) {
            ret.put(key, prop.getProperty(key));
        }
        LOG.debug("<== toRetrieverOptions(name={}, options={}): ret={}", new Object[]{name, options, ret});
        return ret;
    }

    private boolean hasAnyRoleRetriever() {
        LOG.debug("==> hasAnyRoleRetriever()");
        boolean ret = false;
        for (String retrieverName : this.retrieverOptions.keySet()) {
            Matcher matcher = PATTERN_ROLE_RETRIEVER_NAME.matcher(retrieverName);
            if (!matcher.find()) continue;
            ret = true;
            break;
        }
        LOG.debug("<== hasAnyRoleRetriever(): ret={}", (Object)ret);
        return ret;
    }

    private Map<String, Map<String, String>> retrieveAll() throws Exception {
        LOG.debug("==> retrieveAll()");
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : this.retrieverOptions.entrySet()) {
            Map<String, Map<String, String>> userAttrs;
            String source;
            String name = entry.getKey();
            Map<String, String> options = entry.getValue();
            switch (source = name.replaceAll("\\w+_", "")) {
                case "api": {
                    userAttrs = this.retrieveUserAttributes(name, options);
                    break;
                }
                case "role": {
                    userAttrs = this.retrieveUserAttrFromRoles(name, options);
                    break;
                }
                default: {
                    throw new Exception("unrecognized retriever source '" + source + "'. Valid values: api, role");
                }
            }
            this.mergeUserAttributes(userAttrs, ret);
        }
        LOG.debug("<== retrieveAll(): ret={}", ret);
        return ret;
    }

    private Map<String, Map<String, String>> retrieveUserAttributes(String retrieverName, Map<String, String> options) throws Exception {
        Map<String, Map<String, String>> ret;
        LOG.debug("==> retrieveUserAttributes(name={}, options={})", (Object)retrieverName, options);
        String attrName = options.get("attrName");
        String url = options.get("userStoreURL");
        String dataFile = options.get("dataFile");
        if (attrName == null) {
            throw new Exception(retrieverName + ": attrName must be specified in retriever options");
        }
        if (url == null && dataFile == null) {
            throw new Exception(retrieverName + ": url or dataFile must be specified in retriever options");
        }
        if (url != null) {
            GetFromURL gu = new GetFromURL();
            String configFile = options.getOrDefault("configFile", "/var/ranger/security/" + attrName + ".conf");
            LOG.debug("{}: configFile={}", (Object)retrieverName, (Object)configFile);
            ret = gu.getFromURL(url, configFile);
            LOG.debug("loaded attribute {} from URL {}: {}", new Object[]{attrName, url, ret});
        } else {
            GetFromDataFile gf = new GetFromDataFile();
            ret = gf.getFromDataFile(dataFile, attrName);
            LOG.debug("loaded attribute {} from file {}: {}", new Object[]{attrName, dataFile, ret});
        }
        LOG.debug("<== retrieveUserAttributes(name={}, options={}): ret={}", new Object[]{retrieverName, options, ret});
        return ret;
    }

    private void mergeUserAttributes(Map<String, Map<String, String>> source, Map<String, Map<String, String>> dest) {
        if (dest.isEmpty()) {
            dest.putAll(source);
        } else {
            for (Map.Entry<String, Map<String, String>> e : source.entrySet()) {
                String userName = e.getKey();
                Map<String, String> userAttrs = e.getValue();
                if (dest.containsKey(userName)) {
                    Map<String, String> existingAttrs = dest.get(userName);
                    existingAttrs.putAll(userAttrs);
                    continue;
                }
                dest.put(userName, userAttrs);
            }
        }
    }
}

