/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher.externalretrievers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFromURL {
    private static final Logger LOG = LoggerFactory.getLogger(GetFromURL.class);

    public Map<String, Map<String, String>> getFromURL(String url, String configFile) throws Exception {
        Map<String, Map<String, String>> ret;
        LOG.debug("==> getFromURL(url={}, configFile={})", (Object)url, (Object)configFile);
        String token = this.getBearerToken(configFile);
        HttpUriRequest request = RequestBuilder.get().setUri(url).setHeader("Authorization", token).setHeader("Content-Type", "text/plain").build();
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute(request);){
            if (response == null) {
                throw new IOException("getFromURL(" + url + ") failed: null response");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("getFromURL(" + url + ") failed: http status=" + response.getStatusLine());
            }
            HttpEntity httpEntity = response.getEntity();
            String stringResult = EntityUtils.toString((HttpEntity)httpEntity);
            Map resultMap = JsonUtils.jsonToObject(stringResult, Map.class);
            Map userAttrValues = (Map)resultMap.get("body");
            ret = this.toUserAttributes(userAttrValues);
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        LOG.debug("<== getFromURL(url={}, configFile={}): ret={}", new Object[]{url, configFile, ret});
        return ret;
    }

    private String getBearerToken(String configFile) throws Exception {
        String ret;
        String secrets = this.getSecretsFromFile(configFile);
        JsonNode jsonObject = JsonUtils.getMapper().readTree(secrets);
        String tokenURL = jsonObject.get("tokenUrl").asText();
        List headers = (List)JsonUtils.getMapper().convertValue((Object)jsonObject.get("headers"), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        List params = (List)JsonUtils.getMapper().convertValue((Object)jsonObject.get("params"), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        ArrayList<BasicNameValuePair> nvPairs = new ArrayList<BasicNameValuePair>();
        HttpPost httpPost = new HttpPost(tokenURL);
        for (Map header : headers) {
            for (Map.Entry e : header.entrySet()) {
                httpPost.setHeader((String)e.getKey(), (String)e.getValue());
            }
        }
        for (Map param : params) {
            for (Map.Entry e : param.entrySet()) {
                nvPairs.add(new BasicNameValuePair((String)e.getKey(), (String)e.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvPairs, StandardCharsets.UTF_8));
        CloseableHttpClient httpClient = HttpClients.createDefault();
        Object object = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            if (response == null) {
                throw new IOException("getBearerToken(" + configFile + ") failed: null response");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("getBearerToken(" + configFile + ") failed: http status=" + response.getStatusLine());
            }
            HttpEntity httpEntity = response.getEntity();
            String stringResult = EntityUtils.toString((HttpEntity)httpEntity);
            Map resultMap = JsonUtils.jsonToObject(stringResult, Map.class);
            String token = resultMap.get("access_token").toString();
            ret = "Bearer " + token;
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (httpClient != null) {
                if (object != null) {
                    try {
                        httpClient.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    httpClient.close();
                }
            }
        }
        return ret;
    }

    private Map<String, Map<String, String>> toUserAttributes(Map<String, Map<String, List<String>>> userAttrValues) {
        LOG.debug("==> toUserAttributes(userAttrValues={})", userAttrValues);
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, List<String>>> userEntry : userAttrValues.entrySet()) {
            String user = userEntry.getKey();
            Map<String, List<String>> attrValues = userEntry.getValue();
            HashMap<String, String> userAttrs = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> attrEntry : attrValues.entrySet()) {
                String attrName = attrEntry.getKey();
                List<String> values = attrEntry.getValue();
                userAttrs.put(attrName, String.join((CharSequence)",", values));
            }
            ret.put(user, userAttrs);
        }
        LOG.debug("<== toUserAttributes(userAttrValues={}): ret={}", userAttrValues, ret);
        return ret;
    }

    private String getSecretsFromFile(String configFile) throws IOException {
        String ret = this.decodeSecrets(new String(Files.readAllBytes(Paths.get(configFile, new String[0]))));
        this.verifyToken(ret);
        return ret;
    }

    private String decodeSecrets(String encodedSecrets) {
        return new String(Base64.getDecoder().decode(encodedSecrets));
    }

    private void verifyToken(String secrets) throws IOException {
        String errorMessage = "";
        JsonNode jsonObject = JsonUtils.getMapper().readTree(secrets);
        if (jsonObject.get("tokenUrl") == null) {
            errorMessage = errorMessage + "tokenUrl must be specified in the config file; ";
        }
        if (jsonObject.get("headers") == null) {
            errorMessage = errorMessage + "headers must be specified in the config file; ";
        } else {
            JsonNode headers = jsonObject.get("headers");
            for (JsonNode header : headers) {
                if (!header.has("Content-Type") || StringUtils.equalsIgnoreCase((String)header.get("Content-Type").textValue(), (String)"application/x-www-form-urlencoded")) continue;
                errorMessage = errorMessage + "Content-Type, if specified, must be \"application/x-www-form-urlencoded\"; ";
            }
        }
        if (jsonObject.get("params") == null) {
            errorMessage = errorMessage + "params must be specified in the config file; ";
        }
        if (!errorMessage.isEmpty()) {
            throw new IOException(errorMessage);
        }
    }
}

