/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.RangerGeolocationDatabase;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.store.GeolocationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAbstractGeolocationProvider
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAbstractGeolocationProvider.class);
    public static final String ENRICHER_OPTION_GEOLOCATION_META_PREFIX = "geolocation.meta.prefix";
    public static final String KEY_CONTEXT_GEOLOCATION_PREFIX = "LOCATION_";
    private GeolocationStore store;
    private String geoMetaPrefix;

    public abstract String getGeoSourceLoader();

    @Override
    public void init() {
        LOG.debug("==> RangerAbstractGeolocationProvider.init()");
        super.init();
        this.geoMetaPrefix = this.getOption(ENRICHER_OPTION_GEOLOCATION_META_PREFIX);
        if (this.geoMetaPrefix == null) {
            this.geoMetaPrefix = "";
        }
        GeolocationStore geoStore = null;
        Map<String, String> context = this.enricherDef.getEnricherOptions();
        if (context != null) {
            String geoSourceLoader = this.getGeoSourceLoader();
            try {
                Class<?> geoSourceLoaderClass = Class.forName(geoSourceLoader);
                geoStore = (GeolocationStore)geoSourceLoaderClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error("RangerAbstractGeolocationProvider.init() - Class {} not found, exception={}", (Object)geoSourceLoader, (Object)exception.toString());
            }
            catch (ClassCastException exception) {
                LOG.error("RangerAbstractGeolocationProvider.init() - Class {} is not a type of GeolocationStore, exception={}", (Object)geoSourceLoader, (Object)exception.toString());
            }
            catch (IllegalAccessException | InstantiationException exception) {
                LOG.error("RangerAbstractGeolocationProvider.init() - Class {} could not be instantiated, exception={}", (Object)geoSourceLoader, (Object)exception.toString());
            }
            if (geoStore != null) {
                try {
                    geoStore.init(context);
                    this.store = geoStore;
                }
                catch (Exception exception) {
                    LOG.error("RangerAbstractGeolocationProvider.init() - geoLocation Store cannot be initialized, exception={}", (Object)exception.toString());
                }
            }
        }
        if (this.store == null) {
            LOG.error("RangerAbstractGeolocationProvider.init() - is not initialized correctly.");
        }
        LOG.debug("<== RangerAbstractGeolocationProvider.init()");
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        LOG.debug("==> RangerAbstractGeolocationProvider.enrich({})", (Object)request);
        String clientIPAddress = request.getClientIPAddress();
        LOG.debug("RangerAbstractGeolocationProvider.enrich() - clientIPAddress={}", (Object)clientIPAddress);
        if (StringUtils.isNotBlank((String)clientIPAddress) && this.store != null) {
            RangerGeolocationData geolocation = this.store.getGeoLocation(clientIPAddress);
            if (geolocation != null) {
                LOG.debug("RangerAbstractGeolocationProvider.enrich() - Country={}", (Object)geolocation);
                Map<String, Object> context = request.getContext();
                String[] geoAttrValues = geolocation.getLocationData();
                RangerGeolocationDatabase database = this.store.getGeoDatabase();
                String[] attributeNames = database.getMetadata().getLocationDataItemNames();
                for (int i = 0; i < geoAttrValues.length && i < attributeNames.length; ++i) {
                    String contextName = KEY_CONTEXT_GEOLOCATION_PREFIX + this.geoMetaPrefix + attributeNames[i];
                    context.put(contextName, geoAttrValues[i]);
                }
            } else {
                LOG.debug("RangerAbstractGeolocationProvider.enrich() - clientIPAddress '{}' not found.", (Object)clientIPAddress);
            }
        } else {
            LOG.debug("RangerAbstractGeolocationProvider.enrich() - clientIPAddress is null or blank, cannot get geolocation");
        }
        LOG.debug("<== RangerAbstractGeolocationProvider.enrich({})", (Object)request);
    }
}

