/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerIpMatcher
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerIpMatcher.class);
    static final Pattern allWildcards = Pattern.compile("^((\\*(\\.\\*)*)|(\\*(:\\*)*))$");
    static final Pattern trailingWildcardsIp4 = Pattern.compile("(\\.\\*)+$");
    static final Pattern trailingWildcardsIp6 = Pattern.compile("(:\\*)+$");
    private final List<String> exactIps = new ArrayList<String>();
    private final List<String> wildCardIps = new ArrayList<String>();
    private boolean allowAny;

    @Override
    public void init() {
        LOG.debug("==> RangerIpMatcher.init({})", (Object)this.condition);
        super.init();
        if (this.condition == null) {
            LOG.debug("init: null policy condition! Will match always!");
            this.allowAny = true;
        } else if (CollectionUtils.isEmpty(this.condition.getValues())) {
            LOG.debug("init: empty conditions collection on policy condition!  Will match always!");
            this.allowAny = true;
        } else if (this.condition.getValues().contains("*")) {
            this.allowAny = true;
            LOG.debug("init: wildcard value found.  Will match always.");
        } else {
            for (String ip : this.condition.getValues()) {
                String digestedIp = this.digestPolicyIp(ip);
                if (digestedIp.isEmpty()) {
                    LOG.debug("init: digested ip was empty! Will match always");
                    this.allowAny = true;
                    continue;
                }
                if (digestedIp.equals(ip)) {
                    this.exactIps.add(ip);
                    continue;
                }
                this.wildCardIps.add(digestedIp);
            }
        }
        LOG.debug("<== RangerIpMatcher.init({}): exact-ips[{}], wildcard-ips[{}]", new Object[]{this.condition, this.exactIps, this.wildCardIps});
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        LOG.debug("==> RangerIpMatcher.isMatched({})", (Object)request);
        boolean ipMatched = true;
        if (this.allowAny) {
            LOG.debug("isMatched: allowAny flag is true.  Matched!");
        } else {
            String requestIp = this.extractIp(request);
            if (requestIp == null) {
                LOG.debug("isMatched: couldn't get ip address from request.  Ok.  Implicitly matched!");
            } else {
                ipMatched = this.isWildcardMatched(this.wildCardIps, requestIp) || this.isExactlyMatched(this.exactIps, requestIp);
            }
        }
        LOG.debug("<== RangerIpMatcher.isMatched({}): {}", (Object)request, (Object)ipMatched);
        return ipMatched;
    }

    String digestPolicyIp(String policyIp) {
        String result;
        LOG.debug("==> RangerIpMatcher.digestPolicyIp({})", (Object)policyIp);
        Matcher matcher = allWildcards.matcher(policyIp);
        if (matcher.matches()) {
            LOG.debug("digestPolicyIp: policyIP[{}] all wildcards.", (Object)policyIp);
            result = "";
        } else if (policyIp.contains(".")) {
            matcher = trailingWildcardsIp4.matcher(policyIp);
            result = matcher.replaceFirst(".");
        } else {
            matcher = trailingWildcardsIp6.matcher(policyIp);
            result = matcher.replaceFirst(":").toLowerCase();
        }
        LOG.debug("<== RangerIpMatcher.digestPolicyIp({}): {}", (Object)policyIp, (Object)result);
        return result;
    }

    boolean isWildcardMatched(List<String> ips, String requestIp) {
        LOG.debug("==> RangerIpMatcher.isWildcardMatched({}, {})", ips, (Object)requestIp);
        boolean matchFound = false;
        Iterator<String> iterator = ips.iterator();
        while (iterator.hasNext() && !matchFound) {
            String ip = iterator.next();
            if (requestIp.contains(".") && requestIp.startsWith(ip)) {
                LOG.debug("Wildcard Policy IP[{}] matches request IPv4[{}].", (Object)ip, (Object)requestIp);
                matchFound = true;
                continue;
            }
            if (requestIp.toLowerCase().startsWith(ip)) {
                LOG.debug("Wildcard Policy IP[{}] matches request IPv6[{}].", (Object)ip, (Object)requestIp);
                matchFound = true;
                continue;
            }
            LOG.debug("Wildcard policy IP[{}] did not match request IP[{}].", (Object)ip, (Object)requestIp);
        }
        LOG.debug("<== RangerIpMatcher.isWildcardMatched({}, {}): {}", new Object[]{ips, requestIp, matchFound});
        return matchFound;
    }

    boolean isExactlyMatched(List<String> ips, String requestIp) {
        LOG.debug("==> RangerIpMatcher.isExactlyMatched({}, {})", ips, (Object)requestIp);
        boolean matchFound = requestIp.contains(".") ? ips.contains(requestIp) : ips.contains(requestIp.toLowerCase());
        LOG.debug("<== RangerIpMatcher.isExactlyMatched({}, {}): {}", new Object[]{ips, requestIp, matchFound});
        return matchFound;
    }

    String extractIp(RangerAccessRequest request) {
        LOG.debug("==> RangerIpMatcher.extractIp({})", (Object)request);
        String ip = null;
        if (request == null) {
            LOG.debug("isMatched: Unexpected: null request object!");
        } else {
            ip = request.getClientIPAddress();
            if (ip == null) {
                LOG.debug("isMatched: Unexpected: Client ip in request object is null!");
            }
        }
        LOG.debug("<== RangerIpMatcher.extractIp({}): {}", (Object)request, (Object)ip);
        return ip;
    }
}

