/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.client.HadoopConfigHolder;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(BaseClient.class);
    protected static final String DEFAULT_ERROR_MESSAGE = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private static final String DEFAULT_NAME_RULE = "DEFAULT";
    protected Map<String, String> connectionProperties;
    private final String serviceName;
    private final String defaultConfigFile;
    private Subject loginSubject;
    private HadoopConfigHolder configHolder;

    public BaseClient(String svcName, Map<String, String> connectionProperties) {
        this(svcName, connectionProperties, null);
    }

    public BaseClient(String serviceName, Map<String, String> connectionProperties, String defaultConfigFile) {
        this.serviceName = serviceName;
        this.connectionProperties = connectionProperties;
        this.defaultConfigFile = defaultConfigFile;
        this.init();
        this.login();
    }

    public static void generateResponseDataMap(boolean connectivityStatus, String message, String description, Long objectId, String fieldName, Map<String, Object> responseData) {
        responseData.put("connectivityStatus", connectivityStatus);
        responseData.put("message", message);
        responseData.put("description", description);
        responseData.put("objectId", objectId);
        responseData.put("fieldName", fieldName);
    }

    public static String getMessage(Throwable excp) {
        ArrayList<String> errList = new ArrayList<String>();
        while (excp != null) {
            String message = excp.getMessage();
            if (StringUtils.isNotEmpty((String)message) && !errList.contains(message + ". \n")) {
                errList.add(message + ". \n");
            }
            excp = excp.getCause();
        }
        return StringUtils.join(errList, (String)"");
    }

    public String getSerivceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void login() {
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            String lookupPrincipal = SecureClientLogin.getPrincipal(this.configHolder.getLookupPrincipal(), InetAddress.getLocalHost().getCanonicalHostName());
            String lookupKeytab = this.configHolder.getLookupKeytab();
            String nameRules = this.configHolder.getNameRules();
            if (StringUtils.isEmpty((String)nameRules)) {
                LOG.debug("Name Rule is empty. Setting Name Rule as 'DEFAULT'");
                nameRules = DEFAULT_NAME_RULE;
            }
            String userName = this.configHolder.getUserName();
            if (StringUtils.isEmpty((String)lookupPrincipal) || StringUtils.isEmpty((String)lookupKeytab)) {
                if (userName == null) {
                    throw this.createException("Unable to find login username for hadoop environment, [" + this.serviceName + "]", null);
                }
                String keyTabFile = this.configHolder.getKeyTabFile();
                if (keyTabFile != null) {
                    if (this.configHolder.isKerberosAuthentication()) {
                        LOG.info("Init Login: security enabled, using username/keytab");
                        this.loginSubject = SecureClientLogin.loginUserFromKeytab(userName, keyTabFile, nameRules);
                    } else {
                        LOG.info("Init Login: using username");
                        this.loginSubject = SecureClientLogin.login(userName);
                    }
                } else {
                    String encryptedPwd = this.configHolder.getPassword();
                    String password = null;
                    if (encryptedPwd != null) {
                        try {
                            password = PasswordUtils.decryptPassword(encryptedPwd);
                        }
                        catch (Exception ex) {
                            LOG.info("Password decryption failed; trying connection with received password string");
                            password = null;
                        }
                        finally {
                            if (password == null) {
                                password = encryptedPwd;
                            }
                        }
                    } else {
                        LOG.info("Password decryption failed: no password was configured");
                    }
                    if (this.configHolder.isKerberosAuthentication()) {
                        LOG.info("Init Login: using username/password");
                        this.loginSubject = SecureClientLogin.loginUserWithPassword(userName, password);
                    } else {
                        LOG.info("Init Login: security not enabled, using username");
                        this.loginSubject = SecureClientLogin.login(userName);
                    }
                }
            } else if (this.configHolder.isKerberosAuthentication()) {
                LOG.info("Init Lookup Login: security enabled, using lookupPrincipal/lookupKeytab");
                this.loginSubject = SecureClientLogin.loginUserFromKeytab(lookupPrincipal, lookupKeytab, nameRules);
            } else {
                LOG.info("Init Login: security not enabled, using username");
                this.loginSubject = SecureClientLogin.login(userName);
            }
        }
        catch (IOException | SecurityException ex) {
            throw this.createException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    protected Subject getLoginSubject() {
        return this.loginSubject;
    }

    protected HadoopConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    private void init() {
        this.configHolder = this.connectionProperties == null ? HadoopConfigHolder.getInstance(this.serviceName) : HadoopConfigHolder.getInstance(this.serviceName, this.connectionProperties, this.defaultConfigFile);
    }

    private HadoopException createException(Exception exp) {
        return this.createException("Unable to login to Hadoop environment [" + this.serviceName + "]", exp);
    }

    private HadoopException createException(String msgDesc, Exception exp) {
        HadoopException hdpException = new HadoopException(msgDesc, exp);
        String fullDescription = exp != null ? BaseClient.getMessage(exp) : msgDesc;
        hdpException.generateResponseDataMap(false, fullDescription + DEFAULT_ERROR_MESSAGE, msgDesc + DEFAULT_ERROR_MESSAGE, null, null);
        return hdpException;
    }
}

