/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultAuditHandler
implements RangerAccessResultProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultAuditHandler.class);
    private static final String CONF_AUDIT_ID_STRICT_UUID = "xasecure.audit.auditid.strict.uuid";
    private static final boolean DEFAULT_AUDIT_ID_STRICT_UUID = false;
    protected final String moduleName;
    private final boolean auditIdStrictUUID;
    private long sequenceNumber;
    private final RangerRESTUtils restUtils = new RangerRESTUtils();
    private String uuid = MiscUtil.generateUniqueId();
    private AtomicInteger counter = new AtomicInteger(0);

    public RangerDefaultAuditHandler() {
        this.auditIdStrictUUID = false;
        this.moduleName = "ranger-acl";
    }

    public RangerDefaultAuditHandler(Configuration config) {
        this.auditIdStrictUUID = config.getBoolean(CONF_AUDIT_ID_STRICT_UUID, false);
        this.moduleName = config.get("xasecure.auditlog.xasecureAcl.name", "ranger-acl");
    }

    @Override
    public void processResult(RangerAccessResult result) {
        LOG.debug("==> RangerDefaultAuditHandler.processResult({})", (Object)result);
        AuthzAuditEvent event = this.getAuthzEvents(result);
        this.logAuthzAudit(event);
        LOG.debug("<== RangerDefaultAuditHandler.processResult({})", (Object)result);
    }

    @Override
    public void processResults(Collection<RangerAccessResult> results) {
        LOG.debug("==> RangerDefaultAuditHandler.processResults({})", results);
        Collection<AuthzAuditEvent> events = this.getAuthzEvents(results);
        if (events != null) {
            this.logAuthzAudits(events);
        }
        LOG.debug("<== RangerDefaultAuditHandler.processResults({})", results);
    }

    public AuthzAuditEvent getAuthzEvents(RangerAccessResult result) {
        RangerAccessRequest request;
        LOG.debug("==> RangerDefaultAuditHandler.getAuthzEvents({})", (Object)result);
        AuthzAuditEvent ret = null;
        RangerAccessRequest rangerAccessRequest = request = result != null ? result.getAccessRequest() : null;
        if (request != null && result.getIsAudited()) {
            RangerAccessResource resource = request.getResource();
            String resourceType = resource == null ? null : resource.getLeafName();
            String resourcePath = resource == null ? null : resource.getAsString();
            ret = this.createAuthzAuditEvent();
            ret.setRepositoryName(result.getServiceName());
            ret.setRepositoryType(result.getServiceType());
            ret.setResourceType(resourceType);
            ret.setResourcePath(resourcePath);
            ret.setRequestData(request.getRequestData());
            ret.setEventTime(request.getAccessTime() != null ? request.getAccessTime() : new Date());
            ret.setUser(request.getUser());
            ret.setAction(request.getAccessType());
            ret.setAccessResult((short)(result.getIsAllowed() ? 1 : 0));
            ret.setPolicyId(result.getPolicyId());
            ret.setAccessType(request.getAction());
            ret.setClientIP(request.getClientIPAddress());
            ret.setClientType(request.getClientType());
            ret.setSessionId(request.getSessionId());
            ret.setAclEnforcer(this.moduleName);
            Set<String> tags = this.getTags(request);
            if (tags != null) {
                ret.setTags(tags);
            }
            ret.setDatasets(this.getDatasets(request));
            ret.setProjects(this.getProjects(request));
            ret.setAdditionalInfo(this.getAdditionalInfo(request));
            ret.setClusterName(request.getClusterName());
            ret.setZoneName(result.getZoneName());
            ret.setAgentHostname(this.restUtils.getAgentHostname());
            ret.setPolicyVersion(result.getPolicyVersion());
            this.populateDefaults(ret);
            result.setAuditLogId(ret.getEventId());
        }
        LOG.debug("<== RangerDefaultAuditHandler.getAuthzEvents({}): {}", (Object)result, ret);
        return ret;
    }

    public Collection<AuthzAuditEvent> getAuthzEvents(Collection<RangerAccessResult> results) {
        LOG.debug("==> RangerDefaultAuditHandler.getAuthzEvents({})", results);
        ArrayList<AuthzAuditEvent> ret = null;
        if (results != null) {
            for (RangerAccessResult result : results) {
                AuthzAuditEvent event = this.getAuthzEvents(result);
                if (event == null) continue;
                if (ret == null) {
                    ret = new ArrayList<AuthzAuditEvent>();
                }
                ret.add(event);
            }
        }
        LOG.debug("<== RangerDefaultAuditHandler.getAuthzEvents({}): {}", results, ret);
        return ret;
    }

    public void logAuthzAudit(AuthzAuditEvent auditEvent) {
        LOG.debug("==> RangerDefaultAuditHandler.logAuthzAudit({})", (Object)auditEvent);
        if (auditEvent != null) {
            this.populateDefaults(auditEvent);
            AuditHandler auditProvider = RangerBasePlugin.getAuditProvider(auditEvent.getRepositoryName());
            if (auditProvider == null || !auditProvider.log((AuditEventBase)auditEvent)) {
                MiscUtil.logErrorMessageByInterval((Logger)LOG, (String)("fail to log audit event " + auditEvent));
            }
        }
        LOG.debug("<== RangerDefaultAuditHandler.logAuthzAudit({})", (Object)auditEvent);
    }

    public void logAuthzAudits(Collection<AuthzAuditEvent> auditEvents) {
        LOG.debug("==> RangerDefaultAuditHandler.logAuthzAudits({})", auditEvents);
        if (auditEvents != null) {
            for (AuthzAuditEvent auditEvent : auditEvents) {
                this.logAuthzAudit(auditEvent);
            }
        }
        LOG.debug("<== RangerDefaultAuditHandler.logAuthzAudits({})", auditEvents);
    }

    public AuthzAuditEvent createAuthzAuditEvent() {
        return new AuthzAuditEvent();
    }

    public final Set<String> getDatasets(RangerAccessRequest request) {
        GdsAccessResult gdsResult = RangerAccessRequestUtil.getGdsResultFromContext(request.getContext());
        return gdsResult != null ? gdsResult.getDatasets() : null;
    }

    public final Set<String> getProjects(RangerAccessRequest request) {
        GdsAccessResult gdsResult = RangerAccessRequestUtil.getGdsResultFromContext(request.getContext());
        return gdsResult != null ? gdsResult.getProjects() : null;
    }

    public String getAdditionalInfo(RangerAccessRequest request) {
        if (StringUtils.isBlank((String)request.getRemoteIPAddress()) && CollectionUtils.isEmpty(request.getForwardedAddresses())) {
            return null;
        }
        HashMap<String, String> addInfomap = new HashMap<String, String>();
        addInfomap.put("forwarded-ip-addresses", "[" + StringUtils.join(request.getForwardedAddresses(), (String)", ") + "]");
        addInfomap.put("remote-ip-address", request.getRemoteIPAddress());
        return JsonUtils.mapToJson(addInfomap);
    }

    protected final Set<String> getTags(RangerAccessRequest request) {
        HashSet<String> ret = null;
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (CollectionUtils.isNotEmpty(tags)) {
            ret = new HashSet<String>();
            for (RangerTagForEval tag : tags) {
                ret.add(this.writeObjectAsString(tag));
            }
        }
        return ret;
    }

    private void populateDefaults(AuthzAuditEvent auditEvent) {
        if (auditEvent.getAclEnforcer() == null || auditEvent.getAclEnforcer().isEmpty()) {
            auditEvent.setAclEnforcer("ranger-acl");
        }
        if (auditEvent.getAgentHostname() == null || auditEvent.getAgentHostname().isEmpty()) {
            auditEvent.setAgentHostname(MiscUtil.getHostname());
        }
        if (auditEvent.getLogType() == null || auditEvent.getLogType().isEmpty()) {
            auditEvent.setLogType("RangerAudit");
        }
        if (auditEvent.getEventId() == null || auditEvent.getEventId().isEmpty()) {
            auditEvent.setEventId(this.generateNextAuditEventId());
        }
        if (auditEvent.getAgentId() == null) {
            auditEvent.setAgentId(MiscUtil.getApplicationType());
        }
        auditEvent.setSeqNum(this.sequenceNumber++);
    }

    private String generateNextAuditEventId() {
        String ret;
        if (this.auditIdStrictUUID) {
            ret = MiscUtil.generateGuid();
        } else {
            int nextId = this.counter.getAndIncrement();
            if (nextId == Integer.MAX_VALUE) {
                this.uuid = MiscUtil.generateUniqueId();
                this.counter = new AtomicInteger(0);
            }
            ret = this.uuid + "-" + nextId;
        }
        LOG.debug("generateNextAuditEventId(): {}", (Object)ret);
        return ret;
    }

    private String writeObjectAsString(Serializable obj) {
        String jsonStr = "";
        try {
            jsonStr = JsonUtilsV2.objToJson(obj);
        }
        catch (Exception e) {
            LOG.error("Cannot create JSON string for object:[{}]", (Object)obj, (Object)e);
        }
        return jsonStr;
    }
}

