/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.hadoop.config.RangerLegacyConfigBuilder;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginConfig
extends RangerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginConfig.class);
    private static final char RANGER_TRUSTED_PROXY_IPADDRESSES_SEPARATOR_CHAR = ',';
    private final String serviceType;
    private final String serviceName;
    private final String appId;
    private final String clusterName;
    private final String clusterType;
    private final RangerPolicyEngineOptions policyEngineOptions;
    private final boolean useForwardedIPAddress;
    private final String[] trustedProxyAddresses;
    private final String propertyPrefix;
    private final boolean useRangerGroups;
    private final boolean useOnlyRangerGroups;
    private final boolean convertEmailToUsername;
    private final boolean enableImplicitUserStoreEnricher;
    private final boolean enableImplicitGdsInfoEnricher;
    private boolean isFallbackSupported;
    private Set<String> auditExcludedUsers = Collections.emptySet();
    private Set<String> auditExcludedGroups = Collections.emptySet();
    private Set<String> auditExcludedRoles = Collections.emptySet();
    private Set<String> superUsers = new HashSet<String>();
    private Set<String> superGroups = Collections.emptySet();
    private Set<String> serviceAdmins = Collections.emptySet();

    public RangerPluginConfig(String serviceType, String serviceName, String appId, String clusterName, String clusterType, RangerPolicyEngineOptions policyEngineOptions) {
        this(serviceType, serviceName, appId, clusterName, clusterType, null, policyEngineOptions);
    }

    public RangerPluginConfig(String serviceType, String serviceName, String appId, String clusterName, String clusterType, List<File> additionalConfigFiles, RangerPolicyEngineOptions policyEngineOptions) {
        this.addResourcesForServiceType(serviceType);
        this.serviceType = serviceType;
        this.appId = StringUtils.isEmpty((String)appId) ? serviceType : appId;
        this.propertyPrefix = "ranger.plugin." + serviceType;
        this.serviceName = StringUtils.isEmpty((String)serviceName) ? this.get(this.propertyPrefix + ".service.name") : serviceName;
        this.addResourcesForServiceName(this.serviceType, this.serviceName);
        if (additionalConfigFiles != null) {
            for (File configFile : additionalConfigFiles) {
                try {
                    this.addResource(configFile.toURI().toURL());
                }
                catch (Throwable t) {
                    LOG.warn("failed to load configurations from {}", (Object)configFile, (Object)t);
                }
            }
        }
        String trustedProxyAddressString = this.get(this.propertyPrefix + ".trusted.proxy.ipaddresses");
        if (StringUtil.isEmpty(clusterName) && StringUtil.isEmpty(clusterName = this.get(this.propertyPrefix + ".access.cluster.name", ""))) {
            clusterName = this.get(this.propertyPrefix + ".ambari.cluster.name", "");
        }
        if (StringUtil.isEmpty(clusterType) && StringUtil.isEmpty(clusterType = this.get(this.propertyPrefix + ".access.cluster.type", ""))) {
            clusterType = this.get(this.propertyPrefix + ".ambari.cluster.type", "");
        }
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.useForwardedIPAddress = this.getBoolean(this.propertyPrefix + ".use.x-forwarded-for.ipaddress", false);
        this.trustedProxyAddresses = StringUtils.split((String)trustedProxyAddressString, (char)',');
        if (this.trustedProxyAddresses != null) {
            for (int i = 0; i < this.trustedProxyAddresses.length; ++i) {
                this.trustedProxyAddresses[i] = this.trustedProxyAddresses[i].trim();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.use.x-forwarded-for.ipaddress:{}", (Object)this.propertyPrefix, (Object)this.useForwardedIPAddress);
            LOG.debug("{}.trusted.proxy.ipaddresses:[{}]", (Object)this.propertyPrefix, (Object)StringUtils.join((Object[])this.trustedProxyAddresses, (String)", "));
        }
        if (this.useForwardedIPAddress && StringUtils.isBlank((String)trustedProxyAddressString)) {
            LOG.warn("Property {}.use.x-forwarded-for.ipaddress is set to true, and Property {}.trusted.proxy.ipaddresses is not set", (Object)this.propertyPrefix, (Object)this.propertyPrefix);
            LOG.warn("Ranger plugin will trust RemoteIPAddress and treat first X-Forwarded-Address in the access-request as the clientIPAddress");
        }
        if (policyEngineOptions == null) {
            policyEngineOptions = new RangerPolicyEngineOptions();
            policyEngineOptions.configureForPlugin(this, this.propertyPrefix);
        }
        this.policyEngineOptions = policyEngineOptions;
        this.useRangerGroups = this.getBoolean(this.propertyPrefix + ".use.rangerGroups", false);
        this.useOnlyRangerGroups = this.getBoolean(this.propertyPrefix + ".use.only.rangerGroups", false);
        this.convertEmailToUsername = this.getBoolean(this.propertyPrefix + ".convert.emailToUser", false);
        this.enableImplicitUserStoreEnricher = this.useRangerGroups || this.convertEmailToUsername || this.getBoolean(this.propertyPrefix + ".enable.implicit.userstore.enricher", false);
        this.enableImplicitGdsInfoEnricher = this.getBoolean(this.propertyPrefix + ".enable.implicit.gdsinfo.enricher", true);
        LOG.info("{}", (Object)policyEngineOptions);
    }

    public RangerPluginConfig(String serviceType, String serviceName, String appId, Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && value != null) {
                this.set(String.valueOf(key), String.valueOf(value));
            }
        }));
        this.serviceType = serviceType;
        this.appId = StringUtils.isEmpty((String)appId) ? serviceType : appId;
        this.propertyPrefix = "ranger.plugin." + serviceType;
        this.serviceName = StringUtils.isEmpty((String)serviceName) ? this.get(this.propertyPrefix + ".service.name") : serviceName;
        String trustedProxyAddressString = this.get(this.propertyPrefix + ".trusted.proxy.ipaddresses");
        String clusterName = this.get(this.propertyPrefix + ".access.cluster.name", "");
        String clusterType = this.get(this.propertyPrefix + ".access.cluster.type", "");
        if (StringUtil.isEmpty(clusterName)) {
            clusterName = this.get(this.propertyPrefix + ".ambari.cluster.name", "");
        }
        if (StringUtil.isEmpty(clusterType)) {
            clusterType = this.get(this.propertyPrefix + ".ambari.cluster.type", "");
        }
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.useForwardedIPAddress = this.getBoolean(this.propertyPrefix + ".use.x-forwarded-for.ipaddress", false);
        this.trustedProxyAddresses = StringUtils.split((String)trustedProxyAddressString, (char)',');
        if (this.trustedProxyAddresses != null) {
            for (int i = 0; i < this.trustedProxyAddresses.length; ++i) {
                this.trustedProxyAddresses[i] = this.trustedProxyAddresses[i].trim();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.use.x-forwarded-for.ipaddress:{}", (Object)this.propertyPrefix, (Object)this.useForwardedIPAddress);
            LOG.debug("{}.trusted.proxy.ipaddresses:[{}]", (Object)this.propertyPrefix, (Object)StringUtils.join((Object[])this.trustedProxyAddresses, (String)", "));
        }
        if (this.useForwardedIPAddress && StringUtils.isBlank((String)trustedProxyAddressString)) {
            LOG.warn("Property {}.use.x-forwarded-for.ipaddress is set to true, and Property {}.trusted.proxy.ipaddresses is not set", (Object)this.propertyPrefix, (Object)this.propertyPrefix);
            LOG.warn("Ranger plugin will trust RemoteIPAddress and treat first X-Forwarded-Address in the access-request as the clientIPAddress");
        }
        this.policyEngineOptions = new RangerPolicyEngineOptions();
        this.policyEngineOptions.configureForPlugin(this, this.propertyPrefix);
        this.useRangerGroups = this.getBoolean(this.propertyPrefix + ".use.rangerGroups", false);
        this.useOnlyRangerGroups = this.getBoolean(this.propertyPrefix + ".use.only.rangerGroups", false);
        this.convertEmailToUsername = this.getBoolean(this.propertyPrefix + ".convert.emailToUser", false);
        this.enableImplicitUserStoreEnricher = this.useRangerGroups || this.convertEmailToUsername || this.getBoolean(this.propertyPrefix + ".enable.implicit.userstore.enricher", false);
        this.enableImplicitGdsInfoEnricher = this.getBoolean(this.propertyPrefix + ".enable.implicit.gdsinfo.enricher", true);
        LOG.info("{}", (Object)this.policyEngineOptions);
    }

    protected RangerPluginConfig(String serviceType, String serviceName, String appId, RangerPluginConfig sourcePluginConfig) {
        this.serviceType = serviceType;
        this.appId = StringUtils.isEmpty((String)appId) ? serviceType : appId;
        this.propertyPrefix = "ranger.plugin." + serviceType;
        this.serviceName = serviceName;
        this.clusterName = sourcePluginConfig.getClusterName();
        this.clusterType = sourcePluginConfig.getClusterType();
        this.useForwardedIPAddress = sourcePluginConfig.isUseForwardedIPAddress();
        this.trustedProxyAddresses = sourcePluginConfig.getTrustedProxyAddresses();
        this.isFallbackSupported = sourcePluginConfig.getIsFallbackSupported();
        this.policyEngineOptions = sourcePluginConfig.getPolicyEngineOptions();
        this.useRangerGroups = sourcePluginConfig.useRangerGroups;
        this.useOnlyRangerGroups = sourcePluginConfig.useOnlyRangerGroups;
        this.convertEmailToUsername = sourcePluginConfig.convertEmailToUsername;
        this.enableImplicitUserStoreEnricher = sourcePluginConfig.enableImplicitUserStoreEnricher;
        this.enableImplicitGdsInfoEnricher = sourcePluginConfig.enableImplicitGdsInfoEnricher;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public boolean isUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public boolean isUseRangerGroups() {
        return this.useRangerGroups;
    }

    public boolean isUseOnlyRangerGroups() {
        return this.useOnlyRangerGroups;
    }

    public boolean isConvertEmailToUsername() {
        return this.convertEmailToUsername;
    }

    public boolean isEnableImplicitUserStoreEnricher() {
        return this.enableImplicitUserStoreEnricher;
    }

    public boolean isEnableImplicitGdsInfoEnricher() {
        return this.enableImplicitGdsInfoEnricher;
    }

    public boolean getIsFallbackSupported() {
        return this.isFallbackSupported;
    }

    public void setIsFallbackSupported(boolean isFallbackSupported) {
        this.isFallbackSupported = isFallbackSupported;
    }

    public RangerPolicyEngineOptions getPolicyEngineOptions() {
        return this.policyEngineOptions;
    }

    public void setAuditExcludedUsersGroupsRoles(Set<String> users, Set<String> groups, Set<String> roles) {
        this.auditExcludedUsers = CollectionUtils.isEmpty(users) ? Collections.emptySet() : new HashSet<String>(users);
        this.auditExcludedGroups = CollectionUtils.isEmpty(groups) ? Collections.emptySet() : new HashSet<String>(groups);
        this.auditExcludedRoles = CollectionUtils.isEmpty(roles) ? Collections.emptySet() : new HashSet<String>(roles);
        LOG.debug("auditExcludedUsers={}, auditExcludedGroups={}, auditExcludedRoles={}", new Object[]{this.auditExcludedUsers, this.auditExcludedGroups, this.auditExcludedRoles});
    }

    public void setSuperUsersGroups(Set<String> users, Set<String> groups) {
        this.superUsers = CollectionUtils.isEmpty(users) ? new HashSet<String>() : new HashSet<String>(users);
        this.superGroups = CollectionUtils.isEmpty(groups) ? Collections.emptySet() : new HashSet<String>(groups);
        LOG.debug("superUsers={}, superGroups={}", this.superUsers, this.superGroups);
    }

    public void setServiceAdmins(Set<String> users) {
        this.serviceAdmins = CollectionUtils.isEmpty(users) ? Collections.emptySet() : new HashSet<String>(users);
    }

    public boolean isAuditExcludedUser(String userName) {
        return this.auditExcludedUsers.contains(userName);
    }

    public boolean hasAuditExcludedGroup(Set<String> userGroups) {
        return userGroups != null && !userGroups.isEmpty() && !this.auditExcludedGroups.isEmpty() && CollectionUtils.containsAny(userGroups, this.auditExcludedGroups);
    }

    public boolean hasAuditExcludedRole(Set<String> userRoles) {
        return userRoles != null && !userRoles.isEmpty() && !this.auditExcludedRoles.isEmpty() && CollectionUtils.containsAny(userRoles, this.auditExcludedRoles);
    }

    public boolean isSuperUser(String userName) {
        return this.superUsers.contains(userName);
    }

    public boolean hasSuperGroup(Set<String> userGroups) {
        return userGroups != null && !userGroups.isEmpty() && !this.superGroups.isEmpty() && CollectionUtils.containsAny(userGroups, this.superGroups);
    }

    public boolean isServiceAdmin(String userName) {
        return this.serviceAdmins.contains(userName);
    }

    public void addSuperUsers(Collection<String> users) {
        if (users != null) {
            this.superUsers.addAll(users);
        }
    }

    private void addResourcesForServiceType(String serviceType) {
        String auditCfg = "ranger-" + serviceType + "-audit.xml";
        String securityCfg = "ranger-" + serviceType + "-security.xml";
        String sslCfg = "ranger-" + serviceType + "-policymgr-ssl.xml";
        if (!this.addResourceIfReadable(auditCfg)) {
            this.addAuditResource(serviceType);
        }
        if (!this.addResourceIfReadable(securityCfg)) {
            this.addSecurityResource(serviceType);
        }
        if (!this.addResourceIfReadable(sslCfg)) {
            this.addSslConfigResource(serviceType);
        }
    }

    private void addResourcesForServiceName(String serviceType, String serviceName) {
        if (StringUtils.isNotBlank((String)serviceType) && StringUtils.isNotBlank((String)serviceName)) {
            String serviceAuditCfg = "ranger-" + serviceType + "-" + serviceName + "-audit.xml";
            String serviceSecurityCfg = "ranger-" + serviceType + "-" + serviceName + "-security.xml";
            String serviceSslCfg = "ranger-" + serviceType + "-" + serviceName + "-policymgr-ssl.xml";
            this.addResourceIfReadable(serviceAuditCfg);
            this.addResourceIfReadable(serviceSecurityCfg);
            this.addResourceIfReadable(serviceSslCfg);
        }
    }

    private void addSecurityResource(String serviceType) {
        LOG.debug("==> addSecurityResource(Service Type: {}", (Object)serviceType);
        Configuration rangerConf = RangerLegacyConfigBuilder.getSecurityConfig(serviceType);
        if (rangerConf != null) {
            this.addResource(rangerConf);
        } else {
            LOG.debug("Unable to add the Security Config for {}. Plugin won't be enabled!", (Object)serviceType);
        }
        LOG.debug("<= addSecurityResource(Service Type: {}", (Object)serviceType);
    }

    private void addAuditResource(String serviceType) {
        LOG.debug("==> addAuditResource(Service Type: {}", (Object)serviceType);
        try {
            URL url = RangerLegacyConfigBuilder.getAuditConfig(serviceType);
            if (url != null) {
                this.addResource(url);
                LOG.debug("==> addAuditResource() URL {}", (Object)url.getPath());
            }
        }
        catch (Throwable t) {
            LOG.warn("Unable to find Audit Config for {} Auditing not enabled !", (Object)serviceType);
            LOG.debug("Unable to find Audit Config for {} Auditing not enabled !", (Object)serviceType, (Object)t);
        }
        LOG.debug("<== addAuditResource(Service Type: {})", (Object)serviceType);
    }

    private void addSslConfigResource(String serviceType) {
        LOG.debug("==> addSslConfigResource(Service Type: {}", (Object)serviceType);
        try {
            String sslConfigFile = this.get(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.ssl.config.file", serviceType));
            URL url = this.getSSLConfigResource(sslConfigFile);
            if (url != null) {
                this.addResource(url);
                LOG.debug("SSL config file URL: {}", (Object)url.getPath());
            }
        }
        catch (Throwable t) {
            LOG.warn(" Unable to find SSL Configs");
            LOG.debug(" Unable to find SSL Configs");
        }
        LOG.debug("<== addSslConfigResource(Service Type: {})", (Object)serviceType);
    }

    private URL getSSLConfigResource(String fileName) throws Throwable {
        URL ret = null;
        try {
            File f;
            if (fileName != null && (f = new File(fileName)).exists() && f.canRead()) {
                ret = f.toURI().toURL();
            }
        }
        catch (Throwable t) {
            LOG.error("Unable to read SSL configuration file: {}", (Object)fileName);
            throw t;
        }
        return ret;
    }
}

