/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerConfiguration.class);

    protected RangerConfiguration() {
        super(false);
    }

    public boolean addResourceIfReadable(String aResourceName) {
        LOG.debug("==> addResourceIfReadable({})", (Object)aResourceName);
        boolean ret = false;
        URL fUrl = this.getFileLocation(aResourceName);
        if (fUrl != null) {
            LOG.debug("addResourceIfReadable({}): resource file is {}", (Object)aResourceName, (Object)fUrl);
            try {
                this.addResource(fUrl);
                ret = true;
            }
            catch (Exception e) {
                LOG.error("Unable to load the resource name [{}]. Ignoring the resource:{}", (Object)aResourceName, (Object)fUrl);
                LOG.debug("Resource loading failed for {}", (Object)fUrl, (Object)e);
            }
        } else {
            LOG.debug("addResourceIfReadable({}): couldn't find resource file location", (Object)aResourceName);
        }
        LOG.debug("<== addResourceIfReadable({}), result={}", (Object)aResourceName, (Object)ret);
        return ret;
    }

    public Properties getProperties() {
        return this.getProps();
    }

    private URL getFileLocation(String fileName) {
        URL lurl = null;
        if (!StringUtils.isEmpty((String)fileName)) {
            lurl = RangerConfiguration.class.getClassLoader().getResource(fileName);
            if (lurl == null) {
                lurl = RangerConfiguration.class.getClassLoader().getResource("/" + fileName);
            }
            if (lurl == null) {
                File f = new File(fileName);
                if (f.exists()) {
                    try {
                        lurl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Unable to load the resource name [{}]. Ignoring the resource:{}", (Object)fileName, (Object)f.getPath());
                    }
                } else {
                    LOG.debug("Conf file path {} does not exists", (Object)fileName);
                }
            }
        }
        return lurl;
    }
}

