/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.security.KeyStore;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminConfig
extends RangerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminConfig.class);
    private static volatile RangerAdminConfig sInstance;
    private final boolean isFipsEnabled;

    private RangerAdminConfig() {
        this.addAdminResources();
        String storeType = this.get("ranger.keystore.file.type", KeyStore.getDefaultType());
        this.isFipsEnabled = StringUtils.equalsIgnoreCase((String)"bcfks", (String)storeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerAdminConfig getInstance() {
        RangerAdminConfig ret = sInstance;
        if (ret != null) return ret;
        Class<RangerAdminConfig> clazz = RangerAdminConfig.class;
        synchronized (RangerAdminConfig.class) {
            ret = sInstance;
            if (ret != null) return ret;
            sInstance = ret = new RangerAdminConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    public boolean isFipsEnabled() {
        return this.isFipsEnabled;
    }

    private boolean addAdminResources() {
        LOG.debug("==> addAdminResources()");
        String defaultCfg = "ranger-admin-default-site.xml";
        String addlCfg = "ranger-admin-site.xml";
        String coreCfg = "core-site.xml";
        boolean ret = this.addResourceIfReadable(defaultCfg);
        if (!this.addResourceIfReadable(addlCfg)) {
            ret = false;
        }
        if (!this.addResourceIfReadable(coreCfg)) {
            ret = false;
        }
        if (!ret) {
            LOG.error("Could not add ranger-admin resources to RangerAdminConfig.");
        }
        LOG.debug("<== addAdminResources(), result={}", (Object)ret);
        return ret;
    }
}

