/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client.datatype;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.sun.jersey.api.client.ClientResponse;
import java.io.Serializable;
import java.util.List;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RESTResponse
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RESTResponse.class);
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_VALIDATION = 2;
    public static final int STATUS_WARN = 3;
    public static final int STATUS_INFO = 4;
    public static final int STATUS_PARTIAL_SUCCESS = 5;
    public static final int ResponseStatus_MAX = 5;
    private int httpStatusCode;
    private int statusCode;
    private String msgDesc;
    private List<Message> messageList;

    public static RESTResponse fromClientResponse(ClientResponse response) {
        int httpStatus;
        RESTResponse ret = null;
        String jsonString = response == null ? null : (String)response.getEntity(String.class);
        int n = httpStatus = response == null ? 0 : response.getStatus();
        if (!StringUtil.isEmpty(jsonString)) {
            ret = RESTResponse.fromJson(jsonString);
        }
        if (ret == null) {
            ret = new RESTResponse();
        }
        ret.setHttpStatusCode(httpStatus);
        return ret;
    }

    public static RESTResponse fromJson(String jsonString) {
        try {
            return JsonUtilsV2.jsonToObj(jsonString, RESTResponse.class);
        }
        catch (Exception e) {
            LOG.debug("fromJson('{}') failed", (Object)jsonString, (Object)e);
            return null;
        }
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getMsgDesc() {
        return this.msgDesc;
    }

    public void setMsgDesc(String msgDesc) {
        this.msgDesc = msgDesc;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    public String getMessage() {
        return StringUtil.isEmpty(this.msgDesc) ? "HTTP " + this.httpStatusCode : this.msgDesc;
    }

    public String toJson() {
        try {
            return JsonUtilsV2.objToJson(this);
        }
        catch (Exception e) {
            LOG.debug("toJson() failed", (Throwable)e);
            return "";
        }
    }

    public String toString() {
        return this.toJson();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Message
    implements Serializable {
        private String name;
        private String rbKey;
        private String message;
        private Long objectId;
        private String fieldName;

        public static RESTResponse fromJson(String jsonString) {
            try {
                return JsonUtilsV2.jsonToObj(jsonString, RESTResponse.class);
            }
            catch (Exception e) {
                LOG.debug("fromJson('{}') failed", (Object)jsonString, (Object)e);
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRbKey() {
            return this.rbKey;
        }

        public void setRbKey(String rbKey) {
            this.rbKey = rbKey;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Long getObjectId() {
            return this.objectId;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toJson() {
            try {
                return JsonUtilsV2.objToJson(this);
            }
            catch (Exception e) {
                LOG.debug("toJson() failed", (Throwable)e);
                return "";
            }
        }

        public String toString() {
            return this.toJson();
        }
    }
}

