/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedResourcePolicySource
extends AbstractRangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedResourcePolicySource.class);
    private ServicePolicies policies;
    private RangerRoles roles;
    private ServiceTags tags;
    private RangerUserStore userStore;
    private ServiceGdsInfo gdsInfo;
    private String policiesPath;
    private String rolesPath;
    private String tagsPath;
    private String userStorePath;
    private String gdsInfoPath;

    @Override
    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        super.init(serviceName, appId, configPropertyPrefix, config);
        String directory = config.get(configPropertyPrefix + ".policy.source.embedded_resource.path");
        String pathPrefix = (directory == null ? "" : directory) + "/" + appId + "_" + serviceName;
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        this.policiesPath = pathPrefix + ".json";
        this.rolesPath = pathPrefix + "_roles.json";
        this.tagsPath = pathPrefix + "_tag.json";
        this.userStorePath = pathPrefix + "_userstore.json";
        this.gdsInfoPath = pathPrefix + "_gds.json";
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) {
        this.loadPolicies();
        return lastKnownVersion == -1L || this.policies == null || this.policies.getPolicyVersion() == null || !this.policies.getPolicyVersion().equals(lastKnownVersion) ? this.policies : null;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownVersion, long lastActivationTimeInMills) {
        this.loadRoles();
        return lastKnownVersion == -1L || this.roles == null || this.roles.getRoleVersion() == null || !this.roles.getRoleVersion().equals(lastKnownVersion) ? this.roles : null;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) {
        this.loadTags();
        return lastKnownVersion == -1L || this.tags == null || this.tags.getTagVersion() == null || !this.tags.getTagVersion().equals(lastKnownVersion) ? this.tags : null;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) {
        this.loadUserStore();
        return lastKnownVersion == -1L || this.userStore == null || this.userStore.getUserStoreVersion() == null || !this.userStore.getUserStoreVersion().equals(lastKnownVersion) ? this.userStore : null;
    }

    @Override
    public ServiceGdsInfo getGdsInfoIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) {
        this.loadGdsInfo();
        return lastKnownVersion == -1L || this.gdsInfo == null || this.gdsInfo.getGdsVersion() == null || !this.gdsInfo.getGdsVersion().equals(lastKnownVersion) ? this.gdsInfo : null;
    }

    private void loadPolicies() {
        if (this.policies == null) {
            try {
                InputStream input = this.getClass().getResourceAsStream(this.policiesPath);
                if (input != null) {
                    this.policies = (ServicePolicies)this.gson.fromJson((Reader)new InputStreamReader(input), ServicePolicies.class);
                }
            }
            catch (Throwable t) {
                LOG.error("loadPolicies(): failed to load policies from {}", (Object)this.policiesPath, (Object)t);
            }
        }
    }

    private void loadRoles() {
        if (this.roles == null) {
            try {
                InputStream input = this.getClass().getResourceAsStream(this.rolesPath);
                if (input != null) {
                    this.roles = (RangerRoles)this.gson.fromJson((Reader)new InputStreamReader(input), RangerRoles.class);
                }
            }
            catch (Throwable t) {
                LOG.error("loadRoles(): failed to load roles from {}", (Object)this.rolesPath, (Object)t);
            }
        }
    }

    private void loadUserStore() {
        if (this.userStore == null) {
            try {
                InputStream input = this.getClass().getResourceAsStream(this.userStorePath);
                if (input != null) {
                    this.userStore = (RangerUserStore)this.gson.fromJson((Reader)new InputStreamReader(input), RangerUserStore.class);
                }
            }
            catch (Throwable t) {
                LOG.error("loadUserStore(): failed to load userstore from {}", (Object)this.userStorePath, (Object)t);
            }
        }
    }

    private void loadTags() {
        if (this.tags == null) {
            try {
                InputStream input = this.getClass().getResourceAsStream(this.tagsPath);
                if (input != null) {
                    this.tags = (ServiceTags)this.gson.fromJson((Reader)new InputStreamReader(input), ServiceTags.class);
                }
            }
            catch (Throwable t) {
                LOG.error("loadTags(): failed to load tags from {}", (Object)this.tagsPath, (Object)t);
            }
        }
    }

    private void loadGdsInfo() {
        if (this.gdsInfo == null) {
            try {
                InputStream input = this.getClass().getResourceAsStream(this.gdsInfoPath);
                if (input != null) {
                    this.gdsInfo = JsonUtilsV2.readValue(new InputStreamReader(input), ServiceGdsInfo.class);
                }
            }
            catch (Throwable t) {
                LOG.error("loadGdsInfo(): failed to load gdsInfo from {}", (Object)this.gdsInfoPath, (Object)t);
            }
        }
    }
}

