/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRangerAdminClient
implements RangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRangerAdminClient.class);
    protected Gson gson;
    private boolean forceNonKerberos;

    @Override
    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        Gson gson = null;
        try {
            gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        }
        catch (Throwable excp) {
            LOG.error("AbstractRangerAdminClient: failed to create GsonBuilder object", excp);
        }
        this.gson = gson;
        this.forceNonKerberos = config.getBoolean(configPropertyPrefix + ".forceNonKerberos", false);
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        return null;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        return null;
    }

    @Override
    public RangerRole createRole(RangerRole request) throws Exception {
        return null;
    }

    @Override
    public void dropRole(String execUser, String roleName) throws Exception {
    }

    @Override
    public List<String> getAllRoles(String execUser) throws Exception {
        return null;
    }

    @Override
    public List<String> getUserRoles(String execUser) throws Exception {
        return null;
    }

    @Override
    public RangerRole getRole(String execUser, String roleName) throws Exception {
        return null;
    }

    @Override
    public void grantRole(GrantRevokeRoleRequest request) throws Exception {
    }

    @Override
    public void revokeRole(GrantRevokeRoleRequest request) throws Exception {
    }

    @Override
    public void grantAccess(GrantRevokeRequest request) throws Exception {
    }

    @Override
    public void revokeAccess(GrantRevokeRequest request) throws Exception {
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        return null;
    }

    @Override
    public List<String> getTagTypes(String tagTypePattern) throws Exception {
        return null;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        return null;
    }

    @Override
    public ServiceGdsInfo getGdsInfoIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        return null;
    }

    public boolean isKerberosEnabled(UserGroupInformation user) {
        boolean ret = this.forceNonKerberos ? false : user != null && UserGroupInformation.isSecurityEnabled() && user.hasKerberosCredentials();
        return ret;
    }
}

