/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.Map;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public class StringTokenReplacer {
    private final char startChar;
    private final char endChar;
    private final char escapeChar;
    private final String tokenPrefix;

    public StringTokenReplacer(char startChar, char endChar, char escapeChar, String tokenPrefix) {
        this.startChar = startChar;
        this.endChar = endChar;
        this.escapeChar = escapeChar;
        this.tokenPrefix = tokenPrefix;
    }

    public static boolean hasToken(String value, char startDelimiterChar, char endDelimiterChar, char escapeChar) {
        return value != null && (value.indexOf(escapeChar) != -1 || value.indexOf(startDelimiterChar) != -1 && value.indexOf(endDelimiterChar) != -1);
    }

    public String replaceTokens(String value, Map<String, Object> tokens) {
        if (tokens == null || tokens.isEmpty() || !StringTokenReplacer.hasToken(value, this.startChar, this.endChar, this.escapeChar)) {
            return value;
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder token = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == this.escapeChar) {
                if (++i < value.length()) {
                    c = value.charAt(i);
                    if (token != null) {
                        if (c != this.escapeChar && c != this.endChar) {
                            token.append(this.escapeChar);
                        }
                        token.append(c);
                        continue;
                    }
                    if (c != this.escapeChar && c != this.startChar) {
                        ret.append(this.escapeChar);
                    }
                    ret.append(c);
                    continue;
                }
                if (token != null) {
                    token.append(this.escapeChar);
                    continue;
                }
                ret.append(this.escapeChar);
                continue;
            }
            if (token == null) {
                if (c == this.startChar) {
                    token = new StringBuilder();
                    continue;
                }
                ret.append(c);
                continue;
            }
            if (c == this.endChar) {
                String rawToken = token.toString();
                if (this.tokenPrefix.isEmpty() || rawToken.startsWith(this.tokenPrefix)) {
                    Object replaced = RangerAccessRequestUtil.getTokenFromContext(tokens, rawToken.substring(this.tokenPrefix.length()));
                    if (replaced != null) {
                        ret.append(replaced);
                    } else {
                        ret.append(this.startChar).append((CharSequence)token).append(this.endChar);
                    }
                } else {
                    ret.append(this.startChar).append((CharSequence)token).append(this.endChar);
                }
                token = null;
                continue;
            }
            token.append(c);
        }
        if (token != null) {
            ret.append(this.startChar).append((CharSequence)token);
        }
        return ret.toString();
    }
}

