/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerValiditySchedule;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceGdsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private List<DataShareInfo> dataShares;
    private List<SharedResourceInfo> resources;
    private List<DatasetInfo> datasets;
    private List<ProjectInfo> projects;
    private List<DataShareInDatasetInfo> dshids;
    private List<DatasetInProjectInfo> dips;
    private Boolean isDelta = Boolean.FALSE;
    private List<ObjectChangeLog> deltaLogs;
    private RangerServiceDef gdsServiceDef;
    private Long gdsLastUpdateTime;
    private Long gdsVersion;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<DataShareInfo> getDataShares() {
        return this.dataShares;
    }

    public void setDataShares(List<DataShareInfo> dataShares) {
        this.dataShares = dataShares;
    }

    public List<SharedResourceInfo> getResources() {
        return this.resources;
    }

    public void setResources(List<SharedResourceInfo> resources) {
        this.resources = resources;
    }

    public List<DatasetInfo> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<DatasetInfo> datasets) {
        this.datasets = datasets;
    }

    public List<ProjectInfo> getProjects() {
        return this.projects;
    }

    public void setProjects(List<ProjectInfo> projects) {
        this.projects = projects;
    }

    public List<DataShareInDatasetInfo> getDshids() {
        return this.dshids;
    }

    public void setDshids(List<DataShareInDatasetInfo> dshids) {
        this.dshids = dshids;
    }

    public List<DatasetInProjectInfo> getDips() {
        return this.dips;
    }

    public void setDips(List<DatasetInProjectInfo> dips) {
        this.dips = dips;
    }

    public Boolean getIsDelta() {
        return this.isDelta;
    }

    public void setIsDelta(Boolean delta) {
        this.isDelta = delta == null ? Boolean.FALSE : delta;
    }

    public List<ObjectChangeLog> getDeltaLogs() {
        return this.deltaLogs;
    }

    public void setDeltaLogs(List<ObjectChangeLog> deltaLogs) {
        this.deltaLogs = deltaLogs;
    }

    public RangerServiceDef getGdsServiceDef() {
        return this.gdsServiceDef;
    }

    public void setGdsServiceDef(RangerServiceDef gdsServiceDef) {
        this.gdsServiceDef = gdsServiceDef;
    }

    public Long getGdsLastUpdateTime() {
        return this.gdsLastUpdateTime;
    }

    public void setGdsLastUpdateTime(Long gdsLastUpdateTime) {
        this.gdsLastUpdateTime = gdsLastUpdateTime;
    }

    public Long getGdsVersion() {
        return this.gdsVersion;
    }

    public void setGdsVersion(Long gdsVersion) {
        this.gdsVersion = gdsVersion;
    }

    public void dedupStrings() {
    }

    public void addDataShare(DataShareInfo dataShare) {
        if (this.dataShares == null) {
            this.dataShares = new ArrayList<DataShareInfo>();
        }
        this.dataShares.add(dataShare);
    }

    public void addResource(SharedResourceInfo resource) {
        if (this.resources == null) {
            this.resources = new ArrayList<SharedResourceInfo>();
        }
        this.resources.add(resource);
    }

    public void addDataset(DatasetInfo dataset) {
        if (this.datasets == null) {
            this.datasets = new ArrayList<DatasetInfo>();
        }
        this.datasets.add(dataset);
    }

    public void addProject(ProjectInfo project) {
        if (this.projects == null) {
            this.projects = new ArrayList<ProjectInfo>();
        }
        this.projects.add(project);
    }

    public void addDataShareInDataset(DataShareInDatasetInfo dshid) {
        if (this.dshids == null) {
            this.dshids = new ArrayList<DataShareInDatasetInfo>();
        }
        this.dshids.add(dshid);
    }

    public void addDatasetInProjectInfo(DatasetInProjectInfo dip) {
        if (this.dips == null) {
            this.dips = new ArrayList<DatasetInProjectInfo>();
        }
        this.dips.add(dip);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("ServiceGdsInfo={");
        sb.append("serviceName={").append(this.serviceName).append("}");
        sb.append(", dataShares=[");
        if (this.dataShares != null) {
            for (DataShareInfo dataShare : this.dataShares) {
                dataShare.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append(", datasets=[");
        if (this.datasets != null) {
            for (DatasetInfo dataset : this.datasets) {
                dataset.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append(", projects=[");
        if (this.projects != null) {
            for (ProjectInfo project : this.projects) {
                project.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append(", dshids=[");
        if (this.dshids != null) {
            for (DataShareInDatasetInfo dshid : this.dshids) {
                dshid.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append(", dshInDs=[");
        if (this.dips != null) {
            for (DatasetInProjectInfo dip : this.dips) {
                dip.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append(", isDelta={").append(this.isDelta).append("}");
        sb.append(", deltaLogs=[");
        if (this.deltaLogs != null) {
            for (ObjectChangeLog changeLog : this.deltaLogs) {
                changeLog.toString(sb).append(", ");
            }
        }
        sb.append("]");
        sb.append("serviceDef={");
        if (this.gdsServiceDef != null) {
            this.gdsServiceDef.toString(sb);
        }
        sb.append("}");
        sb.append(", gdsLastUpdateTime={").append(this.gdsLastUpdateTime).append("}");
        sb.append(", gdsVersion={").append(this.gdsVersion).append("}");
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ObjectChangeLog {
        public static final Integer CHANGE_TYPE_CREATE = 1;
        public static final Integer CHANGE_TYPE_UPDATE = 2;
        public static final Integer CHANGE_TYPE_DELETE = 3;
        private Integer objectType;
        private Integer objectId;
        private Integer changeType;

        public ObjectChangeLog() {
        }

        public ObjectChangeLog(Integer objectType, Integer objectId, Integer changeType) {
            this.objectType = objectType;
            this.objectId = objectId;
            this.changeType = changeType;
        }

        public Integer getObjectType() {
            return this.objectType;
        }

        public void setObjectType(Integer objectType) {
            this.objectType = objectType;
        }

        public Integer getObjectId() {
            return this.objectId;
        }

        public void setObjectId(Integer objectId) {
            this.objectId = objectId;
        }

        public Integer getChangeType() {
            return this.changeType;
        }

        public void setChangeType(Integer changeType) {
            this.changeType = changeType;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("ObjectChangeLog={").append("objectType=").append(this.objectType).append(", objectId=").append(this.objectId).append(", changeType=").append(this.changeType).append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DatasetInProjectInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long datasetId;
        private Long projectId;
        private RangerGds.GdsShareStatus status;
        private RangerValiditySchedule validitySchedule;
        private Set<String> profiles;

        public Long getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(Long datasetId) {
            this.datasetId = datasetId;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public void setProjectId(Long projectId) {
            this.projectId = projectId;
        }

        public RangerGds.GdsShareStatus getStatus() {
            return this.status;
        }

        public void setStatus(RangerGds.GdsShareStatus status) {
            this.status = status;
        }

        public RangerValiditySchedule getValiditySchedule() {
            return this.validitySchedule;
        }

        public void setValiditySchedule(RangerValiditySchedule validitySchedule) {
            this.validitySchedule = validitySchedule;
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(Set<String> profiles) {
            this.profiles = profiles;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("DatasetInProjectInfo={").append("datasetId=").append(this.datasetId).append(", projectId=").append(this.projectId).append(", status=").append((Object)this.status).append(", validitySchedule=").append(this.validitySchedule);
            sb.append(", profiles=[");
            if (this.profiles != null) {
                for (String profile : this.profiles) {
                    sb.append(profile).append(", ");
                }
            }
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataShareInDatasetInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long dataShareId;
        private Long datasetId;
        private RangerGds.GdsShareStatus status;
        private RangerValiditySchedule validitySchedule;
        private Set<String> profiles;

        public Long getDataShareId() {
            return this.dataShareId;
        }

        public void setDataShareId(Long dataShareId) {
            this.dataShareId = dataShareId;
        }

        public Long getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(Long datasetId) {
            this.datasetId = datasetId;
        }

        public RangerGds.GdsShareStatus getStatus() {
            return this.status;
        }

        public void setStatus(RangerGds.GdsShareStatus status) {
            this.status = status;
        }

        public RangerValiditySchedule getValiditySchedule() {
            return this.validitySchedule;
        }

        public void setValiditySchedule(RangerValiditySchedule validitySchedule) {
            this.validitySchedule = validitySchedule;
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(Set<String> profiles) {
            this.profiles = profiles;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("DataShareInDatasetInfo={").append("dataShareId=").append(this.dataShareId).append(", datasetId=").append(this.datasetId).append(", status=").append((Object)this.status).append(", validitySchedule=").append(this.validitySchedule);
            sb.append(", profiles=[");
            if (this.profiles != null) {
                for (String profile : this.profiles) {
                    sb.append(profile).append(", ");
                }
            }
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProjectInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long id;
        private String name;
        private RangerValiditySchedule validitySchedule;
        private List<RangerPolicy> policies;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public RangerValiditySchedule getValiditySchedule() {
            return this.validitySchedule;
        }

        public void setValiditySchedule(RangerValiditySchedule validitySchedule) {
            this.validitySchedule = validitySchedule;
        }

        public List<RangerPolicy> getPolicies() {
            return this.policies;
        }

        public void setPolicies(List<RangerPolicy> policies) {
            this.policies = policies;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("ProjectInfo={").append("id=").append(this.id).append(", name=").append(this.name).append(", validitySchedule=").append(this.validitySchedule);
            sb.append(", policies=[");
            if (this.policies != null) {
                for (RangerPolicy policy : this.policies) {
                    policy.toString(sb).append(", ");
                }
            }
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DatasetInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long id;
        private String name;
        private RangerValiditySchedule validitySchedule;
        private List<RangerPolicy> policies;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public RangerValiditySchedule getValiditySchedule() {
            return this.validitySchedule;
        }

        public void setValiditySchedule(RangerValiditySchedule validitySchedule) {
            this.validitySchedule = validitySchedule;
        }

        public List<RangerPolicy> getPolicies() {
            return this.policies;
        }

        public void setPolicies(List<RangerPolicy> policies) {
            this.policies = policies;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("DatasetInfo={").append("id=").append(this.id).append(", name=").append(this.name).append(", validitySchedule=").append(this.validitySchedule);
            sb.append(", policies=[");
            if (this.policies != null) {
                for (RangerPolicy policy : this.policies) {
                    policy.toString(sb).append(", ");
                }
            }
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SharedResourceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long id;
        private String name;
        private Long dataShareId;
        private Map<String, RangerPolicy.RangerPolicyResource> resource;
        private RangerPolicy.RangerPolicyResource subResource;
        private String subResourceType;
        private String conditionExpr;
        private Set<String> accessTypes;
        private RangerPolicy.RangerPolicyItemRowFilterInfo rowFilter;
        private List<RangerGds.RangerGdsMaskInfo> subResourceMasks;
        private Set<String> profiles;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Long getDataShareId() {
            return this.dataShareId;
        }

        public void setDataShareId(Long dataShareId) {
            this.dataShareId = dataShareId;
        }

        public Map<String, RangerPolicy.RangerPolicyResource> getResource() {
            return this.resource;
        }

        public void setResource(Map<String, RangerPolicy.RangerPolicyResource> resource) {
            this.resource = resource;
        }

        public RangerPolicy.RangerPolicyResource getSubResource() {
            return this.subResource;
        }

        public void setSubResource(RangerPolicy.RangerPolicyResource subResource) {
            this.subResource = subResource;
        }

        public String getSubResourceType() {
            return this.subResourceType;
        }

        public void setSubResourceType(String subResourceType) {
            this.subResourceType = subResourceType;
        }

        public String getConditionExpr() {
            return this.conditionExpr;
        }

        public void setConditionExpr(String conditionExpr) {
            this.conditionExpr = conditionExpr;
        }

        public Set<String> getAccessTypes() {
            return this.accessTypes;
        }

        public void setAccessTypes(Set<String> accessTypes) {
            this.accessTypes = accessTypes;
        }

        public RangerPolicy.RangerPolicyItemRowFilterInfo getRowFilter() {
            return this.rowFilter;
        }

        public void setRowFilter(RangerPolicy.RangerPolicyItemRowFilterInfo rowFilter) {
            this.rowFilter = rowFilter;
        }

        public List<RangerGds.RangerGdsMaskInfo> getSubResourceMasks() {
            return this.subResourceMasks;
        }

        public void setSubResourceMasks(List<RangerGds.RangerGdsMaskInfo> subResourceMasks) {
            this.subResourceMasks = subResourceMasks;
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(Set<String> profiles) {
            this.profiles = profiles;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("SharedResourceInfo={").append("id=").append(this.id).append(", name=").append(this.name).append(", dataShareId=").append(this.dataShareId).append(", resource=").append(this.resource).append(", subResource=").append(this.subResource).append(", subResourceType=").append(this.subResourceType).append(", conditionExpr=").append(this.conditionExpr);
            sb.append(", accessTypes=[");
            if (this.accessTypes != null) {
                for (String accessType : this.accessTypes) {
                    sb.append(accessType).append(", ");
                }
            }
            sb.append("]");
            sb.append(", rowFilter=");
            if (this.rowFilter != null) {
                this.rowFilter.toString(sb);
            }
            sb.append(", subResourceMasks=[");
            if (this.subResourceMasks != null) {
                for (RangerGds.RangerGdsMaskInfo maskInfo : this.subResourceMasks) {
                    maskInfo.toString(sb).append(' ');
                }
            }
            sb.append("]");
            sb.append(", profiles=[");
            if (this.profiles != null) {
                for (String profile : this.profiles) {
                    sb.append(profile).append(", ");
                }
            }
            sb.append("]");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataShareInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long id;
        private String name;
        private String zoneName;
        private String conditionExpr;
        private Set<String> defaultAccessTypes;
        private List<RangerGds.RangerGdsMaskInfo> defaultTagMasks;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public String getConditionExpr() {
            return this.conditionExpr;
        }

        public void setConditionExpr(String conditionExpr) {
            this.conditionExpr = conditionExpr;
        }

        public Set<String> getDefaultAccessTypes() {
            return this.defaultAccessTypes;
        }

        public void setDefaultAccessTypes(Set<String> defaultAccessTypes) {
            this.defaultAccessTypes = defaultAccessTypes;
        }

        public List<RangerGds.RangerGdsMaskInfo> getDefaultTagMasks() {
            return this.defaultTagMasks;
        }

        public void setDefaultTagMasks(List<RangerGds.RangerGdsMaskInfo> defaultTagMasks) {
            this.defaultTagMasks = defaultTagMasks;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("DataShareInfo={").append("id=").append(this.id).append(", name=").append(this.name).append(", zoneName=").append(this.zoneName);
            sb.append(", conditionExpr=").append(this.conditionExpr);
            sb.append(", defaultAccessTypes=[");
            if (this.defaultAccessTypes != null) {
                for (String defaultAccessType : this.defaultAccessTypes) {
                    sb.append(defaultAccessType).append(", ");
                }
            }
            sb.append("]");
            sb.append(", defaultTagMasks=[");
            if (this.defaultTagMasks != null) {
                for (RangerGds.RangerGdsMaskInfo defaultTagMask : this.defaultTagMasks) {
                    defaultTagMask.toString(sb).append(", ");
                }
            }
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }
}

