/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerRequestScriptEvaluator;
import org.apache.ranger.plugin.util.ScriptEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRequestExprResolver {
    public static final String EXPRESSION_START = "${{";
    private static final Logger LOG = LoggerFactory.getLogger(RangerRequestExprResolver.class);
    private static final String REGEX_GROUP_EXPR = "expr";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{\\{(?<expr>.*?)\\}\\}");
    private final String str;
    private final String serviceType;
    private final boolean hasTokens;

    public RangerRequestExprResolver(String str, String serviceType) {
        this.str = str;
        this.serviceType = serviceType;
        this.hasTokens = RangerRequestExprResolver.hasExpressions(str);
        LOG.debug("RangerRequestExprResolver({}): hasTokens={}", (Object)str, (Object)this.hasTokens);
    }

    public static boolean hasExpressions(String str) {
        boolean ret = false;
        if (str != null) {
            Matcher matcher = PATTERN.matcher(str);
            ret = matcher.find();
        }
        return ret;
    }

    public static boolean hasUserAttributeInExpression(String str) {
        boolean ret = false;
        if (str != null) {
            Matcher matcher = PATTERN.matcher(str);
            while (matcher.find()) {
                String expr = matcher.group(REGEX_GROUP_EXPR);
                if (!RangerRequestScriptEvaluator.hasUserAttributeReference(expr)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean hasGroupAttributeInExpression(String str) {
        boolean ret = false;
        if (str != null) {
            Matcher matcher = PATTERN.matcher(str);
            while (matcher.find()) {
                String expr = matcher.group(REGEX_GROUP_EXPR);
                if (!RangerRequestScriptEvaluator.hasGroupAttributeReference(expr)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean hasUserGroupAttributeInExpression(String str) {
        boolean ret = false;
        if (str != null) {
            Matcher matcher = PATTERN.matcher(str);
            while (matcher.find()) {
                String expr = matcher.group(REGEX_GROUP_EXPR);
                if (!RangerRequestScriptEvaluator.hasUserGroupAttributeReference(expr)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean hasUserAttributeInExpression(Collection<String> values) {
        boolean ret = false;
        if (values != null) {
            for (String value : values) {
                if (!RangerRequestExprResolver.hasUserAttributeInExpression(value)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean hasGroupAttributeInExpression(Collection<String> values) {
        boolean ret = false;
        if (values != null) {
            for (String value : values) {
                if (!RangerRequestExprResolver.hasGroupAttributeInExpression(value)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static boolean hasUserGroupAttributeInExpression(Collection<String> values) {
        boolean ret = false;
        if (values != null) {
            for (String value : values) {
                if (!RangerRequestExprResolver.hasUserGroupAttributeInExpression(value)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String resolveExpressions(Map<String, Object> exprValues) {
        String ret = this.str;
        if (this.hasTokens) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = PATTERN.matcher(this.str);
            while (matcher.find()) {
                String expr = matcher.group(REGEX_GROUP_EXPR);
                Object oVal = exprValues.get(expr);
                String val = oVal == null ? "" : Objects.toString(oVal);
                matcher.appendReplacement(sb, val);
            }
            matcher.appendTail(sb);
            ret = sb.toString();
            LOG.debug("RangerRequestExprResolver.resolveExpressions({}): ret={}", (Object)this.str, (Object)ret);
        }
        return ret;
    }

    public String resolveExpressions(RangerAccessRequest request) {
        String ret = this.str;
        if (this.hasTokens) {
            ScriptEngine scriptEngine = ScriptEngineUtil.createScriptEngine(this.serviceType);
            RangerRequestScriptEvaluator scriptEvaluator = new RangerRequestScriptEvaluator(request, scriptEngine, RangerRequestScriptEvaluator.needsJsonCtxEnabled(this.str));
            StringBuffer sb = new StringBuffer();
            Matcher matcher = PATTERN.matcher(this.str);
            while (matcher.find()) {
                String expr = matcher.group(REGEX_GROUP_EXPR);
                Object oVal = scriptEvaluator.evaluateScript(expr);
                String val = oVal == null ? "" : Objects.toString(oVal);
                matcher.appendReplacement(sb, val);
            }
            matcher.appendTail(sb);
            ret = sb.toString();
            LOG.debug("RangerRequestExprResolver.processExpressions({}): ret={}", (Object)this.str, (Object)ret);
        }
        return ret;
    }
}

