/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.ranger.plugin.util.PerfDataRecorder;
import org.apache.ranger.plugin.util.RangerPerfCollectorTracer;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;

public class RangerPerfTracerFactory {
    static volatile ThreadMXBean threadMgmtBean;
    private static boolean isThreadCPUTimeSupported;
    private static boolean isThreadCPUTimeEnabled;

    private RangerPerfTracerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static RangerPerfTracer getPerfTracer(Logger logger, String tag, String data) {
        if (logger.isDebugEnabled() && threadMgmtBean == null) {
            Class<RangerPerfTracerFactory> clazz = RangerPerfTracerFactory.class;
            // MONITORENTER : org.apache.ranger.plugin.util.RangerPerfTracerFactory.class
            if (threadMgmtBean == null) {
                threadMgmtBean = ManagementFactory.getThreadMXBean();
                isThreadCPUTimeSupported = threadMgmtBean.isThreadCpuTimeSupported();
                logger.info("ThreadCPUTimeSupported (by JVM)  = {}", (Object)isThreadCPUTimeSupported);
                isThreadCPUTimeEnabled = threadMgmtBean.isThreadCpuTimeEnabled();
                logger.info("ThreadCPUTimeEnabled  = {}", (Object)isThreadCPUTimeEnabled);
                if (isThreadCPUTimeSupported) {
                    if (!isThreadCPUTimeEnabled) {
                        threadMgmtBean.setThreadCpuTimeEnabled(true);
                        isThreadCPUTimeEnabled = threadMgmtBean.isThreadCpuTimeEnabled();
                    }
                    logger.info("ThreadCPUTimeEnabled  = {}", (Object)isThreadCPUTimeEnabled);
                }
            }
            // MONITOREXIT : clazz
        }
        ThreadInfo threadInfo = null;
        if (isThreadCPUTimeSupported && isThreadCPUTimeEnabled) {
            threadInfo = threadMgmtBean.getThreadInfo(Thread.currentThread().getId());
        }
        if (!PerfDataRecorder.collectStatistics()) return new RangerPerfTracer(logger, tag, data, threadInfo);
        return new RangerPerfCollectorTracer(logger, tag, data, threadInfo);
    }
}

