/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRolesProvider;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRefresher
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyRefresher.class);
    private static final Logger PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private final RangerBasePlugin plugIn;
    private final String serviceType;
    private final String serviceName;
    private final RangerAdminClient rangerAdmin;
    private final RangerRolesProvider rolesProvider;
    private final long pollingIntervalMs;
    private final String cacheFileName;
    private final String cacheDir;
    private final BlockingQueue<DownloadTrigger> policyDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private Timer policyDownloadTimer;
    private long lastKnownVersion = -1L;
    private long lastActivationTimeInMillis;
    private boolean policiesSetInPlugin;
    private boolean serviceDefSetInPlugin;

    public PolicyRefresher(RangerBasePlugin plugIn) {
        LOG.debug("==> PolicyRefresher(serviceName={}).PolicyRefresher()", (Object)plugIn.getServiceName());
        RangerPluginConfig pluginConfig = plugIn.getConfig();
        String propertyPrefix = pluginConfig.getPropertyPrefix();
        this.plugIn = plugIn;
        this.serviceType = plugIn.getServiceType();
        this.serviceName = plugIn.getServiceName();
        this.cacheDir = pluginConfig.get(propertyPrefix + ".policy.cache.dir");
        String appId = StringUtils.isEmpty((String)plugIn.getAppId()) ? this.serviceType : plugIn.getAppId();
        String cacheFilename = String.format("%s_%s.json", appId, this.serviceName);
        cacheFilename = cacheFilename.replace(File.separatorChar, '_');
        this.cacheFileName = cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
        RangerPluginContext pluginContext = plugIn.getPluginContext();
        RangerAdminClient adminClient = pluginContext.getAdminClient();
        this.rangerAdmin = adminClient != null ? adminClient : pluginContext.createAdminClient(pluginConfig);
        this.rolesProvider = new RangerRolesProvider(this.getServiceType(), appId, this.getServiceName(), this.rangerAdmin, this.cacheDir, pluginConfig);
        this.pollingIntervalMs = pluginConfig.getLong(propertyPrefix + ".policy.pollIntervalMs", 30000L);
        this.setName("PolicyRefresher(serviceName=" + this.serviceName + ")-" + this.getId());
        LOG.debug("<== PolicyRefresher(serviceName={}).PolicyRefresher()", (Object)this.serviceName);
    }

    public RangerBasePlugin getPlugin() {
        return this.plugIn;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerAdminClient getRangerAdminClient() {
        return this.rangerAdmin;
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    public void startRefresher() {
        this.loadRoles();
        this.loadPolicy();
        super.start();
        this.policyDownloadTimer = new Timer("policyDownloadTimer", true);
        try {
            this.policyDownloadTimer.schedule((TimerTask)new DownloaderTask(this.policyDownloadQueue), this.pollingIntervalMs, this.pollingIntervalMs);
            LOG.debug("Scheduled policyDownloadRefresher to download policies every {} milliseconds", (Object)this.pollingIntervalMs);
        }
        catch (IllegalStateException exception) {
            LOG.error("Error scheduling policyDownloadTimer:", (Throwable)exception);
            LOG.error("*** Policies will NOT be downloaded every {} milliseconds ***", (Object)this.pollingIntervalMs);
            this.policyDownloadTimer = null;
        }
    }

    public void stopRefresher() {
        Timer policyDownloadTimer = this.policyDownloadTimer;
        this.policyDownloadTimer = null;
        if (policyDownloadTimer != null) {
            policyDownloadTimer.cancel();
        }
        if (super.isAlive()) {
            super.interrupt();
            boolean setInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    LOG.warn("PolicyRefresher(serviceName={}): error while waiting for thread to exit", (Object)this.serviceName, (Object)excp);
                    LOG.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                    setInterrupted = true;
                }
            }
            if (setInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        LOG.debug("==> PolicyRefresher(serviceName={}).run()", (Object)this.serviceName);
        while (true) {
            DownloadTrigger trigger = null;
            try {
                trigger = this.policyDownloadQueue.take();
                this.loadRoles();
                this.loadPolicy();
                continue;
            }
            catch (InterruptedException excp) {
                LOG.info("PolicyRefresher(serviceName={}).run(): interrupted! Exiting thread", (Object)this.serviceName, (Object)excp);
            }
            finally {
                if (trigger == null) continue;
                trigger.signalCompletion();
                continue;
            }
            break;
        }
        LOG.debug("<== PolicyRefresher(serviceName={}).run()", (Object)this.serviceName);
    }

    public void syncPoliciesWithAdmin(DownloadTrigger token) throws InterruptedException {
        this.policyDownloadQueue.put(token);
        token.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCache(ServicePolicies policies) {
        LOG.debug("==> PolicyRefresher(serviceName={}).saveToCache()", (Object)this.serviceName);
        boolean doPreserveDeltas = this.plugIn.getConfig().getBoolean(this.plugIn.getConfig().getPropertyPrefix() + ".preserve.deltas", false);
        if (policies != null) {
            FileWriter writer;
            RangerPerfTracer perf;
            File cacheFile = null;
            File backupCacheFile = null;
            if (this.cacheDir != null) {
                String realCacheDirName = CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) ? this.cacheDir + File.separator + "deltas" : this.cacheDir;
                String backupCacheFileName = this.cacheFileName + "_" + policies.getPolicyVersion();
                String realCacheFileName = CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) ? backupCacheFileName : this.cacheFileName;
                File cacheDirTmp = new File(realCacheDirName);
                if (cacheDirTmp.exists()) {
                    cacheFile = new File(realCacheDirName + File.separator + realCacheFileName);
                } else {
                    try {
                        cacheDirTmp.mkdirs();
                        cacheFile = new File(realCacheDirName + File.separator + realCacheFileName);
                    }
                    catch (SecurityException ex) {
                        LOG.error("Cannot create cache directory", (Throwable)ex);
                    }
                }
                if (CollectionUtils.isEmpty(policies.getPolicyDeltas())) {
                    backupCacheFile = new File(realCacheDirName + File.separator + backupCacheFileName);
                }
            }
            if (cacheFile != null) {
                perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    JsonUtils.objectToWriter(writer, policies);
                }
                catch (Exception excp) {
                    LOG.error("failed to save policies to cache file '{}'", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                            this.deleteOldestVersionCacheFileInCacheDirectory(cacheFile.getParentFile());
                        }
                        catch (Exception excp) {
                            LOG.error("error while closing opened cache file '{}'", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                        }
                    }
                }
                RangerPerfTracer.log(perf);
            }
            if (doPreserveDeltas && backupCacheFile != null) {
                perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                try {
                    writer = new FileWriter(backupCacheFile);
                    Throwable throwable = null;
                    try {
                        JsonUtils.objectToWriter(writer, policies);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)writer).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Writer)writer).close();
                            }
                        }
                    }
                }
                catch (Exception excp) {
                    LOG.error("failed to save policies to cache file '{}'", (Object)backupCacheFile.getAbsolutePath(), (Object)excp);
                }
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.info("policies is null. Nothing to save in cache");
        }
        LOG.debug("<== PolicyRefresher(serviceName={}).saveToCache()", (Object)this.serviceName);
    }

    private void loadPolicy() {
        LOG.debug("==> PolicyRefresher(serviceName={}).loadPolicy()", (Object)this.serviceName);
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicy(serviceName=" + this.serviceName + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: {}, Free memory:{}", (Object)(totalMemory - freeMemory), (Object)freeMemory);
        }
        try {
            ServicePolicies svcPolicies = this.loadPolicyfromPolicyAdmin();
            if (svcPolicies == null && !this.policiesSetInPlugin) {
                svcPolicies = this.loadFromCache();
            }
            if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: {}, Free memory:{}", (Object)(totalMemory - freeMemory), (Object)freeMemory);
            }
            if (svcPolicies != null) {
                this.plugIn.setPolicies(svcPolicies);
                this.policiesSetInPlugin = true;
                this.serviceDefSetInPlugin = false;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = svcPolicies.getPolicyVersion() != null ? svcPolicies.getPolicyVersion() : -1L;
            } else if (!this.policiesSetInPlugin && !this.serviceDefSetInPlugin) {
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (!this.serviceDefSetInPlugin) {
                this.disableCache();
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
            }
        }
        catch (Exception excp) {
            LOG.error("Encountered unexpected exception, ignoring..", (Throwable)excp);
        }
        RangerPerfTracer.log(perf);
        LOG.debug("<== PolicyRefresher(serviceName={}).loadPolicy()", (Object)this.serviceName);
    }

    private ServicePolicies loadPolicyfromPolicyAdmin() throws RangerServiceNotFoundException {
        ServicePolicies svcPolicies;
        LOG.debug("==> PolicyRefresher(serviceName={}).loadPolicyfromPolicyAdmin()", (Object)this.serviceName);
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicyFromPolicyAdmin(serviceName=" + this.serviceName + ")");
        }
        try {
            boolean isUpdated;
            svcPolicies = this.rangerAdmin.getServicePoliciesIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = svcPolicies != null;
            if (isUpdated) {
                long newVersion;
                long l = newVersion = svcPolicies.getPolicyVersion() == null ? -1L : svcPolicies.getPolicyVersion();
                if (!StringUtils.equals((String)this.serviceName, (String)svcPolicies.getServiceName())) {
                    LOG.warn("PolicyRefresher(serviceName={}): ignoring unexpected serviceName '{}' in service-store", (Object)this.serviceName, (Object)svcPolicies.getServiceName());
                    svcPolicies.setServiceName(this.serviceName);
                }
                LOG.info("PolicyRefresher(serviceName={}): found updated version. lastKnownVersion={}; newVersion={}", new Object[]{this.serviceName, this.lastKnownVersion, newVersion});
            } else {
                LOG.debug("PolicyRefresher(serviceName={}).run(): no update found. lastKnownVersion={}", (Object)this.serviceName, (Object)this.lastKnownVersion);
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            LOG.error("PolicyRefresher(serviceName={}): failed to find service. Will clean up local cache of policies ({})", new Object[]{this.serviceName, this.lastKnownVersion, snfe});
            throw snfe;
        }
        catch (Exception excp) {
            LOG.error("PolicyRefresher(serviceName={}): failed to refresh policies. Will continue to use last known version of policies ({})", new Object[]{this.serviceName, this.lastKnownVersion, excp});
            svcPolicies = null;
        }
        RangerPerfTracer.log(perf);
        LOG.debug("<== PolicyRefresher(serviceName={}).loadPolicyfromPolicyAdmin()", (Object)this.serviceName);
        return svcPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServicePolicies loadFromCache() {
        ServicePolicies policies;
        block16: {
            File cacheFile;
            block17: {
                policies = null;
                LOG.debug("==> PolicyRefresher(serviceName={}).loadFromCache()", (Object)this.serviceName);
                File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
                if (cacheFile == null || !cacheFile.isFile() || !cacheFile.canRead()) break block17;
                FileReader reader = null;
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadFromCache(serviceName=" + this.serviceName + ")");
                }
                try {
                    reader = new FileReader(cacheFile);
                    policies = JsonUtils.jsonToObject(reader, ServicePolicies.class);
                    if (policies != null) {
                        if (!StringUtils.equals((String)this.serviceName, (String)policies.getServiceName())) {
                            LOG.warn("ignoring unexpected serviceName '{}' in cache file '{}'", (Object)policies.getServiceName(), (Object)cacheFile.getAbsolutePath());
                            policies.setServiceName(this.serviceName);
                        }
                        this.lastKnownVersion = policies.getPolicyVersion() == null ? -1L : policies.getPolicyVersion();
                    }
                    RangerPerfTracer.log(perf);
                    if (reader != null) {
                    }
                    break block16;
                }
                catch (Exception excp) {
                    LOG.error("failed to load policies from cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                    break block16;
                }
                try {
                    ((Reader)reader).close();
                }
                catch (Exception excp) {
                    LOG.error("error while closing opened cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                }
                break block16;
                finally {
                    RangerPerfTracer.log(perf);
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Exception excp) {
                            LOG.error("error while closing opened cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                        }
                    }
                }
            }
            LOG.warn("cache file does not exist or not readable '{}'", (Object)(cacheFile == null ? null : cacheFile.getAbsolutePath()));
        }
        LOG.debug("<== PolicyRefresher(serviceName={}).loadFromCache()", (Object)this.serviceName);
        return policies;
    }

    private void deleteOldestVersionCacheFileInCacheDirectory(File cacheDirectory) {
        int maxVersionsToPreserve = this.plugIn.getConfig().getInt(this.plugIn.getConfig().getPropertyPrefix() + "max.versions.to.preserve", 1);
        FileFilter logFileFilter = file -> file.getName().matches(".+json_.+");
        File[] filesInParent = cacheDirectory.listFiles(logFileFilter);
        ArrayList<Long> policyVersions = new ArrayList<Long>();
        if (filesInParent != null && filesInParent.length > 0) {
            for (File f : filesInParent) {
                String fileName = f.getName();
                int policyVersionIdx = fileName.lastIndexOf("json_");
                String policyVersionStr = fileName.substring(policyVersionIdx + 5);
                Long policyVersion = Long.valueOf(policyVersionStr);
                policyVersions.add(policyVersion);
            }
        } else {
            LOG.info("No files matching '.+json_*' found");
        }
        if (!policyVersions.isEmpty()) {
            policyVersions.sort((o1, o2) -> {
                if (o1.equals(o2)) {
                    return 0;
                }
                return o1 < o2 ? -1 : 1;
            });
        }
        if (policyVersions.size() > maxVersionsToPreserve) {
            String fileName = this.cacheFileName + "_" + policyVersions.get(0);
            String pathName = cacheDirectory.getAbsolutePath() + File.separator + fileName;
            File toDelete = new File(pathName);
            if (toDelete.exists()) {
                boolean isDeleted = toDelete.delete();
                LOG.debug("file :[{}] is deleted{}", (Object)pathName, (Object)isDeleted);
            } else {
                LOG.info("File: {} does not exist!", (Object)pathName);
            }
        }
    }

    private void disableCache() {
        File cacheFile;
        LOG.debug("==> PolicyRefresher.disableCache(serviceName={})", (Object)this.serviceName);
        File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn("Cleaning up local cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error("Failed to move {} to {}", (Object)cacheFile.getAbsolutePath(), (Object)renamedCacheFile);
            } else {
                LOG.warn("Moved {} to {}", (Object)cacheFile.getAbsolutePath(), (Object)renamedCacheFile);
            }
        } else {
            LOG.debug("No local policy cache found. No need to disable it!");
        }
        LOG.debug("<== PolicyRefresher.disableCache(serviceName={})", (Object)this.serviceName);
    }

    private void loadRoles() {
        LOG.debug("==> PolicyRefresher(serviceName={}).loadRoles()", (Object)this.serviceName);
        this.rolesProvider.loadUserGroupRoles(this.plugIn);
        LOG.debug("<== PolicyRefresher(serviceName={}).loadRoles()", (Object)this.serviceName);
    }
}

