/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class TagPredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        super.addPredicates(filter, predicates);
        this.addPredicateForTagDefId(filter.getParam("tagDefId"), predicates);
        this.addPredicateForTagDefGuid(filter.getParam("tagDefGuid"), predicates);
        this.addPredicateForTagId(filter.getParam("tagId"), predicates);
        this.addPredicateForTagGuid(filter.getParam("tagGuid"), predicates);
        this.addPredicateForTagType(filter.getParam("tagType"), predicates);
        this.addPredicateForResourceId(filter.getParam("resourceId"), predicates);
        this.addPredicateForResourceGuid(filter.getParam("resourceGuid"), predicates);
        this.addPredicateForServiceResourceServiceName(filter.getParam("resourceServiceName"), predicates);
        this.addPredicateForResourceSignature(filter.getParam("resourceSignature"), predicates);
        this.addPredicateForTagResourceMapId(filter.getParam("tagResourceMapId"), predicates);
    }

    private Predicate addPredicateForTagDefId(String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTagDef) {
                RangerTagDef tagDef = (RangerTagDef)object;
                ret1 = StringUtils.equals((String)id, (String)tagDef.getId().toString());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagDefGuid(String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)guid)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTagDef) {
                RangerTagDef tagDef = (RangerTagDef)object;
                ret1 = StringUtils.equals((String)guid, (String)tagDef.getGuid());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagId(String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTag) {
                RangerTag tag = (RangerTag)object;
                ret1 = StringUtils.equals((String)id, (String)tag.getId().toString());
            } else if (object instanceof RangerTagResourceMap) {
                RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                ret1 = StringUtils.equals((String)id, (String)tagResourceMap.getTagId().toString());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagGuid(String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)guid)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTag) {
                RangerTag tag = (RangerTag)object;
                ret1 = StringUtils.equals((String)guid, (String)tag.getGuid());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagType(String type, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)type)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTagDef) {
                RangerTagDef tagDef = (RangerTagDef)object;
                ret1 = StringUtils.equals((String)type, (String)tagDef.getName());
            } else if (object instanceof RangerTag) {
                RangerTag tag = (RangerTag)object;
                ret1 = StringUtils.equals((String)type, (String)tag.getType());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceId(String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerServiceResource) {
                RangerServiceResource resource = (RangerServiceResource)object;
                ret1 = StringUtils.equals((String)id, (String)resource.getId().toString());
            } else if (object instanceof RangerTagResourceMap) {
                RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                ret1 = StringUtils.equals((String)id, (String)tagResourceMap.getId().toString());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceGuid(String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerServiceResource) {
                RangerServiceResource resource = (RangerServiceResource)object;
                ret1 = StringUtils.equals((String)id, (String)resource.getGuid());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceResourceServiceName(String serviceName, List<Predicate> predicates) {
        if (serviceName == null || StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerServiceResource) {
                RangerServiceResource resource = (RangerServiceResource)object;
                ret1 = StringUtils.equals((String)resource.getServiceName(), (String)serviceName);
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(String signature, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)signature)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerServiceResource) {
                RangerServiceResource resource = (RangerServiceResource)object;
                ret1 = StringUtils.equals((String)signature, (String)resource.getResourceSignature());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagResourceMapId(String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1 = false;
            if (object == null) {
                return ret1;
            }
            if (object instanceof RangerTagResourceMap) {
                RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                ret1 = StringUtils.equals((String)id, (String)tagResourceMap.getId().toString());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

