/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.util.SearchFilter;

public class AbstractPredicateUtil {
    public static final Comparator<RangerBaseModelObject> idComparator = (o1, o2) -> {
        Long val1 = o1 != null ? o1.getId() : null;
        Long val2 = o2 != null ? o2.getId() : null;
        return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
    };
    public static final Comparator<RangerServiceDef.RangerResourceDef> resourceLevelComparator = (o1, o2) -> {
        Integer val1 = o1 != null ? o1.getLevel() : null;
        Integer val2 = o2 != null ? o2.getLevel() : null;
        return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
    };
    protected static final Comparator<RangerBaseModelObject> createTimeComparator = (o1, o2) -> {
        Date val1 = o1 != null ? o1.getCreateTime() : null;
        Date val2 = o2 != null ? o2.getCreateTime() : null;
        return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
    };
    protected static final Comparator<RangerBaseModelObject> updateTimeComparator = (o1, o2) -> {
        Date val1 = o1 != null ? o1.getUpdateTime() : null;
        Date val2 = o2 != null ? o2.getUpdateTime() : null;
        return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
    };
    protected static final Comparator<RangerBaseModelObject> serviceDefNameComparator = (o1, o2) -> {
        String val1 = null;
        String val2 = null;
        if (o1 != null) {
            if (o1 instanceof RangerServiceDef) {
                val1 = ((RangerServiceDef)o1).getName();
            } else if (o1 instanceof RangerService) {
                val1 = ((RangerService)o1).getType();
            }
        }
        if (o2 != null) {
            if (o2 instanceof RangerServiceDef) {
                val2 = ((RangerServiceDef)o2).getName();
            } else if (o2 instanceof RangerService) {
                val2 = ((RangerService)o2).getType();
            }
        }
        return ObjectUtils.compare(val1, val2);
    };
    protected static final Comparator<RangerBaseModelObject> serviceNameComparator = (o1, o2) -> {
        String val1 = null;
        String val2 = null;
        if (o1 != null) {
            if (o1 instanceof RangerPolicy) {
                val1 = ((RangerPolicy)o1).getService();
            } else if (o1 instanceof RangerService) {
                val1 = ((RangerService)o1).getType();
            }
        }
        if (o2 != null) {
            if (o2 instanceof RangerPolicy) {
                val2 = ((RangerPolicy)o2).getService();
            } else if (o2 instanceof RangerService) {
                val2 = ((RangerService)o2).getType();
            }
        }
        return ObjectUtils.compare(val1, val2);
    };
    protected static final Comparator<RangerBaseModelObject> policyNameComparator = (o1, o2) -> {
        String val1 = o1 instanceof RangerPolicy ? ((RangerPolicy)o1).getName() : null;
        String val2 = o2 instanceof RangerPolicy ? ((RangerPolicy)o2).getName() : null;
        return ObjectUtils.compare((Comparable)((Object)val1), (Comparable)((Object)val2));
    };
    protected static final Comparator<RangerBaseModelObject> zoneNameComparator = (o1, o2) -> {
        String val1 = o1 instanceof RangerSecurityZone ? ((RangerSecurityZone)o1).getName() : null;
        String val2 = o2 instanceof RangerSecurityZone ? ((RangerSecurityZone)o2).getName() : null;
        return ObjectUtils.compare((Comparable)((Object)val1), (Comparable)((Object)val2));
    };
    private static final Map<String, Comparator<RangerBaseModelObject>> sorterMap = new HashMap<String, Comparator<RangerBaseModelObject>>();

    public void applyFilter(List<? extends RangerBaseModelObject> objList, SearchFilter filter) {
        boolean isDesc;
        if (CollectionUtils.isEmpty(objList)) {
            return;
        }
        Predicate pred = this.getPredicate(filter);
        if (pred != null) {
            CollectionUtils.filter(objList, (Predicate)pred);
        }
        ReverseComparator sorter = this.getSorter(filter);
        boolean bl = isDesc = filter.getSortType() != null && "desc".equalsIgnoreCase(filter.getSortType());
        if (sorter != null) {
            objList.sort(isDesc ? new ReverseComparator(sorter) : sorter);
        } else if (isDesc) {
            Collections.reverse(objList);
        }
    }

    public Predicate getPredicate(SearchFilter filter) {
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.addPredicates(filter, predicates);
        return CollectionUtils.isEmpty(predicates) ? null : PredicateUtils.allPredicate(predicates);
    }

    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForServiceType(filter.getParam("serviceType"), predicates);
        this.addPredicateForServiceTypeId(filter.getParam("serviceTypeId"), predicates);
        this.addPredicateForServiceName(filter.getParam("serviceName"), predicates);
        this.addPredicateForPolicyName(filter.getParam("policyName"), predicates);
        this.addPredicateForPolicyId(filter.getParam("policyId"), predicates);
        this.addPredicateForIsEnabled(filter.getParam("isEnabled"), predicates);
        this.addPredicateForIsRecursive(filter.getParam("isRecursive"), predicates);
        this.addPredicateForTagServiceName(filter.getParam("tagServiceName"), predicates);
        this.addPredicateForUserName(filter.getParam("user"), predicates);
        this.addPredicateForGroupName(filter.getParam("group"), predicates);
        this.addPredicateForRoleName(filter.getParam("role"), predicates);
        this.addPredicateForResources(filter.getParamsWithPrefix("resource:", true), predicates);
        this.addPredicateForPolicyResource(filter.getParam("polResource"), predicates);
        this.addPredicateForPartialPolicyName(filter.getParam("policyNamePartial"), predicates);
        this.addPredicateForResourceSignature(filter.getParam("resourceSignature:"), predicates);
        this.addPredicateForPolicyType(filter.getParam("policyType"), predicates);
        this.addPredicateForPolicyPriority(filter.getParam("policyPriority"), predicates);
        this.addPredicateForPartialPolicyLabels(filter.getParam("policyLabelsPartial"), predicates);
        this.addPredicateForZoneName(filter.getParam("zoneName"), predicates);
        this.addPredicateForPrefixPolicyName(filter.getParam("policyNamePrefix"), predicates);
    }

    public Comparator<RangerBaseModelObject> getSorter(SearchFilter filter) {
        String sortBy;
        String string = sortBy = filter == null ? null : filter.getSortBy();
        if (StringUtils.isEmpty((String)sortBy)) {
            return null;
        }
        return sorterMap.get(sortBy);
    }

    public Predicate createPredicateForResourceSignature(String policySignature) {
        if (StringUtils.isEmpty((String)policySignature)) {
            return null;
        }
        return object -> {
            boolean ret;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret = StringUtils.equals((String)policy.getResourceSignature(), (String)policySignature);
            } else {
                ret = true;
            }
            return ret;
        };
    }

    private Predicate addPredicateForServiceType(String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceType)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerServiceDef) {
                RangerServiceDef serviceDef = (RangerServiceDef)object;
                String svcType = serviceDef.getName();
                ret1 = StringUtils.equals((String)svcType, (String)serviceType);
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceTypeId(String serviceTypeId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceTypeId)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerServiceDef) {
                RangerServiceDef serviceDef = (RangerServiceDef)object;
                Long svcDefId = serviceDef.getId();
                if (svcDefId != null) {
                    ret1 = StringUtils.equals((String)serviceTypeId, (String)svcDefId.toString());
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceName(String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = StringUtils.equals((String)serviceName, (String)policy.getService());
            } else if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                ret1 = StringUtils.equals((String)serviceName, (String)service.getName());
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyName(String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = StringUtils.equals((String)policyName, (String)policy.getName());
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPrefixPolicyName(String policyNamePrefix, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyNamePrefix)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = StringUtils.startsWithIgnoreCase((String)policy.getName(), (String)policyNamePrefix);
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialPolicyName(String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = StringUtils.containsIgnoreCase((String)policy.getName(), (String)policyName);
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyId(String policyId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyId)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                if (policy.getId() != null) {
                    ret1 = StringUtils.equals((String)policyId, (String)policy.getId().toString());
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForUserName(String userName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)userName)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                List[] policyItemsList;
                RangerPolicy policy = (RangerPolicy)object;
                List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                int n = listArray.length;
                for (int i = 0; i < n; ++i) {
                    List policyItemsObj;
                    List policyItems = policyItemsObj = listArray[i];
                    block1: for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                        if (policyItem.getUsers().isEmpty()) continue;
                        for (String user : policyItem.getUsers()) {
                            if (!StringUtils.containsIgnoreCase((String)user, (String)userName)) continue;
                            ret1 = true;
                            continue block1;
                        }
                    }
                    if (!ret1) {
                        continue;
                    }
                    break;
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForGroupName(String groupName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)groupName)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                List[] policyItemsList;
                RangerPolicy policy = (RangerPolicy)object;
                List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                int n = listArray.length;
                for (int i = 0; i < n; ++i) {
                    List policyItemsObj;
                    List policyItems = policyItemsObj = listArray[i];
                    block1: for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                        if (policyItem.getGroups().isEmpty()) continue;
                        for (String group : policyItem.getGroups()) {
                            if (!StringUtils.containsIgnoreCase((String)group, (String)groupName)) continue;
                            ret1 = true;
                            continue block1;
                        }
                    }
                    if (!ret1) {
                        continue;
                    }
                    break;
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForRoleName(String roleName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)roleName)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                List[] policyItemsList;
                RangerPolicy policy = (RangerPolicy)object;
                List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                int n = listArray.length;
                for (int i = 0; i < n; ++i) {
                    List policyItemsObj;
                    List policyItems = policyItemsObj = listArray[i];
                    block1: for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                        if (policyItem.getRoles().isEmpty()) continue;
                        for (String role : policyItem.getRoles()) {
                            if (!StringUtils.containsIgnoreCase((String)role, (String)roleName)) continue;
                            ret1 = true;
                            continue block1;
                        }
                    }
                    if (!ret1) {
                        continue;
                    }
                    break;
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsEnabled(String status, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)status)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerBaseModelObject) {
                RangerBaseModelObject obj = (RangerBaseModelObject)object;
                ret1 = Boolean.parseBoolean(status) ? obj.getIsEnabled() : obj.getIsEnabled() == false;
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResources(Map<String, String> resources, List<Predicate> predicates) {
        if (MapUtils.isEmpty(resources)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                if (!MapUtils.isEmpty(policy.getResources())) {
                    int numFound = 0;
                    for (String name : resources.keySet()) {
                        boolean isMatch = false;
                        RangerPolicy.RangerPolicyResource policyResource = policy.getResources().get(name);
                        if (policyResource != null && !CollectionUtils.isEmpty(policyResource.getValues())) {
                            String val = (String)resources.get(name);
                            if (policyResource.getValues().contains(val)) {
                                isMatch = true;
                            } else {
                                for (String policyResourceValue : policyResource.getValues()) {
                                    if (!FilenameUtils.wildcardMatch((String)val, (String)policyResourceValue)) continue;
                                    isMatch = true;
                                    break;
                                }
                            }
                        }
                        if (!isMatch) break;
                        ++numFound;
                    }
                    ret1 = numFound == resources.size();
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyResource(String resourceValue, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)resourceValue)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                Map<String, RangerPolicy.RangerPolicyResource> policyResources = policy.getResources();
                if (MapUtils.isNotEmpty(policyResources)) {
                    block0: for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResources.entrySet()) {
                        RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
                        if (policyResource == null || !CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
                        for (String policyResoureValue : policyResource.getValues()) {
                            if (!StringUtils.containsIgnoreCase((String)policyResoureValue, (String)resourceValue)) continue;
                            ret1 = true;
                            continue block0;
                        }
                    }
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsRecursive(String isRecursiveStr, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)isRecursiveStr)) {
            return null;
        }
        boolean isRecursive = Boolean.parseBoolean(isRecursiveStr);
        Predicate ret = object -> {
            RangerPolicy policy;
            if (object == null) {
                return false;
            }
            boolean ret1 = true;
            if (object instanceof RangerPolicy && !MapUtils.isEmpty((policy = (RangerPolicy)object).getResources())) {
                for (Map.Entry<String, RangerPolicy.RangerPolicyResource> e : policy.getResources().entrySet()) {
                    RangerPolicy.RangerPolicyResource resValue = e.getValue();
                    if (resValue.getIsRecursive() == null) {
                        ret1 = !isRecursive;
                    } else {
                        boolean bl = ret1 = resValue.getIsRecursive() == isRecursive;
                    }
                    if (!ret1) continue;
                    break;
                }
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagServiceName(String tagServiceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)tagServiceName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerService) {
                RangerService service = (RangerService)object;
                ret1 = StringUtils.equals((String)tagServiceName, (String)service.getTagService());
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(String signature, List<Predicate> predicates) {
        Predicate ret = this.createPredicateForResourceSignature(signature);
        if (predicates != null && ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyType(String policyType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyType)) {
            return null;
        }
        Predicate ret = object -> {
            RangerPolicy policy;
            if (object == null) {
                return false;
            }
            boolean ret1 = true;
            if (object instanceof RangerPolicy && (policy = (RangerPolicy)object).getPolicyType() != null) {
                ret1 = StringUtils.equalsIgnoreCase((String)policyType, (String)policy.getPolicyType().toString());
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialPolicyLabels(String policyLabels, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyLabels)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = false;
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                for (String label : policy.getPolicyLabels()) {
                    ret1 = StringUtils.containsIgnoreCase((String)label, (String)policyLabels);
                    if (!ret1) continue;
                    return ret1;
                }
            } else {
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyPriority(String policyPriority, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyPriority)) {
            return null;
        }
        Predicate ret = object -> {
            if (object == null) {
                return false;
            }
            boolean ret1 = true;
            if (object instanceof RangerPolicy) {
                int priority;
                RangerPolicy policy = (RangerPolicy)object;
                int n = priority = policy.getPolicyPriority() != null ? policy.getPolicyPriority() : 0;
                ret1 = priority == 0 ? StringUtils.equalsIgnoreCase((String)policyPriority, (String)"NORMAL") || StringUtils.equalsIgnoreCase((String)policyPriority, (String)Integer.toString(priority)) : (priority == 1 ? StringUtils.equalsIgnoreCase((String)policyPriority, (String)"OVERRIDE") || StringUtils.equalsIgnoreCase((String)policyPriority, (String)Integer.toString(priority)) : false);
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForZoneName(String zoneName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)zoneName)) {
            return null;
        }
        Predicate ret = object -> {
            boolean ret1;
            if (object == null) {
                return false;
            }
            if (object instanceof RangerPolicy) {
                RangerPolicy policy = (RangerPolicy)object;
                ret1 = policy.getZoneName() != null ? StringUtils.equals((String)zoneName, (String)policy.getZoneName()) : StringUtils.isEmpty((String)zoneName);
            } else {
                if (object instanceof RangerSecurityZone) {
                    RangerSecurityZone securityZone = (RangerSecurityZone)object;
                    return StringUtils.equals((String)securityZone.getName(), (String)zoneName);
                }
                ret1 = true;
            }
            return ret1;
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    static {
        sorterMap.put("serviceType", serviceDefNameComparator);
        sorterMap.put("serviceTypeId", idComparator);
        sorterMap.put("serviceName", serviceNameComparator);
        sorterMap.put("policyName", policyNameComparator);
        sorterMap.put("policyId", idComparator);
        sorterMap.put("createTime", createTimeComparator);
        sorterMap.put("updateTime", updateTimeComparator);
        sorterMap.put("zoneId", idComparator);
        sorterMap.put("zoneName", zoneNameComparator);
    }

    private static class ReverseComparator
    implements Comparator<RangerBaseModelObject> {
        private final Comparator<RangerBaseModelObject> comparator;

        ReverseComparator(Comparator<RangerBaseModelObject> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            return this.comparator.compare(o2, o1);
        }
    }
}

