/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerChainedPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerChainedPlugin.class);
    protected final RangerBasePlugin rootPlugin;
    protected final String serviceType;
    protected final String serviceName;
    protected final RangerBasePlugin plugin;
    protected final boolean skipAccessCheckIfAlreadyDetermined;

    protected RangerChainedPlugin(RangerBasePlugin rootPlugin, String serviceType, String serviceName) {
        LOG.info("RangerChainedPlugin({}, {})", (Object)serviceType, (Object)serviceName);
        this.rootPlugin = rootPlugin;
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.plugin = this.buildChainedPlugin(serviceType, serviceName, rootPlugin.getAppId());
        RangerPluginConfig rootPluginConfig = rootPlugin.getPluginContext().getConfig();
        this.skipAccessCheckIfAlreadyDetermined = rootPluginConfig.getBoolean(rootPluginConfig.getPropertyPrefix() + ".bypass.chained.plugin.evaluation.if.access.is.determined", false);
    }

    public void init() {
        LOG.info("==> RangerChainedPlugin.init({}, {})", (Object)this.serviceType, (Object)this.serviceName);
        this.plugin.init();
        LOG.info("<== RangerChainedPlugin.init({}, {})", (Object)this.serviceType, (Object)this.serviceName);
    }

    public abstract RangerAccessResult isAccessAllowed(RangerAccessRequest var1);

    public abstract Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> var1);

    public abstract RangerResourceACLs getResourceACLs(RangerAccessRequest var1);

    public abstract RangerResourceACLs getResourceACLs(RangerAccessRequest var1, Integer var2);

    public boolean isAuthorizeOnlyWithChainedPlugin() {
        return false;
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request) {
        return null;
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request) {
        return null;
    }

    protected RangerBasePlugin buildChainedPlugin(String serviceType, String serviceName, String appId) {
        return new RangerBasePlugin(serviceType, serviceName, appId);
    }
}

