/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerURLResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerURLResourceMatcher.class);
    public static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    boolean policyIsRecursive;
    char pathSeparatorChar = (char)47;

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, char pathSeparatorChar, IOCase caseSensitivity) {
        boolean ret = false;
        String url = StringUtils.trim((String)pathToCheck);
        if (!StringUtils.isEmpty((String)url) && RangerURLResourceMatcher.isPathURLType(url)) {
            String scheme = RangerURLResourceMatcher.getScheme(url);
            if (StringUtils.isEmpty((String)scheme)) {
                return ret;
            }
            String path = RangerURLResourceMatcher.getPathWithOutScheme(url);
            Object[] pathElements = StringUtils.split((String)path, (char)pathSeparatorChar);
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder(scheme);
                if (pathToCheck.charAt(0) == pathSeparatorChar) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                if (!ret) {
                    boolean isEndsWithPathSeparator = url.endsWith(Character.toString(pathSeparatorChar));
                    if (!isEndsWithPathSeparator) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        return ret;
    }

    static boolean isPathURLType(String url) {
        boolean ret = false;
        if (url != null) {
            Pattern p1 = Pattern.compile(":/{2}");
            Matcher m1 = p1.matcher(url);
            Pattern p2 = Pattern.compile(":/{3,}");
            Matcher m2 = p2.matcher(url);
            ret = m1.find() && !m2.find();
        }
        return ret;
    }

    static String getScheme(String url) {
        return StringUtils.substring((String)url, (int)0, (int)(StringUtils.indexOf((String)url, (String)":") + 3));
    }

    static String getPathWithOutScheme(String url) {
        return StringUtils.substring((String)url, (int)(StringUtils.indexOf((String)url, (String)":") + 2));
    }

    @Override
    public void init() {
        LOG.debug("==> RangerURLResourceMatcher.init()");
        Map<String, String> options = this.resourceDef == null ? null : this.resourceDef.getMatcherOptions();
        this.policyIsRecursive = this.policyResource != null && this.policyResource.getIsRecursive() != false;
        this.pathSeparatorChar = ServiceDefUtil.getCharOption(options, OPTION_PATH_SEPARATOR, '/');
        super.init();
        LOG.debug("<== RangerURLResourceMatcher.init()");
    }

    @Override
    protected RangerAbstractResourceMatcher.ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        resourceMatchers.sort(new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new RangerAbstractResourceMatcher.ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        RangerAbstractResourceMatcher.AbstractStringResourceMatcher ret;
        int len;
        if (!this.policyIsRecursive) {
            return super.getMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        if (this.optWildCard && "*".equals(policyValue)) {
            return new RangerAbstractResourceMatcher.CaseInsensitiveStringMatcher("", this.getOptions());
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        if (isWildcardPresent) {
            ret = this.optIgnoreCase ? new CaseInsensitiveURLRecursiveWildcardMatcher(policyValue, this.getOptions(), this.pathSeparatorChar) : new CaseSensitiveURLRecursiveWildcardMatcher(policyValue, this.getOptions(), this.pathSeparatorChar);
        } else {
            RangerAbstractResourceMatcher.AbstractStringResourceMatcher abstractStringResourceMatcher = ret = this.optIgnoreCase ? new CaseInsensitiveURLRecursiveMatcher(policyValue, this.getOptions(), this.pathSeparatorChar) : new CaseSensitiveURLRecursiveMatcher(policyValue, this.getOptions(), this.pathSeparatorChar);
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerURLResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }

    static final class CaseInsensitiveURLRecursiveMatcher
    extends RecursiveMatcher {
        CaseInsensitiveURLRecursiveMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
            super(value, options, levelSeparatorChar);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String noSeparator;
            if (this.getNeedsDynamicEval()) {
                String expandedPolicyValue = this.getExpandedValue(evalContext);
                noSeparator = expandedPolicyValue != null ? this.getStringToCompare(expandedPolicyValue) : null;
            } else {
                if (this.valueWithoutSeparator == null && this.value != null) {
                    this.valueWithoutSeparator = this.getStringToCompare(this.value);
                    this.valueWithSeparator = this.valueWithoutSeparator + this.levelSeparatorChar;
                }
                noSeparator = this.valueWithoutSeparator;
            }
            boolean ret = StringUtils.equalsIgnoreCase((String)resourceValue, (String)noSeparator);
            if (!ret && noSeparator != null) {
                String withSeparator = this.getNeedsDynamicEval() ? noSeparator + this.levelSeparatorChar : this.valueWithSeparator;
                ret = StringUtils.startsWithIgnoreCase((String)resourceValue, (String)withSeparator);
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 8 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveURLRecursiveMatcher
    extends RecursiveMatcher {
        CaseSensitiveURLRecursiveMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
            super(value, options, levelSeparatorChar);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String noSeparator;
            if (this.getNeedsDynamicEval()) {
                String expandedPolicyValue = this.getExpandedValue(evalContext);
                noSeparator = expandedPolicyValue != null ? this.getStringToCompare(expandedPolicyValue) : null;
            } else {
                if (this.valueWithoutSeparator == null && this.value != null) {
                    this.valueWithoutSeparator = this.getStringToCompare(this.value);
                    this.valueWithSeparator = this.valueWithoutSeparator + this.levelSeparatorChar;
                }
                noSeparator = this.valueWithoutSeparator;
            }
            boolean ret = StringUtils.equals((String)resourceValue, (String)noSeparator);
            if (!ret && noSeparator != null) {
                String withSeparator = this.getNeedsDynamicEval() ? noSeparator + this.levelSeparatorChar : this.valueWithSeparator;
                ret = StringUtils.startsWith((String)resourceValue, (String)withSeparator);
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }

        @Override
        int getPriority() {
            return 7 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static abstract class RecursiveMatcher
    extends RangerAbstractResourceMatcher.AbstractStringResourceMatcher {
        final char levelSeparatorChar;
        String valueWithoutSeparator;
        String valueWithSeparator;

        RecursiveMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
            super(value, options);
            this.levelSeparatorChar = levelSeparatorChar;
        }

        String getStringToCompare(String policyValue) {
            if (StringUtils.isEmpty((String)policyValue)) {
                return policyValue;
            }
            return policyValue.lastIndexOf(this.levelSeparatorChar) == policyValue.length() - 1 ? policyValue.substring(0, policyValue.length() - 1) : policyValue;
        }
    }

    static final class CaseInsensitiveURLRecursiveWildcardMatcher
    extends RangerAbstractResourceMatcher.AbstractStringResourceMatcher {
        private final char levelSeparatorChar;

        CaseInsensitiveURLRecursiveWildcardMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
            super(value, options);
            this.levelSeparatorChar = levelSeparatorChar;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return RangerURLResourceMatcher.isRecursiveWildCardMatch(resourceValue, this.getExpandedValue(evalContext), this.levelSeparatorChar, IOCase.INSENSITIVE);
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), IOCase.INSENSITIVE);
        }

        @Override
        int getPriority() {
            return 8 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static final class CaseSensitiveURLRecursiveWildcardMatcher
    extends RangerAbstractResourceMatcher.AbstractStringResourceMatcher {
        private final char levelSeparatorChar;

        CaseSensitiveURLRecursiveWildcardMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
            super(value, options);
            this.levelSeparatorChar = levelSeparatorChar;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            return RangerURLResourceMatcher.isRecursiveWildCardMatch(resourceValue, this.getExpandedValue(evalContext), this.levelSeparatorChar, IOCase.SENSITIVE);
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), IOCase.SENSITIVE);
        }

        @Override
        int getPriority() {
            return 7 + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }
}

