/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Collection;
import java.util.Map;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultResourceMatcher.class);

    @Override
    public RangerAccessRequest.ResourceElementMatchType getMatchType(Object resource, RangerAccessRequest.ResourceElementMatchingScope matchingScope, Map<String, Object> evalContext) {
        boolean isPrefixMatch;
        LOG.debug("==> RangerDefaultResourceMatcher.getMatchType({}, {})", resource, evalContext);
        RangerAccessRequest.ResourceElementMatchType ret = RangerAccessRequest.ResourceElementMatchType.NONE;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        boolean bl = isPrefixMatch = matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_PREFIX;
        if (this.isMatchAny || allValuesRequested && !isPrefixMatch) {
            ret = this.isMatchAny ? RangerAccessRequest.ResourceElementMatchType.SELF : RangerAccessRequest.ResourceElementMatchType.NONE;
        } else if (resource instanceof String) {
            String strValue = (String)resource;
            for (ResourceMatcher resourceMatcher : this.resourceMatchers.getResourceMatchers()) {
                RangerAccessRequest.ResourceElementMatchType matchType = resourceMatcher.getMatchType(strValue, matchingScope, evalContext);
                if (matchType != RangerAccessRequest.ResourceElementMatchType.NONE) {
                    ret = matchType;
                }
                if (ret != RangerAccessRequest.ResourceElementMatchType.SELF) continue;
                break;
            }
        } else if (resource instanceof Collection) {
            Collection resourceValues = (Collection)resource;
            for (ResourceMatcher resourceMatcher : this.resourceMatchers.getResourceMatchers()) {
                for (String resourceValue : resourceValues) {
                    RangerAccessRequest.ResourceElementMatchType matchType = resourceMatcher.getMatchType(resourceValue, matchingScope, evalContext);
                    if (matchType != RangerAccessRequest.ResourceElementMatchType.NONE) {
                        ret = matchType;
                    }
                    if (ret != RangerAccessRequest.ResourceElementMatchType.SELF) continue;
                    break;
                }
                if (ret != RangerAccessRequest.ResourceElementMatchType.SELF) continue;
                break;
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        LOG.debug("<== RangerDefaultResourceMatcher.getMatchType({}, {}): {}", new Object[]{resource, evalContext, ret});
        return ret;
    }

    @Override
    public boolean isMatch(Object resource, RangerAccessRequest.ResourceElementMatchingScope matchingScope, Map<String, Object> evalContext) {
        LOG.debug("==> RangerDefaultResourceMatcher.isMatch({}, {})", resource, evalContext);
        RangerAccessRequest.ResourceElementMatchType matchType = this.getMatchType(resource, matchingScope, evalContext);
        boolean ret = ResourceMatcher.isMatch(matchType, matchingScope);
        if (!ret && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : this.policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug("RangerDefaultResourceMatcher.isMatch returns FALSE, (resource={}, policyValues={})", resource, (Object)sb);
        }
        LOG.debug("<== RangerDefaultResourceMatcher.isMatch({}, {}): {}", new Object[]{resource, evalContext, ret});
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultResourceMatcher={");
        super.toString(sb);
        sb.append("}");
        return sb;
    }
}

