/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerCustomConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerCustomConditionEvaluator.class);
    private static final Logger PERF_POLICY_INIT_LOG = RangerPerfTracer.getPerfLogger("policy.init");
    private static final Logger PERF_POLICYITEM_INIT_LOG = RangerPerfTracer.getPerfLogger("policyitem.init");
    private static final Logger PERF_POLICYCONDITION_INIT_LOG = RangerPerfTracer.getPerfLogger("policycondition.init");
    private static final RangerServiceDef.RangerPolicyConditionDef EXPRESSION_CONDITION_DEF = ServiceDefUtil.createImplicitExpressionConditionDef(-1L);

    private RangerCustomConditionEvaluator() {
    }

    public static RangerCustomConditionEvaluator getInstance() {
        return SingletonHolder.s_instance;
    }

    public List<RangerConditionEvaluator> getPolicyConditionEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        RangerPerfTracer perf = null;
        String parentId = "policyId=" + policy.getId();
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_INIT_LOG, "RangerPolicyEvaluator.getPolicyConditionEvaluators(" + parentId + ")");
        }
        List<RangerConditionEvaluator> ret = this.getConditionEvaluators(parentId, policy.getConditions(), serviceDef, options);
        RangerPerfTracer.log(perf);
        return ret;
    }

    public List<RangerConditionEvaluator> getPolicyItemConditionEvaluators(RangerPolicy policy, RangerPolicy.RangerPolicyItem policyItem, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, int policyItemIndex) {
        RangerPerfTracer perf = null;
        String parentId = "policyId=" + policy.getId() + ", policyItemIndex=" + policyItemIndex;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYITEM_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYITEM_INIT_LOG, "RangerPolicyItemEvaluator.getPolicyItemConditionEvaluators(" + parentId + ")");
        }
        List<RangerConditionEvaluator> ret = this.getConditionEvaluators(parentId, policyItem.getConditions(), serviceDef, options);
        RangerPerfTracer.log(perf);
        return ret;
    }

    public List<RangerConditionEvaluator> getConditionEvaluators(String parentId, List<RangerPolicy.RangerPolicyItemCondition> conditions, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        List<RangerConditionEvaluator> ret;
        if (!this.getConditionsDisabledOption(options) && CollectionUtils.isNotEmpty(conditions)) {
            ret = new ArrayList<RangerConditionEvaluator>(conditions.size());
            for (RangerPolicy.RangerPolicyItemCondition condition : conditions) {
                RangerServiceDef.RangerPolicyConditionDef conditionDef = ServiceDefUtil.getConditionDef(serviceDef, condition.getType());
                if (conditionDef == null) {
                    LOG.error("RangerCustomConditionEvaluator.getConditionEvaluators({}): conditionDef '{}' not found. Ignoring the condition", (Object)parentId, (Object)condition.getType());
                    continue;
                }
                RangerConditionEvaluator conditionEvaluator = this.getConditionEvaluator(parentId, condition, conditionDef, serviceDef, options);
                if (conditionEvaluator == null) continue;
                ret.add(conditionEvaluator);
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public RangerConditionEvaluator getConditionEvaluator(String parentId, RangerPolicy.RangerPolicyItemCondition condition, RangerServiceDef.RangerPolicyConditionDef conditionDef, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        RangerConditionEvaluator ret;
        if (condition != null && conditionDef != null && !this.getConditionsDisabledOption(options)) {
            ret = this.newConditionEvaluator(conditionDef.getEvaluator());
            if (ret != null) {
                ret.setServiceDef(serviceDef);
                ret.setConditionDef(conditionDef);
                ret.setPolicyItemCondition(condition);
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_INIT_LOG, "RangerConditionEvaluator.init(" + parentId + ", policyConditionType=" + condition.getType() + ")");
                }
                ret.init();
                RangerPerfTracer.log(perf);
            } else {
                LOG.error("RangerCustomConditionEvaluator.getConditionEvaluator({}): failed to init ConditionEvaluator '{}'; evaluatorClassName='{}'", new Object[]{parentId, condition.getType(), conditionDef.getEvaluator()});
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public RangerConditionEvaluator getExpressionEvaluator(String expression, RangerServiceDef serviceDef) {
        RangerConditionEvaluator ret;
        if (StringUtils.isNotBlank((String)expression)) {
            ret = this.newConditionEvaluator(EXPRESSION_CONDITION_DEF.getEvaluator());
            if (ret != null) {
                ret.setServiceDef(serviceDef);
                ret.setConditionDef(EXPRESSION_CONDITION_DEF);
                ret.setPolicyItemCondition(new RangerPolicy.RangerPolicyItemCondition(EXPRESSION_CONDITION_DEF.getName(), Collections.singletonList(expression)));
                RangerPerfTracer perf = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_INIT_LOG, "RangerConditionEvaluator.init(_expression)");
                ret.init();
                RangerPerfTracer.log(perf);
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private RangerConditionEvaluator newConditionEvaluator(String className) {
        LOG.debug("==> RangerCustomConditionEvaluator.newConditionEvaluator({})", (Object)className);
        RangerConditionEvaluator evaluator = null;
        try {
            Class<?> evaluatorClass = Class.forName(className);
            evaluator = (RangerConditionEvaluator)evaluatorClass.newInstance();
        }
        catch (Throwable t) {
            LOG.error("RangerCustomConditionEvaluator.newConditionEvaluator({}): error instantiating evaluator", (Object)className, (Object)t);
        }
        LOG.debug("<== RangerCustomConditionEvaluator.newConditionEvaluator({}): {}", (Object)className, (Object)evaluator);
        return evaluator;
    }

    private boolean getConditionsDisabledOption(RangerPolicyEngineOptions options) {
        return options != null && options.disableCustomConditions;
    }

    private static class SingletonHolder {
        private static final RangerCustomConditionEvaluator s_instance = new RangerCustomConditionEvaluator();

        private SingletonHolder() {
        }
    }
}

