/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.Set;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsDatasetEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsDshidEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsDshidEvaluator.class);
    private final ServiceGdsInfo.DataShareInDatasetInfo dshid;
    private final GdsDatasetEvaluator datasetEvaluator;
    private final RangerValidityScheduleEvaluator scheduleEvaluator;

    public GdsDshidEvaluator(ServiceGdsInfo.DataShareInDatasetInfo dshid, GdsDatasetEvaluator datasetEvaluator) {
        this.dshid = dshid;
        this.datasetEvaluator = datasetEvaluator;
        this.scheduleEvaluator = dshid.getValiditySchedule() != null ? new RangerValidityScheduleEvaluator(dshid.getValiditySchedule()) : null;
    }

    public Long getDataShareId() {
        return this.dshid.getDataShareId();
    }

    public Long getDatasetId() {
        return this.dshid.getDatasetId();
    }

    public GdsDatasetEvaluator getDatasetEvaluator() {
        return this.datasetEvaluator;
    }

    public boolean isActive() {
        boolean ret;
        boolean bl = ret = this.dshid.getStatus() == RangerGds.GdsShareStatus.ACTIVE;
        if (ret && this.scheduleEvaluator != null) {
            ret = this.scheduleEvaluator.isApplicable(System.currentTimeMillis());
        }
        return ret;
    }

    public boolean isAllowed(RangerAccessRequest request) {
        boolean ret = this.isActive();
        if (ret) {
            // empty if block
        }
        return ret;
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls, boolean isConditional, Set<String> allowedAccessTypes) {
        LOG.debug("==> GdsDshidEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
        isConditional = isConditional || this.scheduleEvaluator != null;
        this.datasetEvaluator.getResourceACLs(request, acls, isConditional, allowedAccessTypes);
        LOG.debug("<== GdsDshidEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
    }
}

