/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.Set;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsProjectEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsDipEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsDipEvaluator.class);
    private final ServiceGdsInfo.DatasetInProjectInfo dip;
    private final GdsProjectEvaluator projectEvaluator;
    private final RangerValidityScheduleEvaluator scheduleEvaluator;

    public GdsDipEvaluator(ServiceGdsInfo.DatasetInProjectInfo dip, GdsProjectEvaluator projectEvaluator) {
        this.dip = dip;
        this.projectEvaluator = projectEvaluator;
        this.scheduleEvaluator = dip.getValiditySchedule() != null ? new RangerValidityScheduleEvaluator(dip.getValiditySchedule()) : null;
    }

    public Long getDatasetId() {
        return this.dip.getDatasetId();
    }

    public Long getProjectId() {
        return this.dip.getProjectId();
    }

    public GdsProjectEvaluator getProjectEvaluator() {
        return this.projectEvaluator;
    }

    public boolean isActive() {
        boolean ret;
        boolean bl = ret = this.dip.getStatus() == RangerGds.GdsShareStatus.ACTIVE;
        if (ret && this.scheduleEvaluator != null) {
            ret = this.scheduleEvaluator.isApplicable(System.currentTimeMillis());
        }
        return ret;
    }

    public boolean isAllowed(RangerAccessRequest request) {
        boolean ret = this.isActive();
        if (ret) {
            // empty if block
        }
        return ret;
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls, boolean isConditional, Set<String> allowedAccessTypes) {
        LOG.debug("==> GdsDipEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
        isConditional = isConditional || this.scheduleEvaluator != null;
        this.projectEvaluator.getResourceACLs(request, acls, isConditional, allowedAccessTypes);
        LOG.debug("<== GdsDipEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
    }
}

