/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.gds.GdsDatasetEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsDshidEvaluator;
import org.apache.ranger.plugin.policyengine.gds.GdsSharedResourceEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerCustomConditionEvaluator;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsDataShareEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(GdsDataShareEvaluator.class);
    public static final GdsDataShareEvalOrderComparator EVAL_ORDER_COMPARATOR = new GdsDataShareEvalOrderComparator();
    private final ServiceGdsInfo.DataShareInfo dsh;
    private final String name;
    private final String zoneName;
    private final RangerConditionEvaluator conditionEvaluator;
    private final Set<GdsSharedResourceEvaluator> evaluators = new TreeSet<GdsSharedResourceEvaluator>(GdsSharedResourceEvaluator.EVAL_ORDER_COMPARATOR);
    private final List<GdsDshidEvaluator> dshidEvaluators = new ArrayList<GdsDshidEvaluator>();

    public GdsDataShareEvaluator(ServiceGdsInfo.DataShareInfo dsh, RangerServiceDefHelper serviceDefHelper) {
        LOG.debug("==> GdsDataShareEvaluator({})", (Object)dsh);
        this.dsh = dsh;
        this.name = StringUtils.isBlank((String)dsh.getName()) ? "" : dsh.getName();
        this.zoneName = StringUtils.isBlank((String)dsh.getZoneName()) ? "" : dsh.getZoneName();
        this.conditionEvaluator = RangerCustomConditionEvaluator.getInstance().getExpressionEvaluator(dsh.getConditionExpr(), serviceDefHelper.getServiceDef());
        LOG.debug("<== GdsDataShareEvaluator({})", (Object)dsh);
    }

    public Long getId() {
        return this.dsh.getId();
    }

    public String getName() {
        return this.name;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public Set<String> getDefaultAccessTypes() {
        return this.dsh.getDefaultAccessTypes();
    }

    public Set<GdsSharedResourceEvaluator> getResourceEvaluators() {
        return this.evaluators;
    }

    public List<GdsDshidEvaluator> getDshidEvaluators() {
        return this.dshidEvaluators;
    }

    public List<GdsSharedResourceEvaluator> getResourceEvaluators(RangerAccessRequest request) {
        boolean isAllowed = this.conditionEvaluator == null || this.conditionEvaluator.isMatched(request);
        List<GdsSharedResourceEvaluator> ret = isAllowed ? this.evaluators.stream().filter(e -> e.isAllowed(request)).collect(Collectors.toList()) : Collections.emptyList();
        return ret;
    }

    public boolean isInDataset(Long datasetId) {
        return this.dshidEvaluators.stream().anyMatch(e -> e.getDatasetId().equals(datasetId) && e.isActive());
    }

    public boolean isInProject(Long projectId) {
        return this.dshidEvaluators.stream().anyMatch(e -> e.getDatasetEvaluator().isInProject(projectId) && e.isActive());
    }

    public void collectDatasets(RangerAccessRequest request, Map<GdsDatasetEvaluator, Set<GdsDataShareEvaluator>> datasetsToEval) {
        boolean isAllowed;
        LOG.debug("==> GdsDataShareEvaluator.collectDatasets({}, {})", (Object)request, datasetsToEval);
        boolean bl = isAllowed = this.conditionEvaluator == null || this.conditionEvaluator.isMatched(request);
        if (isAllowed) {
            this.dshidEvaluators.stream().filter(dshid -> dshid.isAllowed(request) && dshid.getDatasetEvaluator().isActive()).forEach(dshid -> datasetsToEval.computeIfAbsent(dshid.getDatasetEvaluator(), s -> new TreeSet<GdsDataShareEvaluator>(EVAL_ORDER_COMPARATOR)).add(this));
        }
        LOG.debug("<== GdsDataShareEvaluator.collectDatasets({}, {})", (Object)request, datasetsToEval);
    }

    public void getResourceACLs(RangerAccessRequest request, RangerResourceACLs acls) {
        LOG.debug("==> GdsDataShareEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
        List<GdsSharedResourceEvaluator> evaluators = this.getResourceEvaluators(request);
        if (!evaluators.isEmpty()) {
            boolean isConditional = this.conditionEvaluator != null;
            for (GdsSharedResourceEvaluator evaluator : evaluators) {
                evaluator.getResourceACLs(request, acls, isConditional, this.dshidEvaluators);
            }
        }
        LOG.debug("<== GdsDataShareEvaluator.getResourceACLs({}, {})", (Object)request, (Object)acls);
    }

    void addResourceEvaluator(GdsSharedResourceEvaluator evaluator) {
        this.evaluators.add(evaluator);
    }

    void addDshidEvaluator(GdsDshidEvaluator dhidEvaluator) {
        this.dshidEvaluators.add(dhidEvaluator);
    }

    public static class GdsDataShareEvalOrderComparator
    implements Comparator<GdsDataShareEvaluator> {
        @Override
        public int compare(GdsDataShareEvaluator me, GdsDataShareEvaluator other) {
            int ret = 0;
            if (me != null && other != null) {
                ret = me.getName().compareTo(other.dsh.getName());
                if (ret == 0) {
                    ret = me.getId().compareTo(other.getId());
                }
            } else if (me != null) {
                ret = -1;
            } else if (other != null) {
                ret = 1;
            }
            return ret;
        }
    }
}

